/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import javax.validation.constraints.Min;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.jobs.clusters.load-balancers.script")
@Validated
public class ScriptLoadBalancerProperties {
    public static final String PROPERTY_PREFIX = "genie.jobs.clusters.load-balancers.script";
    public static final String ENABLED_PROPERTY = "genie.jobs.clusters.load-balancers.script.enabled";
    public static final String REFRESH_RATE_PROPERTY = "genie.jobs.clusters.load-balancers.script.refreshRate";
    public static final String SCRIPT_FILE_DESTINATION_PROPERTY = "genie.jobs.clusters.load-balancers.script.destination";
    public static final String SCRIPT_FILE_SOURCE_PROPERTY = "genie.jobs.clusters.load-balancers.script.source";
    public static final String TIMEOUT_PROPERTY = "genie.jobs.clusters.load-balancers.script.timeout";
    private boolean enabled;
    @Min(value=1L)
    private @Min(value=1L) long refreshRate = 300000L;
    @NotEmpty
    private String destination = "file:///tmp/genie/loadbalancers/script/destination/";
    @NotEmpty
    private String source = "file:///tmp/genie/loadBalancers/script/source/loadBalance.js";
    @Min(value=1L)
    private @Min(value=1L) long timeout = 5000L;

    public boolean isEnabled() {
        return this.enabled;
    }

    public long getRefreshRate() {
        return this.refreshRate;
    }

    public String getDestination() {
        return this.destination;
    }

    public String getSource() {
        return this.source;
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setRefreshRate(long refreshRate) {
        this.refreshRate = refreshRate;
    }

    public void setDestination(String destination) {
        this.destination = destination;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }
}

