/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.services.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.external.dtos.v4.AgentClientMetadata;
import com.netflix.genie.common.external.dtos.v4.ArchiveStatus;
import com.netflix.genie.common.external.dtos.v4.JobRequest;
import com.netflix.genie.common.external.dtos.v4.JobRequestMetadata;
import com.netflix.genie.common.external.dtos.v4.JobSpecification;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.exceptions.checked.GenieJobResolutionException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieAgentRejectedException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieIdAlreadyExistsException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobSpecificationNotFoundException;
import com.netflix.genie.web.agent.inspectors.InspectionReport;
import com.netflix.genie.web.agent.services.AgentConfigurationService;
import com.netflix.genie.web.agent.services.AgentFilterService;
import com.netflix.genie.web.agent.services.AgentJobService;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.PersistenceService;
import com.netflix.genie.web.dtos.JobSubmission;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.exceptions.checked.IdAlreadyExistsException;
import com.netflix.genie.web.exceptions.checked.NotFoundException;
import com.netflix.genie.web.services.JobResolverService;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotBlank;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;

@Validated
@Transactional
public class AgentJobServiceImpl
implements AgentJobService {
    private static final String AGENT_JOB_SERVICE_METRIC_PREFIX = "genie.services.agentJob.";
    private static final String HANDSHAKE_COUNTER_METRIC_NAME = "genie.services.agentJob.handshake.counter";
    private static final String GET_AGENT_PROPERTIES_COUNTER_METRIC_NAME = "genie.services.agentJob.getAgentProperties.counter";
    private static final String AGENT_VERSION_METRIC_TAG_NAME = "agentVersion";
    private static final String HANDSHAKE_DECISION_METRIC_TAG_NAME = "handshakeDecision";
    private final PersistenceService persistenceService;
    private final JobResolverService jobResolverService;
    private final AgentFilterService agentFilterService;
    private final AgentConfigurationService agentConfigurationService;
    private final MeterRegistry meterRegistry;

    public AgentJobServiceImpl(DataServices dataServices, JobResolverService jobResolverService, AgentFilterService agentFilterService, AgentConfigurationService agentConfigurationService, MeterRegistry meterRegistry) {
        this.persistenceService = dataServices.getPersistenceService();
        this.jobResolverService = jobResolverService;
        this.agentFilterService = agentFilterService;
        this.agentConfigurationService = agentConfigurationService;
        this.meterRegistry = meterRegistry;
    }

    @Override
    public void handshake(@Valid AgentClientMetadata agentClientMetadata) throws GenieAgentRejectedException {
        InspectionReport report;
        HashSet tags = Sets.newHashSet((Object[])new Tag[]{Tag.of((String)AGENT_VERSION_METRIC_TAG_NAME, (String)agentClientMetadata.getVersion().orElse("null"))});
        try {
            report = this.agentFilterService.inspectAgentMetadata(agentClientMetadata);
        }
        catch (Exception e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            this.meterRegistry.counter(HANDSHAKE_COUNTER_METRIC_NAME, (Iterable)tags).increment();
            throw e;
        }
        MetricsUtils.addSuccessTags(tags);
        tags.add(Tag.of((String)HANDSHAKE_DECISION_METRIC_TAG_NAME, (String)report.getDecision().name()));
        this.meterRegistry.counter(HANDSHAKE_COUNTER_METRIC_NAME, (Iterable)tags).increment();
        if (report.getDecision() == InspectionReport.Decision.REJECT) {
            throw new GenieAgentRejectedException("Agent rejected: " + report.getMessage());
        }
    }

    @Override
    public Map<String, String> getAgentProperties(@Valid AgentClientMetadata agentClientMetadata) {
        HashSet tags = Sets.newHashSet((Object[])new Tag[]{Tag.of((String)AGENT_VERSION_METRIC_TAG_NAME, (String)agentClientMetadata.getVersion().orElse("null"))});
        try {
            Map<String, String> agentPropertiesMap = this.agentConfigurationService.getAgentProperties();
            MetricsUtils.addSuccessTags(tags);
            Map<String, String> map = agentPropertiesMap;
            return map;
        }
        catch (Exception e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            throw e;
        }
        finally {
            this.meterRegistry.counter(GET_AGENT_PROPERTIES_COUNTER_METRIC_NAME, (Iterable)tags).increment();
        }
    }

    @Override
    public String reserveJobId(@Valid JobRequest jobRequest, @Valid AgentClientMetadata agentClientMetadata) {
        JobRequestMetadata jobRequestMetadata = new JobRequestMetadata(null, agentClientMetadata, 0, 0L);
        try {
            return this.persistenceService.saveJobSubmission(new JobSubmission.Builder(jobRequest, jobRequestMetadata).build());
        }
        catch (IdAlreadyExistsException e) {
            throw new GenieIdAlreadyExistsException((Throwable)((Object)e));
        }
    }

    @Override
    public JobSpecification resolveJobSpecification(@NotBlank String id) throws GenieJobResolutionException {
        try {
            JobRequest jobRequest = this.persistenceService.getJobRequest(id);
            ResolvedJob resolvedJob = this.jobResolverService.resolveJob(id, jobRequest, false);
            this.persistenceService.saveResolvedJob(id, resolvedJob);
            return resolvedJob.getJobSpecification();
        }
        catch (NotFoundException e) {
            throw new GenieJobResolutionException((Throwable)((Object)e));
        }
    }

    @Override
    @Transactional(readOnly=true)
    public JobSpecification getJobSpecification(@NotBlank String id) {
        try {
            return this.persistenceService.getJobSpecification(id).orElseThrow(() -> new GenieJobSpecificationNotFoundException("No job specification exists for job with id " + id));
        }
        catch (NotFoundException e) {
            throw new GenieJobNotFoundException((Throwable)((Object)e));
        }
    }

    @Override
    @Transactional(readOnly=true)
    public JobSpecification dryRunJobSpecificationResolution(@Valid JobRequest jobRequest) throws GenieJobResolutionException {
        return this.jobResolverService.resolveJob(jobRequest.getRequestedId().orElse(UUID.randomUUID().toString()), jobRequest, false).getJobSpecification();
    }

    @Override
    public void claimJob(@NotBlank String id, @Valid AgentClientMetadata agentClientMetadata) {
        try {
            this.persistenceService.claimJob(id, agentClientMetadata);
        }
        catch (NotFoundException e) {
            throw new GenieJobNotFoundException((Throwable)((Object)e));
        }
    }

    @Override
    public void updateJobStatus(@NotBlank String id, JobStatus currentStatus, JobStatus newStatus, @Nullable String newStatusMessage) {
        try {
            this.persistenceService.updateJobStatus(id, currentStatus, newStatus, newStatusMessage);
        }
        catch (NotFoundException e) {
            throw new GenieJobNotFoundException((Throwable)((Object)e));
        }
    }

    @Override
    public JobStatus getJobStatus(@NotBlank String id) {
        try {
            return this.persistenceService.getJobStatus(id);
        }
        catch (NotFoundException e) {
            throw new GenieJobNotFoundException((Throwable)((Object)e));
        }
    }

    @Override
    public void updateJobArchiveStatus(@NotBlank String id, ArchiveStatus newArchiveStatus) {
        try {
            this.persistenceService.updateJobArchiveStatus(id, newArchiveStatus);
        }
        catch (NotFoundException e) {
            throw new GenieJobNotFoundException((Throwable)((Object)e));
        }
    }
}

