/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.hateoas.assemblers;

import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.internal.exceptions.checked.GenieCheckedException;
import com.netflix.genie.web.apis.rest.v3.controllers.JobRestController;
import javax.annotation.Nonnull;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;

public class JobRequestModelAssembler
implements RepresentationModelAssembler<JobRequest, EntityModel<JobRequest>> {
    private static final String JOB_LINK = "job";
    private static final String EXECUTION_LINK = "execution";
    private static final String OUTPUT_LINK = "output";
    private static final String STATUS_LINK = "status";
    private static final String METADATA_LINK = "metadata";

    @Nonnull
    public EntityModel<JobRequest> toModel(JobRequest jobRequest) {
        String id = (String)jobRequest.getId().orElseThrow(IllegalArgumentException::new);
        EntityModel jobRequestModel = new EntityModel((Object)jobRequest, new Link[0]);
        try {
            jobRequestModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobRequest(id)).withSelfRel());
            jobRequestModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJob(id)).withRel(JOB_LINK));
            jobRequestModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobExecution(id)).withRel(EXECUTION_LINK));
            jobRequestModel.add(((WebMvcLinkBuilder)((WebMvcLinkBuilder)WebMvcLinkBuilder.linkTo(JobRestController.class).slash((Object)id)).slash((Object)OUTPUT_LINK)).withRel(OUTPUT_LINK));
            jobRequestModel.add(WebMvcLinkBuilder.linkTo((Object)((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobStatus(id)).withRel(STATUS_LINK));
            jobRequestModel.add(WebMvcLinkBuilder.linkTo(((JobRestController)WebMvcLinkBuilder.methodOn(JobRestController.class, (Object[])new Object[0])).getJobMetadata(id)).withRel(METADATA_LINK));
        }
        catch (GenieException | GenieCheckedException ge) {
            throw new RuntimeException(ge);
        }
        return jobRequestModel;
    }
}

