/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.converters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import javax.annotation.Nullable;
import javax.persistence.AttributeConverter;
import javax.persistence.Converter;

@Converter
public class JsonAttributeConverter
implements AttributeConverter<JsonNode, String> {
    @Nullable
    public String convertToDatabaseColumn(@Nullable JsonNode attribute) {
        if (attribute == null) {
            return null;
        }
        try {
            return GenieObjectMapper.getMapper().writeValueAsString((Object)attribute);
        }
        catch (JsonProcessingException e) {
            throw new GenieRuntimeException("Unable to convert JsonNode to a JSON string for storing in database", (Throwable)e);
        }
    }

    @Nullable
    public JsonNode convertToEntityAttribute(@Nullable String dbData) {
        if (dbData == null) {
            return null;
        }
        try {
            return GenieObjectMapper.getMapper().readTree(dbData);
        }
        catch (JsonProcessingException e) {
            throw new GenieRuntimeException("Unable to convert: (" + dbData + ") to JsonNode", (Throwable)e);
        }
    }
}

