/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.repositories;

import com.netflix.genie.web.data.services.impl.jpa.entities.JobEntity;
import com.netflix.genie.web.data.services.impl.jpa.queries.aggregates.JobInfoAggregate;
import com.netflix.genie.web.data.services.impl.jpa.queries.aggregates.UserJobResourcesAggregate;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobApplicationsProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobClusterProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobCommandProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobRequestProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.JobSpecificationProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.V4JobRequestProjection;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaBaseRepository;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface JpaJobRepository
extends JpaBaseRepository<JobEntity> {
    public static final String FIND_OLD_JOBS_QUERY = "SELECT id FROM jobs WHERE created < :createdThreshold AND status NOT IN (:excludedStatuses) LIMIT :batchSize";

    @EntityGraph(value="Job.v3.dto.job", type=EntityGraph.EntityGraphType.LOAD)
    public Set<JobProjection> findByAgentHostnameAndStatusIn(String var1, Set<String> var2);

    @Query(value="SELECT COALESCE(SUM(j.memoryUsed), 0) FROM JobEntity j WHERE j.agentHostname = :agentHostname AND j.status IN (:statuses)")
    public long getTotalMemoryUsedOnHost(@Param(value="agentHostname") String var1, @Param(value="statuses") Set<String> var2);

    @Query(value="SELECT (SELECT COALESCE(SUM(j.memory_used), 0) FROM jobs j WHERE j.agent_hostname = :agentHostname and j.status IN (:activeStatuses)) as totalMemoryAllocated, (SELECT COALESCE(SUM(j.memory_used), 0) FROM jobs j WHERE j.agent_hostname = :agentHostname and j.status IN (:usedStatuses)) as totalMemoryUsed, (SELECT COUNT(*) FROM jobs j WHERE j.agent_hostname = :agentHostname and j.status IN (:activeStatuses)) as numberOfActiveJobs", nativeQuery=true)
    public JobInfoAggregate getHostJobInfo(@Param(value="agentHostname") String var1, @Param(value="activeStatuses") Set<String> var2, @Param(value="usedStatuses") Set<String> var3);

    public Long countJobsByUserAndStatusIn(@NotBlank String var1, @NotEmpty Set<String> var2);

    @Query(value="SELECT id FROM jobs WHERE created < :createdThreshold AND status NOT IN (:excludedStatuses) LIMIT :batchSize", nativeQuery=true)
    public Set<Long> findJobsCreatedBefore(@Param(value="createdThreshold") Instant var1, @Param(value="excludedStatuses") Set<String> var2, @Param(value="batchSize") int var3);

    @Query(value="SELECT j.user AS user, COUNT(j) as runningJobsCount, COALESCE(SUM(j.memoryUsed), 0) as usedMemory FROM JobEntity j WHERE j.status IN (:statuses) AND j.api = :isApi GROUP BY j.user")
    public Set<UserJobResourcesAggregate> getUserJobResourcesAggregates(@Param(value="statuses") Set<String> var1, @Param(value="isApi") boolean var2);

    @Query(value="SELECT j.uniqueId FROM JobEntity j WHERE j.status IN (:statuses) AND j.v4 = TRUE")
    public Set<String> getAgentJobIdsWithStatusIn(@Param(value="statuses") @NotEmpty Set<String> var1);

    @Query(value="SELECT j.uniqueId FROM JobEntity j WHERE j.status IN (:statuses) AND j.archiveStatus IN (:archiveStatuses) AND j.updated < :updatedThreshold AND j.v4 = TRUE")
    public Set<String> getJobsWithStatusAndArchiveStatusUpdatedBefore(@Param(value="statuses") @NotEmpty Set<String> var1, @Param(value="archiveStatuses") @NotEmpty Set<String> var2, @Param(value="updatedThreshold") Instant var3);

    @Query(value="SELECT j.status FROM JobEntity j WHERE j.uniqueId = :id")
    public Optional<String> getJobStatus(@Param(value="id") String var1);

    @Query(value="SELECT j.api FROM JobEntity j WHERE j.uniqueId = :id")
    public Optional<Boolean> isAPI(@Param(value="id") String var1);

    @Query(value="SELECT j.agentHostname FROM JobEntity j WHERE j.uniqueId = :id")
    public Optional<String> getJobHostname(@Param(value="id") String var1);

    @Query(value="SELECT COALESCE(j.archiveStatus, 'UNKNOWN') FROM JobEntity j WHERE j.uniqueId = :id")
    public Optional<String> getArchiveStatus(@Param(value="id") String var1);

    @Query(value="SELECT j FROM JobEntity j WHERE j.uniqueId = :id")
    @EntityGraph(value="Job.v3.dto.job", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<JobProjection> getV3Job(@Param(value="id") String var1);

    @Query(value="SELECT j FROM JobEntity j WHERE j.uniqueId = :id")
    @EntityGraph(value="Job.v3.dto.request", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<JobRequestProjection> getV3JobRequest(@Param(value="id") String var1);

    @Query(value="SELECT j FROM JobEntity j WHERE j.uniqueId = :id")
    @EntityGraph(value="Job.v4.dto.request", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<V4JobRequestProjection> getV4JobRequest(@Param(value="id") String var1);

    @Query(value="SELECT j FROM JobEntity j WHERE j.uniqueId = :id")
    @EntityGraph(value="Job.v4.dto.specification", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<JobSpecificationProjection> getV4JobSpecification(@Param(value="id") String var1);

    @Query(value="SELECT j FROM JobEntity j WHERE j.uniqueId = :id")
    @EntityGraph(value="Job.applications", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<JobApplicationsProjection> getJobApplications(@Param(value="id") String var1);

    @Query(value="SELECT j FROM JobEntity j WHERE j.uniqueId = :id")
    @EntityGraph(value="Job.cluster", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<JobClusterProjection> getJobCluster(@Param(value="id") String var1);

    @Query(value="SELECT j FROM JobEntity j WHERE j.uniqueId = :id")
    @EntityGraph(value="Job.command", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<JobCommandProjection> getJobCommand(@Param(value="id") String var1);
}

