/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.dtos;

import java.util.Optional;
import javax.annotation.Nullable;

public class ResourceSelectionResult<R> {
    private final Class<?> selectorClass;
    private final R selectedResource;
    private final String selectionRationale;

    private ResourceSelectionResult(Builder<R> builder) {
        this.selectorClass = ((Builder)builder).bSelectorClass;
        this.selectedResource = ((Builder)builder).bSelectedResource;
        this.selectionRationale = ((Builder)builder).bSelectionRationale;
    }

    public Optional<R> getSelectedResource() {
        return Optional.ofNullable(this.selectedResource);
    }

    public Optional<String> getSelectionRationale() {
        return Optional.ofNullable(this.selectionRationale);
    }

    public Class<?> getSelectorClass() {
        return this.selectorClass;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceSelectionResult)) {
            return false;
        }
        ResourceSelectionResult other = (ResourceSelectionResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Class<?> this$selectorClass = this.selectorClass;
        Class<?> other$selectorClass = other.selectorClass;
        if (this$selectorClass == null ? other$selectorClass != null : !this$selectorClass.equals(other$selectorClass)) {
            return false;
        }
        R this$selectedResource = this.selectedResource;
        R other$selectedResource = other.selectedResource;
        if (this$selectedResource == null ? other$selectedResource != null : !this$selectedResource.equals(other$selectedResource)) {
            return false;
        }
        String this$selectionRationale = this.selectionRationale;
        String other$selectionRationale = other.selectionRationale;
        return !(this$selectionRationale == null ? other$selectionRationale != null : !this$selectionRationale.equals(other$selectionRationale));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ResourceSelectionResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Class<?> $selectorClass = this.selectorClass;
        result = result * 59 + ($selectorClass == null ? 43 : $selectorClass.hashCode());
        R $selectedResource = this.selectedResource;
        result = result * 59 + ($selectedResource == null ? 43 : $selectedResource.hashCode());
        String $selectionRationale = this.selectionRationale;
        result = result * 59 + ($selectionRationale == null ? 43 : $selectionRationale.hashCode());
        return result;
    }

    public String toString() {
        return "ResourceSelectionResult(selectorClass=" + this.selectorClass + ", selectedResource=" + this.selectedResource + ", selectionRationale=" + this.selectionRationale + ")";
    }

    public static class Builder<R> {
        private final Class<?> bSelectorClass;
        private R bSelectedResource;
        private String bSelectionRationale;

        public Builder(Class<?> selectorClass) {
            this.bSelectorClass = selectorClass;
        }

        public Builder<R> withSelectedResource(@Nullable R selectedResource) {
            this.bSelectedResource = selectedResource;
            return this;
        }

        public Builder<R> withSelectionRationale(@Nullable String selectionRationale) {
            this.bSelectionRationale = selectionRationale;
            return this;
        }

        public ResourceSelectionResult<R> build() {
            return new ResourceSelectionResult(this);
        }
    }
}

