/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import com.amazonaws.regions.Regions;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.aws.credentials")
@Validated
public class AwsCredentialsProperties {
    public static final String PROPERTY_PREFIX = "genie.aws.credentials";
    @Nullable
    private String role;

    @Nullable
    public String getRole() {
        return this.role;
    }

    public void setRole(@Nullable String role) {
        this.role = role;
    }

    @ConfigurationProperties(prefix="cloud.aws.region")
    @Validated
    public static class SpringCloudAwsRegionProperties {
        static final String PROPERTY_PREFIX = "cloud.aws.region";
        private boolean auto;
        private Regions region = Regions.US_EAST_1;

        public String getStatic() {
            return this.region.getName();
        }

        public void setStatic(String newStatic) {
            this.region = Regions.fromName((String)newStatic);
        }

        public boolean isAuto() {
            return this.auto;
        }

        public void setAuto(boolean auto) {
            this.auto = auto;
        }

        public Regions getRegion() {
            return this.region;
        }
    }
}

