/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.repositories;

import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaBaseRepository;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.EntityGraph;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface JpaCommandRepository
extends JpaBaseRepository<CommandEntity> {
    public static final String SET_UNUSED_STATUS_QUERY = "UPDATE commands SET status = :desiredStatus WHERE status IN (:currentStatuses) AND created < :commandCreatedThreshold AND id NOT IN (SELECT DISTINCT(command_id) FROM jobs WHERE command_id IS NOT NULL AND created >= :jobCreatedThreshold)";
    public static final String FIND_UNUSED_COMMANDS_QUERY = "SELECT id FROM commands WHERE status IN (:unusedStatuses) AND created < :commandCreatedThreshold AND id NOT IN (SELECT DISTINCT(command_id) FROM jobs WHERE command_id IS NOT NULL)";

    @Query(value="UPDATE commands SET status = :desiredStatus WHERE status IN (:currentStatuses) AND created < :commandCreatedThreshold AND id NOT IN (SELECT DISTINCT(command_id) FROM jobs WHERE command_id IS NOT NULL AND created >= :jobCreatedThreshold)", nativeQuery=true)
    @Modifying
    public int setUnusedStatus(@Param(value="desiredStatus") String var1, @Param(value="commandCreatedThreshold") Instant var2, @Param(value="currentStatuses") Set<String> var3, @Param(value="jobCreatedThreshold") Instant var4);

    @Query(value="SELECT id FROM commands WHERE status IN (:unusedStatuses) AND created < :commandCreatedThreshold AND id NOT IN (SELECT DISTINCT(command_id) FROM jobs WHERE command_id IS NOT NULL)", nativeQuery=true)
    public Set<Long> findUnusedCommands(@Param(value="unusedStatuses") Set<String> var1, @Param(value="commandCreatedThreshold") Instant var2);

    @Query(value="SELECT c FROM CommandEntity c WHERE c.uniqueId = :id")
    @EntityGraph(value="Command.applications", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<CommandEntity> getCommandAndApplications(@Param(value="id") String var1);

    @Query(value="SELECT c FROM CommandEntity c WHERE c.uniqueId = :id")
    @EntityGraph(value="Command.applications.dto", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<CommandEntity> getCommandAndApplicationsDto(@Param(value="id") String var1);

    @Query(value="SELECT c FROM CommandEntity c WHERE c.uniqueId = :id")
    @EntityGraph(value="Command.clusterCriteria", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<CommandEntity> getCommandAndClusterCriteria(@Param(value="id") String var1);

    @Query(value="SELECT c FROM CommandEntity c WHERE c.uniqueId = :id")
    @EntityGraph(value="Command.DTO", type=EntityGraph.EntityGraphType.LOAD)
    public Optional<CommandEntity> getCommandDto(@Param(value="id") String var1);
}

