/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.repositories;

import com.netflix.genie.web.data.services.impl.jpa.entities.FileEntity;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaIdRepository;
import java.time.Instant;
import java.util.Optional;
import java.util.Set;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.query.Param;

public interface JpaFileRepository
extends JpaIdRepository<FileEntity> {
    public static final String SELECT_FOR_UPDATE_UNUSED_FILES_SQL = "SELECT id FROM files WHERE id NOT IN (SELECT DISTINCT(setup_file) FROM applications WHERE setup_file IS NOT NULL) AND id NOT IN (SELECT DISTINCT(file_id) FROM applications_configs) AND id NOT IN (SELECT DISTINCT(file_id) FROM applications_dependencies) AND id NOT IN (SELECT DISTINCT(setup_file) FROM clusters WHERE setup_file IS NOT NULL) AND id NOT IN (SELECT DISTINCT(file_id) FROM clusters_configs) AND id NOT IN (SELECT DISTINCT(file_id) FROM clusters_dependencies) AND id NOT IN (SELECT DISTINCT(setup_file) FROM commands WHERE setup_file IS NOT NULL) AND id NOT IN (SELECT DISTINCT(file_id) FROM commands_configs) AND id NOT IN (SELECT DISTINCT(file_id) FROM commands_dependencies) AND id NOT IN (SELECT DISTINCT(setup_file) FROM jobs WHERE setup_file IS NOT NULL) AND id NOT IN (SELECT DISTINCT(file_id) FROM jobs_configs) AND id NOT IN (SELECT DISTINCT(file_id) FROM jobs_dependencies) AND created <= :createdThreshold FOR UPDATE;";

    public Optional<FileEntity> findByFile(String var1);

    public boolean existsByFile(String var1);

    public Set<FileEntity> findByFileIn(Set<String> var1);

    @Query(value="SELECT id FROM files WHERE id NOT IN (SELECT DISTINCT(setup_file) FROM applications WHERE setup_file IS NOT NULL) AND id NOT IN (SELECT DISTINCT(file_id) FROM applications_configs) AND id NOT IN (SELECT DISTINCT(file_id) FROM applications_dependencies) AND id NOT IN (SELECT DISTINCT(setup_file) FROM clusters WHERE setup_file IS NOT NULL) AND id NOT IN (SELECT DISTINCT(file_id) FROM clusters_configs) AND id NOT IN (SELECT DISTINCT(file_id) FROM clusters_dependencies) AND id NOT IN (SELECT DISTINCT(setup_file) FROM commands WHERE setup_file IS NOT NULL) AND id NOT IN (SELECT DISTINCT(file_id) FROM commands_configs) AND id NOT IN (SELECT DISTINCT(file_id) FROM commands_dependencies) AND id NOT IN (SELECT DISTINCT(setup_file) FROM jobs WHERE setup_file IS NOT NULL) AND id NOT IN (SELECT DISTINCT(file_id) FROM jobs_configs) AND id NOT IN (SELECT DISTINCT(file_id) FROM jobs_dependencies) AND created <= :createdThreshold FOR UPDATE;", nativeQuery=true)
    public Set<Number> findUnusedFiles(@Param(value="createdThreshold") Instant var1);

    @Modifying
    public Long deleteByIdIn(Set<Long> var1);
}

