/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.apis.rpc.v4.interceptors;

import io.grpc.ForwardingServerCall;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.grpc.Status;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLoggingInterceptor
implements ServerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(SimpleLoggingInterceptor.class);
    private static final String NO_CAUSE = "Error cause is unknown";

    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(final ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        return next.startCall((ServerCall)new ForwardingServerCall.SimpleForwardingServerCall<ReqT, RespT>(call){

            public void request(int numMessages) {
                log.debug("gRPC call: {}", (Object)call.getMethodDescriptor().getFullMethodName());
                super.request(numMessages);
            }

            public void close(Status status, Metadata trailers) {
                if (!status.isOk()) {
                    log.warn("gRPC error: {} -> {}: {}", new Object[]{call.getMethodDescriptor().getFullMethodName(), status.getCode().value(), status.getCause() != null ? status.getCause().getMessage() : SimpleLoggingInterceptor.NO_CAUSE, status.getCause()});
                }
                super.close(status, trailers);
            }
        }, headers);
    }
}

