/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.services.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import java.util.Optional;
import java.util.Set;
import javax.validation.constraints.NotBlank;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.annotation.Validated;

@Validated
public class AgentRoutingServiceSingleNodeImpl
implements AgentRoutingService {
    private static final Logger log = LoggerFactory.getLogger(AgentRoutingServiceSingleNodeImpl.class);
    private final GenieHostInfo genieHostInfo;
    private final Set<String> connectedAgents = Sets.newConcurrentHashSet();

    public AgentRoutingServiceSingleNodeImpl(GenieHostInfo genieHostInfo) {
        this.genieHostInfo = genieHostInfo;
    }

    @Override
    public Optional<String> getHostnameForAgentConnection(@NotBlank String jobId) {
        return this.isAgentConnected(jobId) ? Optional.of(this.genieHostInfo.getHostname()) : Optional.empty();
    }

    @Override
    public boolean isAgentConnectionLocal(@NotBlank String jobId) {
        return this.isAgentConnected(jobId);
    }

    @Override
    public void handleClientConnected(@NotBlank String jobId) {
        log.info("Agent executing job {} connected", (Object)jobId);
        this.connectedAgents.add(jobId);
    }

    @Override
    public void handleClientDisconnected(@NotBlank String jobId) {
        log.info("Agent executing job {} disconnected", (Object)jobId);
        this.connectedAgents.remove(jobId);
    }

    @Override
    public boolean isAgentConnected(String jobId) {
        return this.connectedAgents.contains(jobId);
    }
}

