/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.apis;

import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.web.properties.HttpProperties;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.properties.RetryProperties;
import com.netflix.genie.web.resources.writers.DefaultDirectoryWriter;
import com.netflix.genie.web.resources.writers.DirectoryWriter;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.client.RestTemplateBuilder;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.backoff.ExponentialBackOffPolicy;
import org.springframework.retry.policy.SimpleRetryPolicy;
import org.springframework.retry.support.RetryTemplate;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.filter.CharacterEncodingFilter;

@Configuration
@EnableConfigurationProperties(value={HttpProperties.class, RetryProperties.class})
public class ApisAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={ResourceLoader.class})
    public ResourceLoader resourceLoader() {
        return new DefaultResourceLoader();
    }

    @Bean
    @ConditionalOnMissingBean(name={"genieRestTemplate"})
    public RestTemplate genieRestTemplate(HttpProperties httpProperties, RestTemplateBuilder restTemplateBuilder) {
        return restTemplateBuilder.setConnectTimeout(Duration.of(httpProperties.getConnect().getTimeout(), ChronoUnit.MILLIS)).setReadTimeout(Duration.of(httpProperties.getRead().getTimeout(), ChronoUnit.MILLIS)).build();
    }

    @Bean
    @ConditionalOnMissingBean(name={"genieRetryTemplate"})
    public RetryTemplate genieRetryTemplate(RetryProperties retryProperties) {
        RetryTemplate retryTemplate = new RetryTemplate();
        retryTemplate.setRetryPolicy((RetryPolicy)new SimpleRetryPolicy(retryProperties.getNoOfRetries(), Collections.singletonMap(Exception.class, true)));
        ExponentialBackOffPolicy backOffPolicy = new ExponentialBackOffPolicy();
        backOffPolicy.setInitialInterval(retryProperties.getInitialInterval());
        backOffPolicy.setMaxInterval(retryProperties.getMaxInterval());
        retryTemplate.setBackOffPolicy((BackOffPolicy)backOffPolicy);
        return retryTemplate;
    }

    @Bean
    @ConditionalOnMissingBean(value={DirectoryWriter.class})
    public DefaultDirectoryWriter directoryWriter() {
        return new DefaultDirectoryWriter();
    }

    @Bean
    @ConditionalOnMissingBean(name={"jobsDir"}, value={Resource.class})
    public Resource jobsDir(ResourceLoader resourceLoader, JobsProperties jobsProperties) throws IOException {
        File file;
        Resource jobsDirResource;
        String jobsDirLocation = jobsProperties.getLocations().getJobs().toString();
        Resource tmpJobsDirResource = resourceLoader.getResource(jobsDirLocation);
        if (tmpJobsDirResource.exists() && !tmpJobsDirResource.getFile().isDirectory()) {
            throw new IllegalStateException(jobsDirLocation + " exists but isn't a directory. Unable to continue");
        }
        String slash = "/";
        String localJobsDir = jobsDirLocation;
        if (!jobsDirLocation.endsWith("/")) {
            localJobsDir = localJobsDir + "/";
        }
        if (!(jobsDirResource = resourceLoader.getResource(localJobsDir)).exists() && !(file = jobsDirResource.getFile()).mkdirs()) {
            throw new IllegalStateException("Unable to create jobs directory " + jobsDirLocation + " and it doesn't exist.");
        }
        return jobsDirResource;
    }

    @Bean
    public CharacterEncodingFilter characterEncodingFilter() {
        CharacterEncodingFilter characterEncodingFilter = new CharacterEncodingFilter();
        characterEncodingFilter.setEncoding(StandardCharsets.UTF_8.name());
        characterEncodingFilter.setForceEncoding(true);
        return characterEncodingFilter;
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer apisObjectMapperCustomizer() {
        return builder -> builder.filters(GenieObjectMapper.FILTER_PROVIDER);
    }
}

