/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.launchers.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Sets;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.dtos.TitusBatchJobRequest;
import com.netflix.genie.web.dtos.TitusBatchJobResponse;
import com.netflix.genie.web.exceptions.checked.AgentLaunchException;
import com.netflix.genie.web.properties.TitusAgentLauncherProperties;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.web.client.RestTemplate;

public class TitusAgentLauncherImpl
implements AgentLauncher {
    private static final Logger log = LoggerFactory.getLogger(TitusAgentLauncherImpl.class);
    private static final String LAUNCH_TIMER = "genie.launchers.titus.launch.timer";
    private static final String GENIE_USER_ATTR = "genie_user";
    private static final String GENIE_SOURCE_HOST_ATTR = "genie_source_host";
    private static final String GENIE_ENDPOINT_ATTR = "genie_endpoint";
    private static final String GENIE_JOB_ID_ATTR = "genie_job_id";
    private static final String TITUS_API_JOB_PATH = "/api/v3/jobs";
    private static final String LAUNCHER_CLASS_EXT_FIELD = "launcher_class";
    private static final String TITUS_JOB_ID_EXT_FIELD = "titus_job_id";
    private static final String TITUS_JOB_REQUEST_EXT_FIELD = "titus_job_request";
    private static final String TITUS_JOB_RESPONSE_EXT_FIELD = "titus_job_response";
    private static final String THIS_CLASS = TitusAgentLauncherImpl.class.getCanonicalName();
    private static final int TITUS_JOB_BATCH_SIZE = 1;
    private final RestTemplate restTemplate;
    private final Cache<String, String> healthIndicatorCache;
    private final GenieHostInfo genieHostInfo;
    private final TitusAgentLauncherProperties titusAgentLauncherProperties;
    private final MeterRegistry registry;

    public TitusAgentLauncherImpl(RestTemplate restTemplate, Cache<String, String> healthIndicatorCache, GenieHostInfo genieHostInfo, TitusAgentLauncherProperties titusAgentLauncherProperties, MeterRegistry registry) {
        this.restTemplate = restTemplate;
        this.healthIndicatorCache = healthIndicatorCache;
        this.genieHostInfo = genieHostInfo;
        this.titusAgentLauncherProperties = titusAgentLauncherProperties;
        this.registry = registry;
    }

    @Override
    public Optional<JsonNode> launchAgent(ResolvedJob resolvedJob, @Nullable JsonNode requestedLauncherExt) throws AgentLaunchException {
        Optional<ObjectNode> optional;
        String jobId = resolvedJob.getJobSpecification().getJob().getId();
        TitusBatchJobRequest titusJobRequest = this.createJobRequest(resolvedJob);
        HashSet tags = Sets.newHashSet();
        String titusJobId = null;
        long start = System.nanoTime();
        try {
            TitusBatchJobResponse titusResponse = (TitusBatchJobResponse)this.restTemplate.postForObject(this.titusAgentLauncherProperties.getEndpoint().toString() + TITUS_API_JOB_PATH, (Object)titusJobRequest, TitusBatchJobResponse.class, new Object[0]);
            if (titusResponse == null) {
                throw new AgentLaunchException("Failed to request creation of Titus job for job " + jobId);
            }
            titusJobId = titusResponse.getId();
            if (StringUtils.isBlank((CharSequence)titusJobId)) {
                throw new AgentLaunchException("Failed to create titus job for job " + jobId + " - " + titusResponse.getStatusCode() + ": " + titusResponse.getMessage());
            }
            log.info("Created Titus job {} to execute job {}", (Object)titusJobId, (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
            ObjectNode launcherExt = JsonNodeFactory.instance.objectNode().put(LAUNCHER_CLASS_EXT_FIELD, THIS_CLASS).put(TITUS_JOB_ID_EXT_FIELD, titusJobId).putPOJO(TITUS_JOB_REQUEST_EXT_FIELD, (Object)titusJobRequest).putPOJO(TITUS_JOB_RESPONSE_EXT_FIELD, (Object)titusResponse);
            optional = Optional.of(launcherExt);
        }
        catch (Exception e) {
            try {
                log.error("Failed to launch job on Titus", (Throwable)e);
                MetricsUtils.addFailureTagsWithException(tags, e);
                throw new AgentLaunchException("Failed to create titus job for job " + jobId, e);
            }
            catch (Throwable throwable) {
                long end = System.nanoTime();
                this.registry.timer(LAUNCH_TIMER, (Iterable)tags).record(end - start, TimeUnit.NANOSECONDS);
                this.healthIndicatorCache.put((Object)jobId, (Object)(StringUtils.isBlank(titusJobId) ? "-" : titusJobId));
                throw throwable;
            }
        }
        long end = System.nanoTime();
        this.registry.timer(LAUNCH_TIMER, (Iterable)tags).record(end - start, TimeUnit.NANOSECONDS);
        this.healthIndicatorCache.put((Object)jobId, (Object)(StringUtils.isBlank((CharSequence)titusJobId) ? "-" : titusJobId));
        return optional;
    }

    public Health health() {
        return Health.up().withDetails((Map)this.healthIndicatorCache.asMap()).build();
    }

    private TitusBatchJobRequest createJobRequest(ResolvedJob resolvedJob) {
        String jobId = resolvedJob.getJobSpecification().getJob().getId();
        ImmutableMap placeholdersMap = ImmutableMap.of((Object)"<JOB_ID>", (Object)jobId, (Object)"<SERVER_HOST>", (Object)this.titusAgentLauncherProperties.getGenieServerHost(), (Object)"<SERVER_PORT>", (Object)String.valueOf(this.titusAgentLauncherProperties.getGenieServerPort()));
        List<String> entryPoint = this.titusAgentLauncherProperties.getEntryPointTemplate().stream().map(arg_0 -> TitusAgentLauncherImpl.lambda$createJobRequest$0((Map)placeholdersMap, arg_0)).collect(Collectors.toList());
        return new TitusBatchJobRequest(new TitusBatchJobRequest.Owner(this.titusAgentLauncherProperties.getOwnerEmail()), this.titusAgentLauncherProperties.getApplicationName(), this.titusAgentLauncherProperties.getCapacityGroup(), (Map<String, String>)ImmutableMap.of((Object)GENIE_USER_ATTR, (Object)resolvedJob.getJobMetadata().getUser(), (Object)GENIE_SOURCE_HOST_ATTR, (Object)this.genieHostInfo.getHostname(), (Object)GENIE_ENDPOINT_ATTR, (Object)this.titusAgentLauncherProperties.getGenieServerHost(), (Object)GENIE_JOB_ID_ATTR, (Object)jobId), new TitusBatchJobRequest.Container(new TitusBatchJobRequest.Resources(resolvedJob.getJobEnvironment().getCpu(), 0, resolvedJob.getJobEnvironment().getMemory(), this.titusAgentLauncherProperties.getDiskSize().toMegabytes(), this.titusAgentLauncherProperties.getNetworkBandwidth().toMegabytes() * 8L), new TitusBatchJobRequest.SecurityProfile(this.titusAgentLauncherProperties.getSecurityAttributes(), this.titusAgentLauncherProperties.getSecurityGroups(), this.titusAgentLauncherProperties.getIAmRole()), new TitusBatchJobRequest.Image(this.titusAgentLauncherProperties.getImageName(), this.titusAgentLauncherProperties.getImageTag()), entryPoint, this.titusAgentLauncherProperties.getAdditionalEnvironment()), new TitusBatchJobRequest.Batch(1, new TitusBatchJobRequest.RetryPolicy(new TitusBatchJobRequest.Immediate(this.titusAgentLauncherProperties.getRetries())), this.titusAgentLauncherProperties.getRuntimeLimit().getSeconds()), new TitusBatchJobRequest.DisruptionBudget(new TitusBatchJobRequest.SelfManaged(this.titusAgentLauncherProperties.getRuntimeLimit().toMillis())));
    }

    private static /* synthetic */ String lambda$createJobRequest$0(Map placeholdersMap, String s) {
        return placeholdersMap.getOrDefault(s, s);
    }
}

