/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.entities;

import com.fasterxml.jackson.databind.JsonNode;
import com.google.common.collect.Maps;
import com.netflix.genie.web.data.services.impl.jpa.converters.JsonAttributeConverter;
import com.netflix.genie.web.data.services.impl.jpa.entities.ApplicationEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.BaseEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.ClusterEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CriterionEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.FileEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.listeners.JobEntityListener;
import com.netflix.genie.web.data.services.impl.jpa.queries.predicates.PredicateUtils;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobApiProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobApplicationsProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobArchiveLocationProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobClusterProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobCommandProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobExecutionProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobMetadataProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobRequestProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobSearchProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.StatusProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.FinishedJobProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.JobSpecificationProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.V4JobRequestProjection;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKeyColumn;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.NamedSubgraph;
import javax.persistence.OrderColumn;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.validation.constraints.Email;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@EntityListeners(value={JobEntityListener.class})
@Table(name="jobs")
@NamedEntityGraphs(value={@NamedEntityGraph(name="Job.v3.dto.job", attributeNodes={@NamedAttributeNode(value="metadata"), @NamedAttributeNode(value="commandArgs"), @NamedAttributeNode(value="tags")}), @NamedEntityGraph(name="Job.v3.dto.request", attributeNodes={@NamedAttributeNode(value="metadata"), @NamedAttributeNode(value="commandArgs"), @NamedAttributeNode(value="tags"), @NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="clusterCriteria", subgraph="criterion-sub-graph"), @NamedAttributeNode(value="commandCriterion", subgraph="criterion-sub-graph"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="requestedApplications")}, subgraphs={@NamedSubgraph(name="criterion-sub-graph", attributeNodes={@NamedAttributeNode(value="tags")})}), @NamedEntityGraph(name="Job.v4.dto.request", attributeNodes={@NamedAttributeNode(value="metadata"), @NamedAttributeNode(value="commandArgs"), @NamedAttributeNode(value="tags"), @NamedAttributeNode(value="requestedEnvironmentVariables"), @NamedAttributeNode(value="requestedAgentEnvironmentExt"), @NamedAttributeNode(value="requestedAgentConfigExt"), @NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="clusterCriteria", subgraph="criterion-sub-graph"), @NamedAttributeNode(value="commandCriterion", subgraph="criterion-sub-graph"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="requestedApplications"), @NamedAttributeNode(value="requestedLauncherExt")}, subgraphs={@NamedSubgraph(name="criterion-sub-graph", attributeNodes={@NamedAttributeNode(value="tags")})}), @NamedEntityGraph(name="Job.v4.dto.specification", attributeNodes={@NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="commandArgs"), @NamedAttributeNode(value="cluster", subgraph="resource-sub-graph"), @NamedAttributeNode(value="command", subgraph="command-sub-graph"), @NamedAttributeNode(value="applications", subgraph="resource-sub-graph"), @NamedAttributeNode(value="environmentVariables")}, subgraphs={@NamedSubgraph(name="resource-sub-graph", attributeNodes={@NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies")}), @NamedSubgraph(name="command-sub-graph", attributeNodes={@NamedAttributeNode(value="executable"), @NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies")})}), @NamedEntityGraph(name="Job.applications", attributeNodes={@NamedAttributeNode(value="applications", subgraph="application-sub-graph")}, subgraphs={@NamedSubgraph(name="application-sub-graph", attributeNodes={@NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="tags")})}), @NamedEntityGraph(name="Job.cluster", attributeNodes={@NamedAttributeNode(value="cluster", subgraph="cluster-sub-graph")}, subgraphs={@NamedSubgraph(name="cluster-sub-graph", attributeNodes={@NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="tags")})}), @NamedEntityGraph(name="Job.command", attributeNodes={@NamedAttributeNode(value="command", subgraph="command-sub-graph")}, subgraphs={@NamedSubgraph(name="command-sub-graph", attributeNodes={@NamedAttributeNode(value="executable"), @NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="tags"), @NamedAttributeNode(value="clusterCriteria", subgraph="criteria-sub-graph")}), @NamedSubgraph(name="criteria-sub-graph", attributeNodes={@NamedAttributeNode(value="tags")})})})
public class JobEntity
extends BaseEntity
implements FinishedJobProjection,
JobProjection,
JobRequestProjection,
JobMetadataProjection,
JobExecutionProjection,
JobApplicationsProjection,
JobClusterProjection,
JobCommandProjection,
JobSearchProjection,
V4JobRequestProjection,
JobSpecificationProjection,
JobArchiveLocationProjection,
JobApiProjection,
StatusProjection {
    public static final String V3_JOB_DTO_ENTITY_GRAPH = "Job.v3.dto.job";
    public static final String V3_JOB_REQUEST_DTO_ENTITY_GRAPH = "Job.v3.dto.request";
    public static final String V4_JOB_REQUEST_DTO_ENTITY_GRAPH = "Job.v4.dto.request";
    public static final String V4_JOB_SPECIFICATION_DTO_ENTITY_GRAPH = "Job.v4.dto.specification";
    public static final String JOB_APPLICATIONS_DTO_ENTITY_GRAPH = "Job.applications";
    public static final String JOB_CLUSTER_DTO_ENTITY_GRAPH = "Job.cluster";
    public static final String JOB_COMMAND_DTO_ENTITY_GRAPH = "Job.command";
    private static final long serialVersionUID = 2849367731657512224L;
    @Basic
    @Column(name="tags", length=1024, updatable=false)
    @Size(max=1024, message="Max length in database is 1024 characters")
    private @Size(max=1024, message="Max length in database is 1024 characters") String tagSearchString;
    @Basic
    @Column(name="genie_user_group", updatable=false)
    @Size(max=255, message="Max length in database is 255 characters")
    private @Size(max=255, message="Max length in database is 255 characters") String genieUserGroup;
    @Basic(optional=false)
    @Column(name="archiving_disabled", nullable=false, updatable=false)
    private boolean archivingDisabled;
    @Basic
    @Column(name="email", updatable=false)
    @Email
    @Size(max=255, message="Max length in database is 255 characters")
    private @Email @Size(max=255, message="Max length in database is 255 characters") String email;
    @Basic
    @Column(name="requested_cpu", updatable=false)
    @Min(value=1L, message="Can't have less than 1 CPU")
    private @Min(value=1L, message="Can't have less than 1 CPU") Integer requestedCpu;
    @Basic
    @Column(name="requested_memory", updatable=false)
    @Min(value=1L, message="Can't have less than 1 MB of memory allocated")
    private @Min(value=1L, message="Can't have less than 1 MB of memory allocated") Integer requestedMemory;
    @Basic
    @Column(name="requested_timeout", updatable=false)
    @Min(value=1L)
    private @Min(value=1L) Integer requestedTimeout;
    @Basic
    @Column(name="grouping", updatable=false)
    @Size(max=255, message="Max length in database is 255 characters")
    private @Size(max=255, message="Max length in database is 255 characters") String grouping;
    @Basic
    @Column(name="grouping_instance", updatable=false)
    @Size(max=255, message="Max length in database is 255 characters")
    private @Size(max=255, message="Max length in database is 255 characters") String groupingInstance;
    @Basic
    @Column(name="request_api_client_hostname", updatable=false)
    @Size(max=255, message="Max length in database is 255 characters")
    private @Size(max=255, message="Max length in database is 255 characters") String requestApiClientHostname;
    @Basic
    @Column(name="request_api_client_user_agent", length=1024, updatable=false)
    @Size(max=1024, message="Max length in database is 1024 characters")
    private @Size(max=1024, message="Max length in database is 1024 characters") String requestApiClientUserAgent;
    @Basic
    @Column(name="request_agent_client_hostname", updatable=false)
    @Size(max=255, message="Max length in database is 255 characters")
    private @Size(max=255, message="Max length in database is 255 characters") String requestAgentClientHostname;
    @Basic
    @Column(name="request_agent_client_version", updatable=false)
    @Size(max=255, message="Max length in database is 255 characters")
    private @Size(max=255, message="Max length in database is 255 characters") String requestAgentClientVersion;
    @Basic
    @Column(name="request_agent_client_pid", updatable=false)
    @Min(value=0L, message="Agent Client Pid can't be less than zero")
    private @Min(value=0L, message="Agent Client Pid can't be less than zero") Integer requestAgentClientPid;
    @Basic
    @Column(name="num_attachments", updatable=false)
    @Min(value=0L, message="Can't have less than zero attachments")
    private @Min(value=0L, message="Can't have less than zero attachments") Integer numAttachments;
    @Basic
    @Column(name="total_size_of_attachments", updatable=false)
    @Min(value=0L, message="Can't have less than zero bytes total attachment size")
    private @Min(value=0L, message="Can't have less than zero bytes total attachment size") Long totalSizeOfAttachments;
    @Basic
    @Column(name="std_out_size")
    @Min(value=0L, message="Can't have less than zero bytes for std out size")
    private @Min(value=0L, message="Can't have less than zero bytes for std out size") Long stdOutSize;
    @Basic
    @Column(name="std_err_size")
    @Min(value=0L, message="Can't have less than zero bytes for std err size")
    private @Min(value=0L, message="Can't have less than zero bytes for std err size") Long stdErrSize;
    @Basic
    @Column(name="cluster_name")
    @Size(max=255, message="Max length in database is 255 characters")
    private @Size(max=255, message="Max length in database is 255 characters") String clusterName;
    @Basic
    @Column(name="command_name")
    @Size(max=255, message="Max length in database is 255 characters")
    private @Size(max=255, message="Max length in database is 255 characters") String commandName;
    @Basic
    @Column(name="status_msg")
    @Size(max=255, message="Max length in database is 255 characters")
    private @Size(max=255, message="Max length in database is 255 characters") String statusMsg;
    @Basic
    @Column(name="started")
    private Instant started;
    @Basic
    @Column(name="finished")
    private Instant finished;
    @Basic
    @Column(name="agent_hostname")
    @Size(max=255, message="An agent hostname can be no longer than 255 characters")
    private @Size(max=255, message="An agent hostname can be no longer than 255 characters") String agentHostname;
    @Basic
    @Column(name="agent_version")
    @Size(max=255, message="An agent version can be no longer than 255 characters")
    private @Size(max=255, message="An agent version can be no longer than 255 characters") String agentVersion;
    @Basic
    @Column(name="agent_pid")
    @Min(value=0L)
    private @Min(value=0L) Integer agentPid;
    @Basic
    @Column(name="process_id")
    private Integer processId;
    @Basic
    @Column(name="check_delay")
    @Min(value=1L)
    private @Min(value=1L) Long checkDelay;
    @Basic
    @Column(name="exit_code")
    private Integer exitCode;
    @Basic
    @Column(name="memory_used")
    private Integer memoryUsed;
    @Basic
    @Column(name="archive_location", length=1024)
    @Size(max=1024, message="Max length in database is 1024 characters")
    private @Size(max=1024, message="Max length in database is 1024 characters") String archiveLocation;
    @Basic(optional=false)
    @Column(name="interactive", nullable=false, updatable=false)
    private boolean interactive;
    @Basic(optional=false)
    @Column(name="resolved", nullable=false)
    private boolean resolved;
    @Basic(optional=false)
    @Column(name="claimed", nullable=false)
    private boolean claimed;
    @Basic(optional=false)
    @Column(name="v4", nullable=false)
    private boolean v4;
    @Basic
    @Column(name="requested_job_directory_location", length=1024, updatable=false)
    private String requestedJobDirectoryLocation;
    @Basic
    @Column(name="job_directory_location", length=1024)
    private String jobDirectoryLocation;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="requested_agent_config_ext", updatable=false, columnDefinition="TEXT DEFAULT NULL")
    @Convert(converter=JsonAttributeConverter.class)
    private JsonNode requestedAgentConfigExt;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="requested_agent_environment_ext", updatable=false, columnDefinition="TEXT DEFAULT NULL")
    @Convert(converter=JsonAttributeConverter.class)
    private JsonNode requestedAgentEnvironmentExt;
    @Basic
    @Column(name="timeout_used")
    private Integer timeoutUsed;
    @Basic(optional=false)
    @Column(name="api", nullable=false)
    private boolean api = true;
    @Basic
    @Column(name="archive_status", length=20)
    private String archiveStatus;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="requested_launcher_ext", columnDefinition="TEXT DEFAULT NULL")
    @Convert(converter=JsonAttributeConverter.class)
    private JsonNode requestedLauncherExt;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="launcher_ext", columnDefinition="TEXT DEFAULT NULL")
    @Convert(converter=JsonAttributeConverter.class)
    private JsonNode launcherExt;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="cluster_id")
    private ClusterEntity cluster;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="command_id")
    private CommandEntity command;
    @ElementCollection
    @CollectionTable(name="job_command_arguments", joinColumns={@JoinColumn(name="job_id", nullable=false, updatable=false)})
    @Column(name="argument", length=10000, nullable=false, updatable=false)
    @OrderColumn(name="argument_order", nullable=false, updatable=false)
    private List<@NotBlank @Size(max=10000) String> commandArgs = new ArrayList<String>();
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="job_requested_environment_variables", joinColumns={@JoinColumn(name="job_id", nullable=false, updatable=false)})
    @MapKeyColumn(name="name", updatable=false)
    @Column(name="value", length=1024, nullable=false, updatable=false)
    private Map<@NotBlank @Size(max=255) String, @NotNull @Size(max=1024) String> requestedEnvironmentVariables = Maps.newHashMap();
    @ElementCollection(fetch=FetchType.LAZY)
    @CollectionTable(name="job_environment_variables", joinColumns={@JoinColumn(name="job_id", nullable=false)})
    @MapKeyColumn(name="name")
    @Column(name="value", length=1024, nullable=false)
    private Map<@NotBlank @Size(max=255) String, @NotNull @Size(max=1024) String> environmentVariables = Maps.newHashMap();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="jobs_applications", joinColumns={@JoinColumn(name="job_id", referencedColumnName="id", nullable=false)}, inverseJoinColumns={@JoinColumn(name="application_id", referencedColumnName="id", nullable=false)})
    @OrderColumn(name="application_order", nullable=false, updatable=false)
    private List<ApplicationEntity> applications = new ArrayList<ApplicationEntity>();
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="jobs_cluster_criteria", joinColumns={@JoinColumn(name="job_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="criterion_id", referencedColumnName="id", nullable=false, updatable=false)})
    @OrderColumn(name="priority_order", nullable=false, updatable=false)
    private List<CriterionEntity> clusterCriteria = new ArrayList<CriterionEntity>();
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinColumn(name="command_criterion", nullable=false, updatable=false)
    private CriterionEntity commandCriterion;
    @ElementCollection
    @CollectionTable(name="job_requested_applications", joinColumns={@JoinColumn(name="job_id", nullable=false, updatable=false)})
    @Column(name="application_id", nullable=false, updatable=false)
    @OrderColumn(name="application_order", nullable=false, updatable=false)
    private List<String> requestedApplications = new ArrayList<String>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="jobs_configs", joinColumns={@JoinColumn(name="job_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> configs = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="jobs_dependencies", joinColumns={@JoinColumn(name="job_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> dependencies = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="jobs_tags", joinColumns={@JoinColumn(name="job_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="tag_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<TagEntity> tags = new HashSet<TagEntity>();
    @Transient
    private String notifiedJobStatus;

    @PrePersist
    void onCreateJob() {
        if (!this.tags.isEmpty()) {
            this.tagSearchString = PredicateUtils.createTagSearchString(this.tags);
        }
    }

    @Override
    public Optional<String> getGenieUserGroup() {
        return Optional.ofNullable(this.genieUserGroup);
    }

    @Override
    public Optional<String> getEmail() {
        return Optional.ofNullable(this.email);
    }

    @Override
    public Optional<Integer> getRequestedCpu() {
        return Optional.ofNullable(this.requestedCpu);
    }

    @Override
    public Optional<Integer> getRequestedTimeout() {
        return Optional.ofNullable(this.requestedTimeout);
    }

    public void setCommandCriterion(@Nullable CriterionEntity commandCriterion) {
        this.commandCriterion = commandCriterion;
    }

    @Override
    public Optional<String> getGrouping() {
        return Optional.ofNullable(this.grouping);
    }

    @Override
    public Optional<String> getGroupingInstance() {
        return Optional.ofNullable(this.groupingInstance);
    }

    @Override
    public Optional<String> getStatusMsg() {
        return Optional.ofNullable(this.statusMsg);
    }

    @Override
    public Optional<Instant> getStarted() {
        return Optional.ofNullable(this.started);
    }

    public void setStarted(@Nullable Instant started) {
        this.started = started;
    }

    @Override
    public Optional<Instant> getFinished() {
        return Optional.ofNullable(this.finished);
    }

    public void setFinished(@Nullable Instant finished) {
        this.finished = finished;
    }

    @Override
    public Optional<Integer> getRequestedMemory() {
        return Optional.ofNullable(this.requestedMemory);
    }

    @Override
    public Optional<String> getRequestApiClientHostname() {
        return Optional.ofNullable(this.requestApiClientHostname);
    }

    @Override
    public Optional<String> getRequestApiClientUserAgent() {
        return Optional.ofNullable(this.requestApiClientUserAgent);
    }

    @Override
    public Optional<Integer> getNumAttachments() {
        return Optional.ofNullable(this.numAttachments);
    }

    @Override
    public Optional<String> getRequestAgentClientHostname() {
        return Optional.ofNullable(this.requestAgentClientHostname);
    }

    @Override
    public Optional<String> getRequestAgentClientVersion() {
        return Optional.ofNullable(this.requestAgentClientVersion);
    }

    @Override
    public Optional<Integer> getExitCode() {
        return Optional.ofNullable(this.exitCode);
    }

    @Override
    public Optional<String> getArchiveLocation() {
        return Optional.ofNullable(this.archiveLocation);
    }

    @Override
    public Optional<Integer> getMemoryUsed() {
        return Optional.ofNullable(this.memoryUsed);
    }

    @Override
    public Optional<ClusterEntity> getCluster() {
        return Optional.ofNullable(this.cluster);
    }

    public void setCluster(@Nullable ClusterEntity cluster) {
        if (this.cluster != null) {
            this.clusterName = null;
        }
        this.cluster = cluster;
        if (this.cluster != null) {
            this.clusterName = cluster.getName();
        }
    }

    @Override
    public Optional<CommandEntity> getCommand() {
        return Optional.ofNullable(this.command);
    }

    public void setCommand(@Nullable CommandEntity command) {
        if (this.command != null) {
            this.commandName = null;
        }
        this.command = command;
        if (this.command != null) {
            this.commandName = command.getName();
        }
    }

    @Override
    public Optional<Long> getTotalSizeOfAttachments() {
        return Optional.ofNullable(this.totalSizeOfAttachments);
    }

    @Override
    public Optional<Long> getStdOutSize() {
        return Optional.ofNullable(this.stdOutSize);
    }

    public void setStdOutSize(@Nullable Long stdOutSize) {
        this.stdOutSize = stdOutSize;
    }

    @Override
    public Optional<Long> getStdErrSize() {
        return Optional.ofNullable(this.stdErrSize);
    }

    public void setStdErrSize(@Nullable Long stdErrSize) {
        this.stdErrSize = stdErrSize;
    }

    public Optional<Integer> getRequestAgentClientPid() {
        return Optional.ofNullable(this.requestAgentClientPid);
    }

    @Override
    public Optional<String> getClusterName() {
        return Optional.ofNullable(this.clusterName);
    }

    @Override
    public Optional<String> getCommandName() {
        return Optional.ofNullable(this.commandName);
    }

    @Override
    public Optional<String> getAgentHostname() {
        return Optional.ofNullable(this.agentHostname);
    }

    public Optional<String> getAgentVersion() {
        return Optional.ofNullable(this.agentVersion);
    }

    public Optional<Integer> getAgentPid() {
        return Optional.ofNullable(this.agentPid);
    }

    @Override
    public Optional<Integer> getProcessId() {
        return Optional.ofNullable(this.processId);
    }

    @Override
    public Optional<Long> getCheckDelay() {
        return Optional.ofNullable(this.checkDelay);
    }

    @Override
    public Optional<Integer> getTimeoutUsed() {
        return Optional.ofNullable(this.timeoutUsed);
    }

    public void setTimeoutUsed(@Nullable Integer timeoutUsed) {
        this.timeoutUsed = timeoutUsed;
    }

    public void setCommandArgs(@Nullable List<String> commandArgs) {
        this.commandArgs.clear();
        if (commandArgs != null) {
            this.commandArgs.addAll(commandArgs);
        }
    }

    public void setConfigs(@Nullable Set<FileEntity> configs) {
        this.configs.clear();
        if (configs != null) {
            this.configs.addAll(configs);
        }
    }

    public void setDependencies(@Nullable Set<FileEntity> dependencies) {
        this.dependencies.clear();
        if (dependencies != null) {
            this.dependencies.addAll(dependencies);
        }
    }

    public void setTags(@Nullable Set<TagEntity> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    public void setRequestedEnvironmentVariables(@Nullable Map<String, String> requestedEnvironmentVariables) {
        this.requestedEnvironmentVariables.clear();
        if (requestedEnvironmentVariables != null) {
            this.requestedEnvironmentVariables.putAll(requestedEnvironmentVariables);
        }
    }

    public void setEnvironmentVariables(@Nullable Map<String, String> environmentVariables) {
        this.environmentVariables.clear();
        if (environmentVariables != null) {
            this.environmentVariables.putAll(environmentVariables);
        }
    }

    @Override
    public Optional<String> getRequestedJobDirectoryLocation() {
        return Optional.ofNullable(this.requestedJobDirectoryLocation);
    }

    @Override
    public Optional<JsonNode> getRequestedAgentEnvironmentExt() {
        return Optional.ofNullable(this.requestedAgentEnvironmentExt);
    }

    @Override
    public Optional<JsonNode> getRequestedAgentConfigExt() {
        return Optional.ofNullable(this.requestedAgentConfigExt);
    }

    @Override
    public Optional<String> getJobDirectoryLocation() {
        return Optional.ofNullable(this.jobDirectoryLocation);
    }

    public void setApplications(@Nullable List<ApplicationEntity> applications) {
        this.applications.clear();
        if (applications != null) {
            this.applications.addAll(applications);
        }
    }

    public void setClusterCriteria(@Nullable List<CriterionEntity> clusterCriteria) {
        this.clusterCriteria.clear();
        if (clusterCriteria != null) {
            this.clusterCriteria.addAll(clusterCriteria);
        }
    }

    public Optional<String> getNotifiedJobStatus() {
        return Optional.ofNullable(this.notifiedJobStatus);
    }

    @Override
    public Optional<String> getArchiveStatus() {
        return Optional.ofNullable(this.archiveStatus);
    }

    public void setArchiveStatus(@Nullable String archiveStatus) {
        this.archiveStatus = archiveStatus;
    }

    public Optional<JsonNode> getRequestedLauncherExt() {
        return Optional.ofNullable(this.requestedLauncherExt);
    }

    public void setRequestedLauncherExt(@Nullable JsonNode requestedLauncherExt) {
        this.requestedLauncherExt = requestedLauncherExt;
    }

    @Override
    public Optional<JsonNode> getLauncherExt() {
        return Optional.ofNullable(this.launcherExt);
    }

    public void setLauncherExt(@Nullable JsonNode launcherExt) {
        this.launcherExt = launcherExt;
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public boolean isArchivingDisabled() {
        return this.archivingDisabled;
    }

    @Override
    public boolean isInteractive() {
        return this.interactive;
    }

    @Override
    public boolean isResolved() {
        return this.resolved;
    }

    public boolean isClaimed() {
        return this.claimed;
    }

    public boolean isV4() {
        return this.v4;
    }

    @Override
    public boolean isApi() {
        return this.api;
    }

    @Override
    public List<@NotBlank @Size(max=10000) String> getCommandArgs() {
        return this.commandArgs;
    }

    @Override
    public Map<@NotBlank @Size(max=255) String, @NotNull @Size(max=1024) String> getRequestedEnvironmentVariables() {
        return this.requestedEnvironmentVariables;
    }

    @Override
    public Map<@NotBlank @Size(max=255) String, @NotNull @Size(max=1024) String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    @Override
    public List<ApplicationEntity> getApplications() {
        return this.applications;
    }

    @Override
    public List<CriterionEntity> getClusterCriteria() {
        return this.clusterCriteria;
    }

    @Override
    public CriterionEntity getCommandCriterion() {
        return this.commandCriterion;
    }

    @Override
    public List<String> getRequestedApplications() {
        return this.requestedApplications;
    }

    @Override
    public Set<FileEntity> getConfigs() {
        return this.configs;
    }

    @Override
    public Set<FileEntity> getDependencies() {
        return this.dependencies;
    }

    @Override
    public Set<TagEntity> getTags() {
        return this.tags;
    }

    public void setGenieUserGroup(String genieUserGroup) {
        this.genieUserGroup = genieUserGroup;
    }

    public void setArchivingDisabled(boolean archivingDisabled) {
        this.archivingDisabled = archivingDisabled;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public void setRequestedCpu(Integer requestedCpu) {
        this.requestedCpu = requestedCpu;
    }

    public void setRequestedMemory(Integer requestedMemory) {
        this.requestedMemory = requestedMemory;
    }

    public void setRequestedTimeout(Integer requestedTimeout) {
        this.requestedTimeout = requestedTimeout;
    }

    public void setGrouping(String grouping) {
        this.grouping = grouping;
    }

    public void setGroupingInstance(String groupingInstance) {
        this.groupingInstance = groupingInstance;
    }

    public void setRequestApiClientHostname(String requestApiClientHostname) {
        this.requestApiClientHostname = requestApiClientHostname;
    }

    public void setRequestApiClientUserAgent(String requestApiClientUserAgent) {
        this.requestApiClientUserAgent = requestApiClientUserAgent;
    }

    public void setRequestAgentClientHostname(String requestAgentClientHostname) {
        this.requestAgentClientHostname = requestAgentClientHostname;
    }

    public void setRequestAgentClientVersion(String requestAgentClientVersion) {
        this.requestAgentClientVersion = requestAgentClientVersion;
    }

    public void setRequestAgentClientPid(Integer requestAgentClientPid) {
        this.requestAgentClientPid = requestAgentClientPid;
    }

    public void setNumAttachments(Integer numAttachments) {
        this.numAttachments = numAttachments;
    }

    public void setTotalSizeOfAttachments(Long totalSizeOfAttachments) {
        this.totalSizeOfAttachments = totalSizeOfAttachments;
    }

    public void setClusterName(String clusterName) {
        this.clusterName = clusterName;
    }

    public void setCommandName(String commandName) {
        this.commandName = commandName;
    }

    public void setStatusMsg(String statusMsg) {
        this.statusMsg = statusMsg;
    }

    public void setAgentHostname(String agentHostname) {
        this.agentHostname = agentHostname;
    }

    public void setAgentVersion(String agentVersion) {
        this.agentVersion = agentVersion;
    }

    public void setAgentPid(Integer agentPid) {
        this.agentPid = agentPid;
    }

    public void setProcessId(Integer processId) {
        this.processId = processId;
    }

    public void setCheckDelay(Long checkDelay) {
        this.checkDelay = checkDelay;
    }

    public void setExitCode(Integer exitCode) {
        this.exitCode = exitCode;
    }

    public void setMemoryUsed(Integer memoryUsed) {
        this.memoryUsed = memoryUsed;
    }

    public void setArchiveLocation(String archiveLocation) {
        this.archiveLocation = archiveLocation;
    }

    public void setInteractive(boolean interactive) {
        this.interactive = interactive;
    }

    public void setResolved(boolean resolved) {
        this.resolved = resolved;
    }

    public void setClaimed(boolean claimed) {
        this.claimed = claimed;
    }

    public void setV4(boolean v4) {
        this.v4 = v4;
    }

    public void setRequestedJobDirectoryLocation(String requestedJobDirectoryLocation) {
        this.requestedJobDirectoryLocation = requestedJobDirectoryLocation;
    }

    public void setJobDirectoryLocation(String jobDirectoryLocation) {
        this.jobDirectoryLocation = jobDirectoryLocation;
    }

    public void setRequestedAgentConfigExt(JsonNode requestedAgentConfigExt) {
        this.requestedAgentConfigExt = requestedAgentConfigExt;
    }

    public void setRequestedAgentEnvironmentExt(JsonNode requestedAgentEnvironmentExt) {
        this.requestedAgentEnvironmentExt = requestedAgentEnvironmentExt;
    }

    public void setApi(boolean api) {
        this.api = api;
    }

    public void setRequestedApplications(List<String> requestedApplications) {
        this.requestedApplications = requestedApplications;
    }

    public void setNotifiedJobStatus(String notifiedJobStatus) {
        this.notifiedJobStatus = notifiedJobStatus;
    }

    @Override
    public String toString() {
        return "JobEntity(super=" + super.toString() + ", tagSearchString=" + this.tagSearchString + ", genieUserGroup=" + this.genieUserGroup + ", archivingDisabled=" + this.archivingDisabled + ", email=" + this.email + ", requestedCpu=" + this.requestedCpu + ", requestedMemory=" + this.requestedMemory + ", requestedTimeout=" + this.requestedTimeout + ", grouping=" + this.grouping + ", groupingInstance=" + this.groupingInstance + ", requestApiClientHostname=" + this.requestApiClientHostname + ", requestApiClientUserAgent=" + this.requestApiClientUserAgent + ", requestAgentClientHostname=" + this.requestAgentClientHostname + ", requestAgentClientVersion=" + this.requestAgentClientVersion + ", requestAgentClientPid=" + this.requestAgentClientPid + ", numAttachments=" + this.numAttachments + ", totalSizeOfAttachments=" + this.totalSizeOfAttachments + ", stdOutSize=" + this.stdOutSize + ", stdErrSize=" + this.stdErrSize + ", clusterName=" + this.clusterName + ", commandName=" + this.commandName + ", statusMsg=" + this.statusMsg + ", started=" + this.started + ", finished=" + this.finished + ", agentHostname=" + this.agentHostname + ", agentVersion=" + this.agentVersion + ", agentPid=" + this.agentPid + ", processId=" + this.processId + ", checkDelay=" + this.checkDelay + ", exitCode=" + this.exitCode + ", memoryUsed=" + this.memoryUsed + ", archiveLocation=" + this.archiveLocation + ", interactive=" + this.interactive + ", resolved=" + this.resolved + ", claimed=" + this.claimed + ", v4=" + this.v4 + ", requestedJobDirectoryLocation=" + this.requestedJobDirectoryLocation + ", jobDirectoryLocation=" + this.jobDirectoryLocation + ", timeoutUsed=" + this.timeoutUsed + ", api=" + this.api + ", archiveStatus=" + this.archiveStatus + ")";
    }

    String getTagSearchString() {
        return this.tagSearchString;
    }
}

