/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.dtos;

import java.util.List;
import java.util.Map;
import javax.validation.constraints.NotNull;

public class TitusBatchJobRequest {
    @NotNull
    private final Owner owner;
    @NotNull
    private final String applicationName;
    @NotNull
    private final String capacityGroup;
    @NotNull
    private final Map<String, String> attributes;
    @NotNull
    private final Container container;
    @NotNull
    private final Batch batch;
    @NotNull
    private final DisruptionBudget disruptionBudget;

    public Owner getOwner() {
        return this.owner;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getCapacityGroup() {
        return this.capacityGroup;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public Container getContainer() {
        return this.container;
    }

    public Batch getBatch() {
        return this.batch;
    }

    public DisruptionBudget getDisruptionBudget() {
        return this.disruptionBudget;
    }

    public TitusBatchJobRequest(Owner owner, String applicationName, String capacityGroup, Map<String, String> attributes, Container container, Batch batch, DisruptionBudget disruptionBudget) {
        this.owner = owner;
        this.applicationName = applicationName;
        this.capacityGroup = capacityGroup;
        this.attributes = attributes;
        this.container = container;
        this.batch = batch;
        this.disruptionBudget = disruptionBudget;
    }

    public String toString() {
        return "TitusBatchJobRequest(owner=" + this.getOwner() + ", applicationName=" + this.getApplicationName() + ", capacityGroup=" + this.getCapacityGroup() + ", attributes=" + this.getAttributes() + ", container=" + this.getContainer() + ", batch=" + this.getBatch() + ", disruptionBudget=" + this.getDisruptionBudget() + ")";
    }

    public static class SelfManaged {
        private final long relocationTimeMs;

        public long getRelocationTimeMs() {
            return this.relocationTimeMs;
        }

        public SelfManaged(long relocationTimeMs) {
            this.relocationTimeMs = relocationTimeMs;
        }

        public String toString() {
            return "TitusBatchJobRequest.SelfManaged(relocationTimeMs=" + this.getRelocationTimeMs() + ")";
        }
    }

    public static class Immediate {
        private final int retries;

        public int getRetries() {
            return this.retries;
        }

        public Immediate(int retries) {
            this.retries = retries;
        }

        public String toString() {
            return "TitusBatchJobRequest.Immediate(retries=" + this.getRetries() + ")";
        }
    }

    public static class RetryPolicy {
        private final Immediate immediate;

        public Immediate getImmediate() {
            return this.immediate;
        }

        public RetryPolicy(Immediate immediate) {
            this.immediate = immediate;
        }

        public String toString() {
            return "TitusBatchJobRequest.RetryPolicy(immediate=" + this.getImmediate() + ")";
        }
    }

    public static class DisruptionBudget {
        private final SelfManaged selfManaged;

        public SelfManaged getSelfManaged() {
            return this.selfManaged;
        }

        public DisruptionBudget(SelfManaged selfManaged) {
            this.selfManaged = selfManaged;
        }

        public String toString() {
            return "TitusBatchJobRequest.DisruptionBudget(selfManaged=" + this.getSelfManaged() + ")";
        }
    }

    public static class Batch {
        private final int size;
        private final RetryPolicy retryPolicy;
        private final long runtimeLimitSec;

        public int getSize() {
            return this.size;
        }

        public RetryPolicy getRetryPolicy() {
            return this.retryPolicy;
        }

        public long getRuntimeLimitSec() {
            return this.runtimeLimitSec;
        }

        public Batch(int size, RetryPolicy retryPolicy, long runtimeLimitSec) {
            this.size = size;
            this.retryPolicy = retryPolicy;
            this.runtimeLimitSec = runtimeLimitSec;
        }

        public String toString() {
            return "TitusBatchJobRequest.Batch(size=" + this.getSize() + ", retryPolicy=" + this.getRetryPolicy() + ", runtimeLimitSec=" + this.getRuntimeLimitSec() + ")";
        }
    }

    public static class Image {
        private final String name;
        private final String tag;

        public String getName() {
            return this.name;
        }

        public String getTag() {
            return this.tag;
        }

        public Image(String name, String tag) {
            this.name = name;
            this.tag = tag;
        }

        public String toString() {
            return "TitusBatchJobRequest.Image(name=" + this.getName() + ", tag=" + this.getTag() + ")";
        }
    }

    public static class SecurityProfile {
        private final Map<String, String> attributes;
        private final List<String> securityGroups;
        private final String iamRole;

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public List<String> getSecurityGroups() {
            return this.securityGroups;
        }

        public String getIamRole() {
            return this.iamRole;
        }

        public SecurityProfile(Map<String, String> attributes, List<String> securityGroups, String iamRole) {
            this.attributes = attributes;
            this.securityGroups = securityGroups;
            this.iamRole = iamRole;
        }

        public String toString() {
            return "TitusBatchJobRequest.SecurityProfile(attributes=" + this.getAttributes() + ", securityGroups=" + this.getSecurityGroups() + ", iamRole=" + this.getIamRole() + ")";
        }
    }

    public static class Resources {
        private final int cpu;
        private final int gpu;
        private final long memoryMB;
        private final long diskMB;
        private final long networkMbps;

        public int getCpu() {
            return this.cpu;
        }

        public int getGpu() {
            return this.gpu;
        }

        public long getMemoryMB() {
            return this.memoryMB;
        }

        public long getDiskMB() {
            return this.diskMB;
        }

        public long getNetworkMbps() {
            return this.networkMbps;
        }

        public Resources(int cpu, int gpu, long memoryMB, long diskMB, long networkMbps) {
            this.cpu = cpu;
            this.gpu = gpu;
            this.memoryMB = memoryMB;
            this.diskMB = diskMB;
            this.networkMbps = networkMbps;
        }

        public String toString() {
            return "TitusBatchJobRequest.Resources(cpu=" + this.getCpu() + ", gpu=" + this.getGpu() + ", memoryMB=" + this.getMemoryMB() + ", diskMB=" + this.getDiskMB() + ", networkMbps=" + this.getNetworkMbps() + ")";
        }
    }

    public static class Container {
        private final Resources resources;
        private final SecurityProfile securityProfile;
        private final Image image;
        private final List<String> entryPoint;
        private final Map<String, String> env;

        public Resources getResources() {
            return this.resources;
        }

        public SecurityProfile getSecurityProfile() {
            return this.securityProfile;
        }

        public Image getImage() {
            return this.image;
        }

        public List<String> getEntryPoint() {
            return this.entryPoint;
        }

        public Map<String, String> getEnv() {
            return this.env;
        }

        public Container(Resources resources, SecurityProfile securityProfile, Image image, List<String> entryPoint, Map<String, String> env) {
            this.resources = resources;
            this.securityProfile = securityProfile;
            this.image = image;
            this.entryPoint = entryPoint;
            this.env = env;
        }

        public String toString() {
            return "TitusBatchJobRequest.Container(resources=" + this.getResources() + ", securityProfile=" + this.getSecurityProfile() + ", image=" + this.getImage() + ", entryPoint=" + this.getEntryPoint() + ", env=" + this.getEnv() + ")";
        }
    }

    public static class Owner {
        private final String teamEmail;

        public String getTeamEmail() {
            return this.teamEmail;
        }

        public Owner(String teamEmail) {
            this.teamEmail = teamEmail;
        }

        public String toString() {
            return "TitusBatchJobRequest.Owner(teamEmail=" + this.getTeamEmail() + ")";
        }
    }
}

