/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.events;

import com.netflix.genie.web.events.GenieEventBus;
import javax.annotation.Nullable;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ApplicationEventMulticaster;
import org.springframework.context.event.SimpleApplicationEventMulticaster;
import org.springframework.core.ResolvableType;

public class GenieEventBusImpl
implements GenieEventBus,
ApplicationEventMulticaster,
BeanClassLoaderAware,
BeanFactoryAware {
    private static final Logger log = LoggerFactory.getLogger(GenieEventBusImpl.class);
    private final SimpleApplicationEventMulticaster syncMulticaster;
    private final SimpleApplicationEventMulticaster asyncMulticaster;

    public GenieEventBusImpl(@NonNull SimpleApplicationEventMulticaster syncEventMulticaster, @NonNull SimpleApplicationEventMulticaster asyncEventMulticaster) {
        if (syncEventMulticaster == null) {
            throw new NullPointerException("syncEventMulticaster is marked non-null but is null");
        }
        if (asyncEventMulticaster == null) {
            throw new NullPointerException("asyncEventMulticaster is marked non-null but is null");
        }
        this.syncMulticaster = syncEventMulticaster;
        this.asyncMulticaster = asyncEventMulticaster;
    }

    @Override
    public void publishSynchronousEvent(@NonNull ApplicationEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.debug("Publishing synchronous event {}", (Object)event);
        this.syncMulticaster.multicastEvent(event);
    }

    @Override
    public void publishAsynchronousEvent(@NonNull ApplicationEvent event) {
        if (event == null) {
            throw new NullPointerException("event is marked non-null but is null");
        }
        log.debug("Publishing asynchronous event {}", (Object)event);
        this.asyncMulticaster.multicastEvent(event);
    }

    public void addApplicationListener(ApplicationListener<?> listener) {
        log.debug("Adding application listener {}", listener);
        this.syncMulticaster.addApplicationListener(listener);
        this.asyncMulticaster.addApplicationListener(listener);
    }

    public void addApplicationListenerBean(String listenerBeanName) {
        log.debug("Adding application listener bean with name {}", (Object)listenerBeanName);
        this.syncMulticaster.addApplicationListenerBean(listenerBeanName);
        this.asyncMulticaster.addApplicationListenerBean(listenerBeanName);
    }

    public void removeApplicationListener(ApplicationListener<?> listener) {
        log.debug("Removing application listener {}", listener);
        this.syncMulticaster.removeApplicationListener(listener);
        this.asyncMulticaster.removeApplicationListener(listener);
    }

    public void removeApplicationListenerBean(String listenerBeanName) {
        log.debug("Removing application listener bean with name {}", (Object)listenerBeanName);
        this.syncMulticaster.removeApplicationListenerBean(listenerBeanName);
        this.asyncMulticaster.removeApplicationListenerBean(listenerBeanName);
    }

    public void removeAllListeners() {
        log.debug("Removing all application listeners");
        this.syncMulticaster.removeAllListeners();
        this.asyncMulticaster.removeAllListeners();
    }

    public void multicastEvent(ApplicationEvent event) {
        log.debug("Multi-casting event {}", (Object)event);
        this.asyncMulticaster.multicastEvent(event);
    }

    public void multicastEvent(ApplicationEvent event, @Nullable ResolvableType eventType) {
        log.debug("Multi-casting event {} of type {}", (Object)event, (Object)eventType);
        this.asyncMulticaster.multicastEvent(event, eventType);
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.syncMulticaster.setBeanClassLoader(classLoader);
        this.asyncMulticaster.setBeanClassLoader(classLoader);
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        this.syncMulticaster.setBeanFactory(beanFactory);
        this.asyncMulticaster.setBeanFactory(beanFactory);
    }
}

