/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import java.time.Duration;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.agent.filestream")
@Validated
public class AgentFileStreamProperties {
    public static final String PROPERTY_PREFIX = "genie.agent.filestream";
    private int maxConcurrentTransfers = 100;
    private Duration unclaimedStreamStartTimeout = Duration.ofSeconds(10L);
    private Duration stalledTransferTimeout = Duration.ofSeconds(20L);
    private Duration stalledTransferCheckInterval = Duration.ofSeconds(5L);
    private Duration writeRetryDelay = Duration.ofMillis(300L);
    private Duration manifestCacheExpiration = Duration.ofSeconds(30L);

    public int getMaxConcurrentTransfers() {
        return this.maxConcurrentTransfers;
    }

    public Duration getUnclaimedStreamStartTimeout() {
        return this.unclaimedStreamStartTimeout;
    }

    public Duration getStalledTransferTimeout() {
        return this.stalledTransferTimeout;
    }

    public Duration getStalledTransferCheckInterval() {
        return this.stalledTransferCheckInterval;
    }

    public Duration getWriteRetryDelay() {
        return this.writeRetryDelay;
    }

    public Duration getManifestCacheExpiration() {
        return this.manifestCacheExpiration;
    }

    public void setMaxConcurrentTransfers(int maxConcurrentTransfers) {
        this.maxConcurrentTransfers = maxConcurrentTransfers;
    }

    public void setUnclaimedStreamStartTimeout(Duration unclaimedStreamStartTimeout) {
        this.unclaimedStreamStartTimeout = unclaimedStreamStartTimeout;
    }

    public void setStalledTransferTimeout(Duration stalledTransferTimeout) {
        this.stalledTransferTimeout = stalledTransferTimeout;
    }

    public void setStalledTransferCheckInterval(Duration stalledTransferCheckInterval) {
        this.stalledTransferCheckInterval = stalledTransferCheckInterval;
    }

    public void setWriteRetryDelay(Duration writeRetryDelay) {
        this.writeRetryDelay = writeRetryDelay;
    }

    public void setManifestCacheExpiration(Duration manifestCacheExpiration) {
        this.manifestCacheExpiration = manifestCacheExpiration;
    }
}

