/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import org.hibernate.validator.constraints.time.DurationMin;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.agent.launcher.titus")
@Validated
public class TitusAgentLauncherProperties {
    public static final String PREFIX = "genie.agent.launcher.titus";
    public static final String ENABLE_PROPERTY = "genie.agent.launcher.titus.enabled";
    public static final String JOB_ID_PLACEHOLDER = "<JOB_ID>";
    public static final String SERVER_HOST_PLACEHOLDER = "<SERVER_HOST>";
    public static final String SERVER_PORT_PLACEHOLDER = "<SERVER_PORT>";
    private boolean enabled;
    private URI endpoint = URI.create("https://example-titus-endpoint.tld:1234");
    @NotEmpty(message="The command-line launch template cannot be empty")
    private @NotEmpty(message="The command-line launch template cannot be empty") List<@NotBlank String> entryPointTemplate = Lists.newArrayList((Object[])new String[]{"/bin/genie-agent", "exec", "--api-job", "--launchInJobDirectory", "--job-id", "<JOB_ID>", "--server-host", "<SERVER_HOST>", "--server-port", "<SERVER_PORT>"});
    @NotEmpty
    private String ownerEmail = "owners@genie.tld";
    @NotEmpty
    private String applicationName = "genie";
    @NotEmpty
    private String capacityGroup = "default";
    @NotNull
    private Map<String, String> securityAttributes = Maps.newHashMap();
    @NotNull
    private List<String> securityGroups = Lists.newArrayList();
    @NotEmpty
    private String iAmRole = "arn:aws:iam::000000000:role/SomeProfile";
    @NotEmpty
    private String imageName = "image-name";
    @NotEmpty
    private String imageTag = "latest";
    @NotNull
    private DataSize diskSize = DataSize.ofGigabytes((long)10L);
    @NotNull
    private DataSize networkBandwidth = DataSize.ofMegabytes((long)7L);
    @Min(value=0L)
    private @Min(value=0L) int retries;
    @DurationMin
    private Duration runtimeLimit = Duration.ofHours(12L);
    @NotEmpty
    private String genieServerHost = "example.genie.tld";
    @Min(value=0L)
    private @Min(value=0L) int genieServerPort = 9090;
    @Min(value=0L)
    private @Min(value=0L) int healthIndicatorMaxSize = 100;
    @DurationMin
    private Duration healthIndicatorExpiration = Duration.ofMinutes(30L);
    @NotNull
    private Map<String, String> additionalEnvironment = Maps.newHashMap();

    public boolean isEnabled() {
        return this.enabled;
    }

    public URI getEndpoint() {
        return this.endpoint;
    }

    public List<@NotBlank String> getEntryPointTemplate() {
        return this.entryPointTemplate;
    }

    public String getOwnerEmail() {
        return this.ownerEmail;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public String getCapacityGroup() {
        return this.capacityGroup;
    }

    public Map<String, String> getSecurityAttributes() {
        return this.securityAttributes;
    }

    public List<String> getSecurityGroups() {
        return this.securityGroups;
    }

    public String getIAmRole() {
        return this.iAmRole;
    }

    public String getImageName() {
        return this.imageName;
    }

    public String getImageTag() {
        return this.imageTag;
    }

    public DataSize getDiskSize() {
        return this.diskSize;
    }

    public DataSize getNetworkBandwidth() {
        return this.networkBandwidth;
    }

    public int getRetries() {
        return this.retries;
    }

    public Duration getRuntimeLimit() {
        return this.runtimeLimit;
    }

    public String getGenieServerHost() {
        return this.genieServerHost;
    }

    public int getGenieServerPort() {
        return this.genieServerPort;
    }

    public int getHealthIndicatorMaxSize() {
        return this.healthIndicatorMaxSize;
    }

    public Duration getHealthIndicatorExpiration() {
        return this.healthIndicatorExpiration;
    }

    public Map<String, String> getAdditionalEnvironment() {
        return this.additionalEnvironment;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setEndpoint(URI endpoint) {
        this.endpoint = endpoint;
    }

    public void setEntryPointTemplate(List<@NotBlank String> entryPointTemplate) {
        this.entryPointTemplate = entryPointTemplate;
    }

    public void setOwnerEmail(String ownerEmail) {
        this.ownerEmail = ownerEmail;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public void setCapacityGroup(String capacityGroup) {
        this.capacityGroup = capacityGroup;
    }

    public void setSecurityAttributes(Map<String, String> securityAttributes) {
        this.securityAttributes = securityAttributes;
    }

    public void setSecurityGroups(List<String> securityGroups) {
        this.securityGroups = securityGroups;
    }

    public void setIAmRole(String iAmRole) {
        this.iAmRole = iAmRole;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public void setImageTag(String imageTag) {
        this.imageTag = imageTag;
    }

    public void setDiskSize(DataSize diskSize) {
        this.diskSize = diskSize;
    }

    public void setNetworkBandwidth(DataSize networkBandwidth) {
        this.networkBandwidth = networkBandwidth;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    public void setRuntimeLimit(Duration runtimeLimit) {
        this.runtimeLimit = runtimeLimit;
    }

    public void setGenieServerHost(String genieServerHost) {
        this.genieServerHost = genieServerHost;
    }

    public void setGenieServerPort(int genieServerPort) {
        this.genieServerPort = genieServerPort;
    }

    public void setHealthIndicatorMaxSize(int healthIndicatorMaxSize) {
        this.healthIndicatorMaxSize = healthIndicatorMaxSize;
    }

    public void setHealthIndicatorExpiration(Duration healthIndicatorExpiration) {
        this.healthIndicatorExpiration = healthIndicatorExpiration;
    }

    public void setAdditionalEnvironment(Map<String, String> additionalEnvironment) {
        this.additionalEnvironment = additionalEnvironment;
    }
}

