/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.tasks.node;

import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.properties.DiskCleanupProperties;
import com.netflix.genie.web.properties.JobsProperties;
import com.netflix.genie.web.tasks.node.DiskCleanupTask;
import io.micrometer.core.instrument.MeterRegistry;
import java.io.IOException;
import org.apache.commons.exec.Executor;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.Resource;
import org.springframework.scheduling.TaskScheduler;

@Configuration
@EnableConfigurationProperties(value={DiskCleanupProperties.class})
public class NodeAutoConfiguration {
    @Bean
    @ConditionalOnProperty(value={"genie.tasks.disk-cleanup.enabled"}, havingValue="true")
    @ConditionalOnMissingBean(value={DiskCleanupTask.class})
    public DiskCleanupTask diskCleanupTask(DiskCleanupProperties properties, @Qualifier(value="genieTaskScheduler") TaskScheduler scheduler, @Qualifier(value="jobsDir") Resource jobsDir, DataServices dataServices, JobsProperties jobsProperties, Executor processExecutor, MeterRegistry registry) throws IOException {
        return new DiskCleanupTask(properties, scheduler, jobsDir, dataServices, jobsProperties, processExecutor, registry);
    }
}

