/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.launchers.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.dtos.TitusBatchJobRequest;
import com.netflix.genie.web.dtos.TitusBatchJobResponse;
import com.netflix.genie.web.exceptions.checked.AgentLaunchException;
import com.netflix.genie.web.properties.TitusAgentLauncherProperties;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.unit.DataSize;
import org.springframework.web.client.RestTemplate;

public class TitusAgentLauncherImpl
implements AgentLauncher {
    private static final Logger log = LoggerFactory.getLogger(TitusAgentLauncherImpl.class);
    static final int MEGABYTE_TO_MEGABIT = 8;
    private static final String GENIE_USER_ATTR = "genie.user";
    private static final String GENIE_SOURCE_HOST_ATTR = "genie.sourceHost";
    private static final String GENIE_ENDPOINT_ATTR = "genie.endpoint";
    private static final String GENIE_JOB_ID_ATTR = "genie.jobId";
    private static final String TITUS_API_JOB_PATH = "/api/v3/jobs";
    private static final String TITUS_JOB_ID_EXT_FIELD = "titusId";
    private static final String TITUS_JOB_REQUEST_EXT_FIELD = "titusRequest";
    private static final String TITUS_JOB_RESPONSE_EXT_FIELD = "titusResponse";
    private static final String THIS_CLASS = TitusAgentLauncherImpl.class.getCanonicalName();
    private static final Tag CLASS_TAG = Tag.of((String)"launcherClass", (String)THIS_CLASS);
    private static final int TITUS_JOB_BATCH_SIZE = 1;
    private static final int ZERO = 0;
    private final RestTemplate restTemplate;
    private final Cache<String, String> healthIndicatorCache;
    private final GenieHostInfo genieHostInfo;
    private final TitusAgentLauncherProperties titusAgentLauncherProperties;
    private final Environment environment;
    private final boolean hasDataSizeConverters;
    private final MeterRegistry registry;

    public TitusAgentLauncherImpl(RestTemplate restTemplate, Cache<String, String> healthIndicatorCache, GenieHostInfo genieHostInfo, TitusAgentLauncherProperties titusAgentLauncherProperties, Environment environment, MeterRegistry registry) {
        ConfigurableEnvironment configurableEnvironment;
        ConfigurableConversionService conversionService;
        this.restTemplate = restTemplate;
        this.healthIndicatorCache = healthIndicatorCache;
        this.genieHostInfo = genieHostInfo;
        this.titusAgentLauncherProperties = titusAgentLauncherProperties;
        this.environment = environment;
        this.hasDataSizeConverters = this.environment instanceof ConfigurableEnvironment ? (conversionService = (configurableEnvironment = (ConfigurableEnvironment)this.environment).getConversionService()).canConvert(String.class, DataSize.class) && conversionService.canConvert(Integer.class, DataSize.class) : false;
        this.registry = registry;
    }

    @Override
    public Optional<JsonNode> launchAgent(ResolvedJob resolvedJob, @Nullable JsonNode requestedLauncherExt) throws AgentLaunchException {
        Optional<ObjectNode> optional;
        long start = System.nanoTime();
        log.info("Received request to launch Titus agent to run job: {}", (Object)resolvedJob);
        HashSet<Tag> tags = new HashSet<Tag>();
        tags.add(CLASS_TAG);
        String jobId = resolvedJob.getJobSpecification().getJob().getId();
        TitusBatchJobRequest titusJobRequest = this.createJobRequest(resolvedJob);
        String titusJobId = null;
        try {
            TitusBatchJobResponse titusResponse = (TitusBatchJobResponse)this.restTemplate.postForObject(this.titusAgentLauncherProperties.getEndpoint().toString() + TITUS_API_JOB_PATH, (Object)titusJobRequest, TitusBatchJobResponse.class, new Object[0]);
            if (titusResponse == null) {
                throw new AgentLaunchException("Failed to request creation of Titus job for job " + jobId);
            }
            titusJobId = titusResponse.getId();
            if (StringUtils.isBlank((CharSequence)titusJobId)) {
                throw new AgentLaunchException("Failed to create titus job for job " + jobId + " - " + titusResponse.getStatusCode() + ": " + titusResponse.getMessage());
            }
            log.info("Created Titus job {} to execute Genie job {}", (Object)titusJobId, (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
            optional = Optional.of(JsonNodeFactory.instance.objectNode().put("launcherClass", THIS_CLASS).put("sourceHostname", this.genieHostInfo.getHostname()).put(TITUS_JOB_ID_EXT_FIELD, titusJobId).putPOJO(TITUS_JOB_REQUEST_EXT_FIELD, (Object)titusJobRequest).putPOJO(TITUS_JOB_RESPONSE_EXT_FIELD, (Object)titusResponse));
        }
        catch (Exception e) {
            try {
                log.error("Failed to launch job on Titus", (Throwable)e);
                MetricsUtils.addFailureTagsWithException(tags, e);
                throw new AgentLaunchException("Failed to create titus job for job " + jobId, e);
            }
            catch (Throwable throwable) {
                this.registry.timer("genie.agents.launchers.launch.timer", tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                this.healthIndicatorCache.put((Object)jobId, (Object)(StringUtils.isBlank(titusJobId) ? "-" : titusJobId));
                throw throwable;
            }
        }
        this.registry.timer("genie.agents.launchers.launch.timer", tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        this.healthIndicatorCache.put((Object)jobId, (Object)(StringUtils.isBlank((CharSequence)titusJobId) ? "-" : titusJobId));
        return optional;
    }

    public Health health() {
        return Health.up().withDetails((Map)this.healthIndicatorCache.asMap()).build();
    }

    private TitusBatchJobRequest createJobRequest(ResolvedJob resolvedJob) {
        String jobId = resolvedJob.getJobSpecification().getJob().getId();
        ImmutableMap placeholdersMap = ImmutableMap.of((Object)"<JOB_ID>", (Object)jobId, (Object)"<SERVER_HOST>", (Object)this.titusAgentLauncherProperties.getGenieServerHost(), (Object)"<SERVER_PORT>", (Object)String.valueOf(this.titusAgentLauncherProperties.getGenieServerPort()));
        List<String> entryPoint = this.titusAgentLauncherProperties.getEntryPointTemplate().stream().map(arg_0 -> TitusAgentLauncherImpl.lambda$createJobRequest$0((Map)placeholdersMap, arg_0)).collect(Collectors.toList());
        long memory = Math.max(this.getDataSizeProperty("genie.agent.launcher.titus.minimumMemory", this.titusAgentLauncherProperties.getMinimumMemory()).toMegabytes(), (long)resolvedJob.getJobEnvironment().getMemory() + this.getDataSizeProperty("genie.agent.launcher.titus.additionalMemory", this.titusAgentLauncherProperties.getAdditionalMemory()).toMegabytes());
        int cpu = Math.max((Integer)this.environment.getProperty("genie.agent.launcher.titus.minimumCPU", Integer.class, (Object)this.titusAgentLauncherProperties.getMinimumCPU()), resolvedJob.getJobEnvironment().getCpu() + (Integer)this.environment.getProperty("genie.agent.launcher.titus.additionalCPU", Integer.class, (Object)this.titusAgentLauncherProperties.getAdditionalCPU()));
        long diskSize = Math.max(this.getDataSizeProperty("genie.agent.launcher.titus.minimumDiskSize", this.titusAgentLauncherProperties.getMinimumDiskSize()).toMegabytes(), 0L + this.getDataSizeProperty("genie.agent.launcher.titus.additionalDiskSize", this.titusAgentLauncherProperties.getAdditionalDiskSize()).toMegabytes());
        long networkMbps = Math.max(this.getDataSizeProperty("genie.agent.launcher.titus.minimumBandwidth", this.titusAgentLauncherProperties.getMinimumBandwidth()).toMegabytes(), 0L + this.getDataSizeProperty("genie.agent.launcher.titus.additionalBandwidth", this.titusAgentLauncherProperties.getAdditionalBandwidth()).toMegabytes()) * 8L;
        int gpus = Math.max((Integer)this.environment.getProperty("genie.agent.launcher.titus.minimumGPU", Integer.class, (Object)this.titusAgentLauncherProperties.getMinimumGPU()), 0 + (Integer)this.environment.getProperty("genie.agent.launcher.titus.additionalGPU", Integer.class, (Object)this.titusAgentLauncherProperties.getAdditionalGPU()));
        Duration runtimeLimit = this.titusAgentLauncherProperties.getRuntimeLimit();
        return new TitusBatchJobRequest(new TitusBatchJobRequest.Owner(this.titusAgentLauncherProperties.getOwnerEmail()), this.titusAgentLauncherProperties.getApplicationName(), (String)this.environment.getProperty("genie.agent.launcher.titus.capacityGroup", String.class, (Object)this.titusAgentLauncherProperties.getCapacityGroup()), (Map<String, String>)ImmutableMap.of((Object)GENIE_USER_ATTR, (Object)resolvedJob.getJobMetadata().getUser(), (Object)GENIE_SOURCE_HOST_ATTR, (Object)this.genieHostInfo.getHostname(), (Object)GENIE_ENDPOINT_ATTR, (Object)this.titusAgentLauncherProperties.getGenieServerHost(), (Object)GENIE_JOB_ID_ATTR, (Object)jobId), new TitusBatchJobRequest.Container(new TitusBatchJobRequest.Resources(cpu, gpus, memory, diskSize, networkMbps), new TitusBatchJobRequest.SecurityProfile(this.titusAgentLauncherProperties.getSecurityAttributes(), this.titusAgentLauncherProperties.getSecurityGroups(), this.titusAgentLauncherProperties.getIAmRole()), new TitusBatchJobRequest.Image((String)this.environment.getProperty("genie.agent.launcher.titus.imageName", String.class, (Object)this.titusAgentLauncherProperties.getImageName()), (String)this.environment.getProperty("genie.agent.launcher.titus.imageTag", String.class, (Object)this.titusAgentLauncherProperties.getImageTag())), entryPoint, this.titusAgentLauncherProperties.getAdditionalEnvironment()), new TitusBatchJobRequest.Batch(1, new TitusBatchJobRequest.RetryPolicy(new TitusBatchJobRequest.Immediate((Integer)this.environment.getProperty("genie.agent.launcher.titus.retries", Integer.class, (Object)this.titusAgentLauncherProperties.getRetries()))), runtimeLimit.getSeconds()), new TitusBatchJobRequest.DisruptionBudget(new TitusBatchJobRequest.SelfManaged(runtimeLimit.toMillis())));
    }

    private DataSize getDataSizeProperty(String propertyKey, DataSize defaultValue) {
        if (this.hasDataSizeConverters) {
            return (DataSize)this.environment.getProperty(propertyKey, DataSize.class, (Object)defaultValue);
        }
        String propValue = this.environment.getProperty(propertyKey);
        if (propValue != null) {
            try {
                return DataSize.parse((CharSequence)propValue);
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to parse value of {} as DataSize. Falling back to default value {}", new Object[]{propertyKey, defaultValue, e});
            }
        }
        return defaultValue;
    }

    private static /* synthetic */ String lambda$createJobRequest$0(Map placeholdersMap, String s) {
        return placeholdersMap.getOrDefault(s, s);
    }
}

