/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.queries.predicates;

import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.web.data.services.impl.jpa.entities.BaseEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity_;
import com.netflix.genie.web.data.services.impl.jpa.entities.IdEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.UniqueIdEntity;
import com.netflix.genie.web.data.services.impl.jpa.queries.predicates.PredicateUtils;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang3.StringUtils;

public final class CommandPredicates {
    private CommandPredicates() {
    }

    public static Predicate find(Root<CommandEntity> root, CriteriaQuery<?> cq, CriteriaBuilder cb, @Nullable String name, @Nullable String user, @Nullable Set<String> statuses, @Nullable Set<TagEntity> tags) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(CommandEntity_.name), name));
        }
        if (StringUtils.isNotBlank((CharSequence)user)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(CommandEntity_.user), user));
        }
        if (statuses != null && !statuses.isEmpty()) {
            predicates.add(cb.or((Predicate[])statuses.stream().map(status -> cb.equal((Expression)root.get(CommandEntity_.status), status)).toArray(Predicate[]::new)));
        }
        if (tags != null && !tags.isEmpty()) {
            SetJoin tagEntityJoin = root.join(CommandEntity_.tags);
            predicates.add(tagEntityJoin.in(tags));
            cq.groupBy(new Expression[]{root.get(CommandEntity_.id)});
            cq.having((Expression)cb.equal(cb.count((Expression)root.get(CommandEntity_.id)), (Object)tags.size()));
        }
        return cb.and(predicates.toArray(new Predicate[0]));
    }

    public static Predicate findCommandsMatchingCriterion(Root<CommandEntity> root, CriteriaQuery<?> cq, CriteriaBuilder cb, Criterion criterion) {
        Subquery criterionSubquery = cq.subquery(Long.class);
        Root criterionSubqueryRoot = criterionSubquery.from(CommandEntity.class);
        criterionSubquery.select((Expression)criterionSubqueryRoot.get(CommandEntity_.id));
        criterionSubquery.where((Expression)cb.and((Expression)PredicateUtils.createCriterionPredicate(criterionSubqueryRoot, criterionSubquery, cb, (SingularAttribute<UniqueIdEntity, String>)CommandEntity_.uniqueId, (SingularAttribute<BaseEntity, String>)CommandEntity_.name, (SingularAttribute<BaseEntity, String>)CommandEntity_.version, (SingularAttribute<BaseEntity, String>)CommandEntity_.status, () -> criterionSubqueryRoot.join(CommandEntity_.tags, JoinType.INNER), (SingularAttribute<IdEntity, Long>)CommandEntity_.id, criterion), (Expression)cb.isNotEmpty(criterionSubqueryRoot.get(CommandEntity_.clusterCriteria))));
        return root.get(CommandEntity_.id).in(new Expression[]{criterionSubquery});
    }
}

