/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.resources.writers;

import com.google.common.collect.Lists;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.web.resources.writers.DirectoryWriter;
import java.io.File;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.catalina.util.ServerInfo;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.validator.constraints.URL;

public class DefaultDirectoryWriter
implements DirectoryWriter {
    public static String directoryToHTML(String directoryName, Directory directory) {
        StringBuilder builder = new StringBuilder();
        builder.append("<!DOCTYPE html>");
        builder.append("<html>");
        builder.append("<head>");
        builder.append("<title>");
        builder.append(directoryName);
        builder.append("</title>");
        builder.append("<style type=\"text/css\"><!--");
        builder.append("body {font-family:Tahoma,Arial,sans-serif;} h1, h2, h3, b {color:white;background-color:#525D76;} h1 {font-size:22px;} h2 {font-size:16px;} h3 {font-size:14px;} p {font-size:12px;} a {color:black;} .line {height:1px;background-color:#525D76;border:none;}");
        builder.append("--></style> ");
        builder.append("</head>");
        builder.append("<body>");
        builder.append("<h1>").append(directoryName).append("</h1>");
        builder.append("<HR size=\"1\" noshade=\"noshade\">");
        builder.append("<table width=\"100%\" cellspacing=\"0\" cellpadding=\"5\" align=\"center\">");
        builder.append("<tr>");
        builder.append("<td align=\"left\"><font size=\"+1\"><strong>");
        builder.append("Filename");
        builder.append("</strong></font></td>");
        builder.append("<td align=\"right\"><font size=\"+1\"><strong>");
        builder.append("Size");
        builder.append("</strong></font></td>");
        builder.append("<td align=\"right\"><font size=\"+1\"><strong>");
        builder.append("Last Modified");
        builder.append("</strong></font></td>");
        builder.append("</tr>");
        if (directory.getParent() != null) {
            DefaultDirectoryWriter.writeFileHtml(builder, false, directory.getParent(), true);
        }
        boolean shade = true;
        if (directory.getDirectories() != null) {
            for (Entry entry : directory.getDirectories()) {
                DefaultDirectoryWriter.writeFileHtml(builder, shade, entry, true);
                shade = !shade;
            }
        }
        if (directory.getFiles() != null) {
            for (Entry entry : directory.getFiles()) {
                DefaultDirectoryWriter.writeFileHtml(builder, shade, entry, false);
                shade = !shade;
            }
        }
        builder.append("</table>");
        builder.append("<HR size=\"1\" noshade=\"noshade\">");
        builder.append("<h3>").append(ServerInfo.getServerInfo()).append("</h3>");
        builder.append("</body>");
        builder.append("</html>");
        return builder.toString();
    }

    private static void writeFileHtml(StringBuilder builder, boolean shade, Entry entry, boolean isDirectory) {
        builder.append("<tr");
        if (shade) {
            builder.append(" bgcolor=\"#eeeeee\"");
        }
        builder.append(">");
        builder.append("<td align=\"left\">&nbsp;&nbsp;");
        builder.append("<a href=\"").append(entry.getUrl()).append("\">");
        builder.append("<tt>").append(entry.getName()).append("</tt></a></td>");
        builder.append("<td align=\"right\"><tt>");
        if (isDirectory) {
            builder.append("-");
        } else {
            builder.append(FileUtils.byteCountToDisplaySize((long)entry.getSize()));
        }
        builder.append("</tt></td>");
        String lastModified = DateTimeFormatter.RFC_1123_DATE_TIME.format(entry.getLastModified().atOffset(ZoneOffset.UTC));
        builder.append("<td align=\"right\"><tt>").append(lastModified).append("</tt></td>");
        builder.append("</tr>");
    }

    @Override
    public String toHtml(@NotNull File directory, @URL String requestURL, boolean includeParent) throws IOException {
        Directory dir = this.getDirectory(directory, requestURL, includeParent);
        return DefaultDirectoryWriter.directoryToHTML(directory.getName(), dir);
    }

    @Override
    public String toJson(@NotNull File directory, @URL String requestURL, boolean includeParent) throws Exception {
        Directory dir = this.getDirectory(directory, requestURL, includeParent);
        return GenieObjectMapper.getMapper().writeValueAsString((Object)dir);
    }

    protected Directory getDirectory(File directory, String requestUrl, boolean includeParent) {
        String baseURL;
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException("Input directory is not a valid directory. Unable to continue.");
        }
        if (StringUtils.isBlank((CharSequence)requestUrl)) {
            throw new IllegalArgumentException("No request url entered. Unable to continue.");
        }
        Directory dir = new Directory();
        if (includeParent) {
            Entry parent = new Entry();
            String url = requestUrl;
            if (url.charAt(url.length() - 1) == '/') {
                url = url.substring(0, url.length() - 2);
            }
            url = url.substring(0, url.lastIndexOf(47));
            parent.setName("../");
            parent.setUrl(url);
            parent.setSize(0L);
            parent.setLastModified(Instant.ofEpochMilli(directory.getParentFile().getAbsoluteFile().lastModified()));
            dir.setParent(parent);
        }
        File[] files = directory.listFiles();
        dir.setDirectories(Lists.newArrayList());
        dir.setFiles(Lists.newArrayList());
        String string = baseURL = requestUrl.endsWith("/") ? requestUrl : requestUrl + "/";
        if (files != null) {
            for (File file : files) {
                Entry entry = new Entry();
                entry.setLastModified(Instant.ofEpochMilli(file.getAbsoluteFile().lastModified()));
                if (file.isDirectory()) {
                    entry.setName(file.getName() + "/");
                    entry.setUrl(baseURL + file.getName() + "/");
                    entry.setSize(0L);
                    dir.getDirectories().add(entry);
                    continue;
                }
                entry.setName(file.getName());
                entry.setUrl(baseURL + file.getName());
                entry.setSize(file.getAbsoluteFile().length());
                dir.getFiles().add(entry);
            }
        }
        dir.getDirectories().sort(Comparator.comparing(Entry::getName));
        dir.getFiles().sort(Comparator.comparing(Entry::getName));
        return dir;
    }

    public static class Entry {
        @NotBlank
        private String name;
        @URL
        private String url;
        @Min(value=0L)
        private @Min(value=0L) long size;
        @NotNull
        private Instant lastModified;

        public String getName() {
            return this.name;
        }

        public String getUrl() {
            return this.url;
        }

        public long getSize() {
            return this.size;
        }

        public Instant getLastModified() {
            return this.lastModified;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public void setSize(long size) {
            this.size = size;
        }

        public void setLastModified(Instant lastModified) {
            this.lastModified = lastModified;
        }

        public String toString() {
            return "DefaultDirectoryWriter.Entry(name=" + this.getName() + ", url=" + this.getUrl() + ", size=" + this.getSize() + ", lastModified=" + this.getLastModified() + ")";
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Entry)) {
                return false;
            }
            Entry other = (Entry)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            String this$url = this.getUrl();
            String other$url = other.getUrl();
            if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
                return false;
            }
            return this.getSize() == other.getSize();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Entry;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            String $url = this.getUrl();
            result = result * 59 + ($url == null ? 43 : $url.hashCode());
            long $size = this.getSize();
            result = result * 59 + (int)($size >>> 32 ^ $size);
            return result;
        }
    }

    public static class Directory {
        private Entry parent;
        private List<Entry> directories;
        private List<Entry> files;

        public Entry getParent() {
            return this.parent;
        }

        public List<Entry> getDirectories() {
            return this.directories;
        }

        public List<Entry> getFiles() {
            return this.files;
        }

        public void setParent(Entry parent) {
            this.parent = parent;
        }

        public void setDirectories(List<Entry> directories) {
            this.directories = directories;
        }

        public void setFiles(List<Entry> files) {
            this.files = files;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Directory)) {
                return false;
            }
            Directory other = (Directory)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Entry this$parent = this.getParent();
            Entry other$parent = other.getParent();
            if (this$parent == null ? other$parent != null : !((Object)this$parent).equals(other$parent)) {
                return false;
            }
            List<Entry> this$directories = this.getDirectories();
            List<Entry> other$directories = other.getDirectories();
            if (this$directories == null ? other$directories != null : !((Object)this$directories).equals(other$directories)) {
                return false;
            }
            List<Entry> this$files = this.getFiles();
            List<Entry> other$files = other.getFiles();
            return !(this$files == null ? other$files != null : !((Object)this$files).equals(other$files));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Directory;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Entry $parent = this.getParent();
            result = result * 59 + ($parent == null ? 43 : ((Object)$parent).hashCode());
            List<Entry> $directories = this.getDirectories();
            result = result * 59 + ($directories == null ? 43 : ((Object)$directories).hashCode());
            List<Entry> $files = this.getFiles();
            result = result * 59 + ($files == null ? 43 : ((Object)$files).hashCode());
            return result;
        }

        public String toString() {
            return "DefaultDirectoryWriter.Directory(parent=" + this.getParent() + ", directories=" + this.getDirectories() + ", files=" + this.getFiles() + ")";
        }
    }
}

