/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.agent.services;

import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.common.internal.util.PropertiesMapCache;
import com.netflix.genie.web.agent.inspectors.AgentMetadataInspector;
import com.netflix.genie.web.agent.services.AgentConfigurationService;
import com.netflix.genie.web.agent.services.AgentConnectionTrackingService;
import com.netflix.genie.web.agent.services.AgentFilterService;
import com.netflix.genie.web.agent.services.AgentJobService;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import com.netflix.genie.web.agent.services.impl.AgentConfigurationServiceImpl;
import com.netflix.genie.web.agent.services.impl.AgentConnectionTrackingServiceImpl;
import com.netflix.genie.web.agent.services.impl.AgentFilterServiceImpl;
import com.netflix.genie.web.agent.services.impl.AgentJobServiceImpl;
import com.netflix.genie.web.agent.services.impl.AgentRoutingServiceCuratorDiscoveryImpl;
import com.netflix.genie.web.agent.services.impl.AgentRoutingServiceSingleNodeImpl;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.properties.AgentConfigurationProperties;
import com.netflix.genie.web.properties.AgentConnectionTrackingServiceProperties;
import com.netflix.genie.web.properties.AgentRoutingServiceProperties;
import com.netflix.genie.web.services.JobResolverService;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.List;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.scheduling.TaskScheduler;

@Configuration
@EnableConfigurationProperties(value={AgentConfigurationProperties.class, AgentRoutingServiceProperties.class, AgentConnectionTrackingServiceProperties.class})
public class AgentServicesAutoConfiguration {
    @Bean
    @ConditionalOnMissingBean(value={AgentJobService.class})
    public AgentJobServiceImpl agentJobService(DataServices dataServices, JobResolverService jobResolverService, AgentFilterService agentFilterService, AgentConfigurationService agentConfigurationService, MeterRegistry meterRegistry) {
        return new AgentJobServiceImpl(dataServices, jobResolverService, agentFilterService, agentConfigurationService, meterRegistry);
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentConnectionTrackingService.class})
    public AgentConnectionTrackingService agentConnectionTrackingService(AgentRoutingService agentRoutingService, @Qualifier(value="genieTaskScheduler") TaskScheduler taskScheduler, AgentConnectionTrackingServiceProperties serviceProperties) {
        return new AgentConnectionTrackingServiceImpl(agentRoutingService, taskScheduler, serviceProperties);
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentRoutingService.class, ServiceDiscovery.class})
    public AgentRoutingService agentRoutingServiceSingleNodeImpl(GenieHostInfo genieHostInfo) {
        return new AgentRoutingServiceSingleNodeImpl(genieHostInfo);
    }

    @Bean
    @ConditionalOnBean(value={ServiceDiscovery.class})
    @ConditionalOnMissingBean(value={AgentRoutingService.class})
    public AgentRoutingService agentRoutingServiceCurator(GenieHostInfo genieHostInfo, ServiceDiscovery<AgentRoutingServiceCuratorDiscoveryImpl.Agent> serviceDiscovery, @Qualifier(value="genieTaskScheduler") TaskScheduler taskScheduler, Listenable<ConnectionStateListener> listenableCuratorConnectionState, MeterRegistry registry, AgentRoutingServiceProperties properties) {
        return new AgentRoutingServiceCuratorDiscoveryImpl(genieHostInfo, serviceDiscovery, taskScheduler, listenableCuratorConnectionState, registry, properties);
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentFilterService.class})
    public AgentFilterServiceImpl agentFilterService(List<AgentMetadataInspector> agentMetadataInspectorsList) {
        return new AgentFilterServiceImpl(agentMetadataInspectorsList);
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentConfigurationService.class})
    public AgentConfigurationServiceImpl agentConfigurationService(AgentConfigurationProperties agentConfigurationProperties, PropertiesMapCache.Factory propertiesMapCacheFactory, MeterRegistry registry) {
        return new AgentConfigurationServiceImpl(agentConfigurationProperties, propertiesMapCacheFactory.get(agentConfigurationProperties.getCacheRefreshInterval(), "genie.agent.configuration.dynamic."), registry);
    }
}

