/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.inspectors.impl;

import com.netflix.genie.web.agent.inspectors.AgentMetadataInspector;
import com.netflix.genie.web.agent.inspectors.InspectionReport;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class BaseRegexAgentMetadataInspector
implements AgentMetadataInspector {
    private static final Logger log = LoggerFactory.getLogger(BaseRegexAgentMetadataInspector.class);
    private final AtomicReference<Pattern> patternReference = new AtomicReference();
    private final InspectionReport.Decision decisionIfMatch;
    private String lastCompiledPattern;

    BaseRegexAgentMetadataInspector(InspectionReport.Decision decisionIfMatch) {
        this.decisionIfMatch = decisionIfMatch;
    }

    InspectionReport inspectWithPattern(@Nullable String currentPatternString, @Nullable String metadataAttribute) {
        Pattern currentPattern = this.maybeReloadPattern(currentPatternString);
        if (currentPattern == null) {
            return InspectionReport.newAcceptance("Pattern not not set");
        }
        if (StringUtils.isBlank((CharSequence)metadataAttribute)) {
            return InspectionReport.newRejection("Metadata attribute not set");
        }
        if (currentPattern.matcher(metadataAttribute).matches()) {
            return new InspectionReport(this.decisionIfMatch, "Attribute: " + metadataAttribute + " matches: " + currentPattern.pattern());
        }
        return new InspectionReport(InspectionReport.Decision.flip(this.decisionIfMatch), "Attribute: " + metadataAttribute + " does not match: " + currentPattern.pattern());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pattern maybeReloadPattern(@Nullable String currentPatternString) {
        BaseRegexAgentMetadataInspector baseRegexAgentMetadataInspector = this;
        synchronized (baseRegexAgentMetadataInspector) {
            if (StringUtils.isBlank((CharSequence)currentPatternString)) {
                this.patternReference.set(null);
                this.lastCompiledPattern = null;
            } else if (!currentPatternString.equals(this.lastCompiledPattern)) {
                try {
                    Pattern newPattern = Pattern.compile(currentPatternString);
                    this.patternReference.set(newPattern);
                }
                catch (PatternSyntaxException e) {
                    this.patternReference.set(null);
                    log.error("Failed to load pattern: {}", (Object)currentPatternString, (Object)e);
                }
                this.lastCompiledPattern = currentPatternString;
            }
        }
        return this.patternReference.get();
    }
}

