/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.resources;

import com.netflix.genie.web.agent.services.AgentFileStreamService;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.utils.URIBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ProtocolResolver;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.HttpRange;

public class AgentFileProtocolResolver
implements ProtocolResolver {
    private static final Logger log = LoggerFactory.getLogger(AgentFileProtocolResolver.class);
    private static final String URI_SCHEME = "agent";
    private static final Path ROOT_PATH = Paths.get(".", new String[0]).toAbsolutePath().getRoot();
    private final AgentFileStreamService agentFileStreamService;

    public AgentFileProtocolResolver(AgentFileStreamService agentFileStreamService) {
        this.agentFileStreamService = agentFileStreamService;
    }

    public static URI createUri(String jobId, String path, @Nullable String rangeHeader) throws URISyntaxException {
        String encodedJobId = Base64.encodeBase64URLSafeString((byte[])jobId.getBytes(Charset.defaultCharset()));
        return new URIBuilder().setScheme(URI_SCHEME).setHost(encodedJobId).setPath(path).setFragment(rangeHeader).build();
    }

    private static String getAgentResourceURIFileJobId(URI agentUri) {
        if (!URI_SCHEME.equals(agentUri.getScheme())) {
            throw new IllegalArgumentException("Not a valid Agent resource URI: " + agentUri);
        }
        return new String(Base64.decodeBase64((String)agentUri.getHost()), Charset.defaultCharset());
    }

    private static String getAgentResourceURIFilePath(URI agentUri) {
        if (!URI_SCHEME.equals(agentUri.getScheme())) {
            throw new IllegalArgumentException("Not a valid Agent resource URI: " + agentUri);
        }
        return agentUri.getPath();
    }

    public Resource resolve(String location, ResourceLoader resourceLoader) {
        List ranges;
        Path relativePath;
        String jobId;
        URI uri;
        log.debug("Attempting to resolve if {} is an Agent file resource or not", (Object)location);
        try {
            uri = URI.create(location);
            jobId = AgentFileProtocolResolver.getAgentResourceURIFileJobId(uri);
            relativePath = ROOT_PATH.relativize(Paths.get(AgentFileProtocolResolver.getAgentResourceURIFilePath(uri), new String[0])).normalize();
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.debug("{} is not a valid Agent resource (Error message: {}).", (Object)location, (Object)e.getMessage());
            return null;
        }
        String rangeHeader = uri.getFragment();
        try {
            ranges = HttpRange.parseRanges((String)rangeHeader);
        }
        catch (IllegalArgumentException | NullPointerException e) {
            log.warn("Invalid range header '{}' (Error message: {}).", (Object)rangeHeader, (Object)e.getMessage());
            return null;
        }
        if (ranges.size() > 1) {
            log.warn("Multiple HTTP ranges not supported");
            return null;
        }
        HttpRange rangeOrNull = ranges.isEmpty() ? null : (HttpRange)ranges.get(0);
        AgentFileStreamService.AgentFileResource resourceOrNull = this.agentFileStreamService.getResource(jobId, relativePath, uri, rangeOrNull).orElse(null);
        if (resourceOrNull != null) {
            log.debug("Returning resource: {}", (Object)resourceOrNull.getDescription());
        }
        return resourceOrNull;
    }
}

