/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.entities;

import com.netflix.genie.web.data.services.impl.jpa.entities.BaseEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.FileEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.Table;

@Entity
@Table(name="clusters")
@NamedEntityGraphs(value={@NamedEntityGraph(name="Cluster.dto", attributeNodes={@NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="tags")})})
public class ClusterEntity
extends BaseEntity {
    public static final String DTO_ENTITY_GRAPH = "Cluster.dto";
    private static final long serialVersionUID = -5674870110962005872L;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="clusters_configs", joinColumns={@JoinColumn(name="cluster_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> configs = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="clusters_dependencies", joinColumns={@JoinColumn(name="cluster_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> dependencies = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="clusters_tags", joinColumns={@JoinColumn(name="cluster_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="tag_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<TagEntity> tags = new HashSet<TagEntity>();

    public void setConfigs(@Nullable Set<FileEntity> configs) {
        this.configs.clear();
        if (configs != null) {
            this.configs.addAll(configs);
        }
    }

    public void setDependencies(@Nullable Set<FileEntity> dependencies) {
        this.dependencies.clear();
        if (dependencies != null) {
            this.dependencies.addAll(dependencies);
        }
    }

    public void setTags(@Nullable Set<TagEntity> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public Set<FileEntity> getConfigs() {
        return this.configs;
    }

    public Set<FileEntity> getDependencies() {
        return this.dependencies;
    }

    public Set<TagEntity> getTags() {
        return this.tags;
    }

    @Override
    public String toString() {
        return "ClusterEntity(super=" + super.toString() + ")";
    }
}

