/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.internal.util.PropertiesMapCache;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.properties.CommandSelectorManagedScriptProperties;
import com.netflix.genie.web.scripts.ResourceSelectorScript;
import com.netflix.genie.web.scripts.ResourceSelectorScriptResult;
import com.netflix.genie.web.scripts.ScriptManager;
import com.netflix.genie.web.selectors.CommandSelectionContext;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandSelectorManagedScript
extends ResourceSelectorScript<Command, CommandSelectionContext> {
    private static final Logger log = LoggerFactory.getLogger(CommandSelectorManagedScript.class);
    static final String COMMANDS_BINDING = "commandsParameter";

    public CommandSelectorManagedScript(ScriptManager scriptManager, CommandSelectorManagedScriptProperties properties, MeterRegistry registry, PropertiesMapCache propertyMapCache) {
        super(scriptManager, properties, registry, propertyMapCache);
    }

    @Override
    public ResourceSelectorScriptResult<Command> selectResource(CommandSelectionContext context) throws ResourceSelectionException {
        log.debug("Called to attempt to select a command from {} for job {}", context.getResources(), (Object)context.getJobId());
        return super.selectResource(context);
    }

    @Override
    protected void addParametersForScript(Map<String, Object> parameters, CommandSelectionContext context) {
        super.addParametersForScript(parameters, context);
        parameters.put(COMMANDS_BINDING, context.getResources());
    }
}

