/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.tasks.leader;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.netflix.genie.common.external.dtos.v4.ArchiveStatus;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.web.agent.services.AgentRoutingService;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.PersistenceService;
import com.netflix.genie.web.exceptions.checked.NotFoundException;
import com.netflix.genie.web.properties.ArchiveStatusCleanupProperties;
import com.netflix.genie.web.tasks.GenieTaskScheduleType;
import com.netflix.genie.web.tasks.leader.LeaderTask;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import java.time.Instant;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArchiveStatusCleanupTask
extends LeaderTask {
    private static final Logger log = LoggerFactory.getLogger(ArchiveStatusCleanupTask.class);
    private static final String CLEAR_ARCHIVE_STATUS_COUNTER_NAME = "genie.jobs.archiveStatus.cleanup.counter";
    private static final String CLEAR_ARCHIVE_STATUS_TIMER_NAME = "genie.tasks.archiveStatusCleanup.timer";
    private static final Set<ArchiveStatus> PENDING_STATUS_SET = ImmutableSet.of((Object)ArchiveStatus.PENDING);
    private final PersistenceService persistenceService;
    private final AgentRoutingService agentRoutingService;
    private final ArchiveStatusCleanupProperties properties;
    private final MeterRegistry registry;

    public ArchiveStatusCleanupTask(DataServices dataServices, AgentRoutingService agentRoutingService, ArchiveStatusCleanupProperties properties, MeterRegistry registry) {
        this.persistenceService = dataServices.getPersistenceService();
        this.agentRoutingService = agentRoutingService;
        this.properties = properties;
        this.registry = registry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            Instant updatedThreshold = Instant.now().minus(this.properties.getGracePeriod());
            Set<String> jobIds = this.persistenceService.getJobsWithStatusAndArchiveStatusUpdatedBefore(JobStatus.getFinishedStatuses(), PENDING_STATUS_SET, updatedThreshold);
            if (!jobIds.isEmpty()) {
                log.debug("Found {} finished jobs with PENDING archive status", (Object)jobIds.size());
                this.clearJobsArchiveStatus(jobIds);
            }
            MetricsUtils.addSuccessTags(tags);
        }
        catch (Exception e) {
            MetricsUtils.addFailureTagsWithException(tags, e);
            log.error("Archive status cleanup task failed with exception: {}", (Object)e.getMessage(), (Object)e);
        }
        finally {
            long taskDuration = System.nanoTime() - start;
            this.registry.timer(CLEAR_ARCHIVE_STATUS_TIMER_NAME, (Iterable)tags).record(taskDuration, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearJobsArchiveStatus(Set<String> jobIds) {
        for (String jobId : jobIds) {
            if (this.agentRoutingService.isAgentConnected(jobId)) {
                log.debug("Agent for job {} is still connected and probably archiving", (Object)jobId);
                continue;
            }
            log.warn("Marking job {} archive status to UNKNOWN", (Object)jobId);
            HashSet tags = Sets.newHashSet();
            try {
                this.persistenceService.updateJobArchiveStatus(jobId, ArchiveStatus.UNKNOWN);
                MetricsUtils.addSuccessTags(tags);
            }
            catch (NotFoundException e) {
                log.error("Tried to update a job that does not exist: {}", (Object)jobId);
                MetricsUtils.addFailureTagsWithException(tags, (Throwable)((Object)e));
            }
            finally {
                this.registry.counter(CLEAR_ARCHIVE_STATUS_COUNTER_NAME, (Iterable)tags).increment();
            }
        }
    }

    @Override
    public GenieTaskScheduleType getScheduleType() {
        return GenieTaskScheduleType.FIXED_RATE;
    }

    @Override
    public long getFixedRate() {
        return this.properties.getCheckInterval().toMillis();
    }
}

