/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.launchers.impl;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.benmanes.caffeine.cache.Cache;
import com.google.common.collect.ImmutableMap;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.agent.launchers.dtos.TitusBatchJobRequest;
import com.netflix.genie.web.agent.launchers.dtos.TitusBatchJobResponse;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.exceptions.checked.AgentLaunchException;
import com.netflix.genie.web.properties.TitusAgentLauncherProperties;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.time.Duration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.convert.support.ConfigurableConversionService;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.Environment;
import org.springframework.util.unit.DataSize;
import org.springframework.web.client.RestTemplate;

public class TitusAgentLauncherImpl
implements AgentLauncher {
    private static final Logger log = LoggerFactory.getLogger(TitusAgentLauncherImpl.class);
    static final int MEGABYTE_TO_MEGABIT = 8;
    private static final String GENIE_USER_ATTR = "genie.user";
    private static final String GENIE_SOURCE_HOST_ATTR = "genie.sourceHost";
    private static final String GENIE_ENDPOINT_ATTR = "genie.endpoint";
    private static final String GENIE_JOB_ID_ATTR = "genie.jobId";
    private static final String TITUS_API_JOB_PATH = "/api/v3/jobs";
    private static final String TITUS_JOB_ID_EXT_FIELD = "titusId";
    private static final String TITUS_JOB_REQUEST_EXT_FIELD = "titusRequest";
    private static final String TITUS_JOB_RESPONSE_EXT_FIELD = "titusResponse";
    private static final String THIS_CLASS = TitusAgentLauncherImpl.class.getCanonicalName();
    private static final Tag CLASS_TAG = Tag.of((String)"launcherClass", (String)THIS_CLASS);
    private static final int TITUS_JOB_BATCH_SIZE = 1;
    private static final int ZERO = 0;
    private static final BiFunction<List<String>, Map<String, String>, List<String>> REPLACE_PLACEHOLDERS = (template, placeholders) -> template.stream().map(s -> placeholders.getOrDefault(s, s)).collect(Collectors.toList());
    private final RestTemplate restTemplate;
    private final Cache<String, String> healthIndicatorCache;
    private final GenieHostInfo genieHostInfo;
    private final TitusAgentLauncherProperties titusAgentLauncherProperties;
    private final Environment environment;
    private final TitusJobRequestAdapter jobRequestAdapter;
    private final boolean hasDataSizeConverters;
    private final Binder binder;
    private final MeterRegistry registry;

    public TitusAgentLauncherImpl(RestTemplate restTemplate, TitusJobRequestAdapter jobRequestAdapter, Cache<String, String> healthIndicatorCache, GenieHostInfo genieHostInfo, TitusAgentLauncherProperties titusAgentLauncherProperties, Environment environment, MeterRegistry registry) {
        ConfigurableEnvironment configurableEnvironment;
        ConfigurableConversionService conversionService;
        this.restTemplate = restTemplate;
        this.healthIndicatorCache = healthIndicatorCache;
        this.genieHostInfo = genieHostInfo;
        this.titusAgentLauncherProperties = titusAgentLauncherProperties;
        this.jobRequestAdapter = jobRequestAdapter;
        this.environment = environment;
        this.hasDataSizeConverters = this.environment instanceof ConfigurableEnvironment ? (conversionService = (configurableEnvironment = (ConfigurableEnvironment)this.environment).getConversionService()).canConvert(String.class, DataSize.class) && conversionService.canConvert(Integer.class, DataSize.class) : false;
        this.binder = Binder.get((Environment)this.environment);
        this.registry = registry;
    }

    @Override
    public Optional<JsonNode> launchAgent(ResolvedJob resolvedJob, @Nullable JsonNode requestedLauncherExt) throws AgentLaunchException {
        Optional<ObjectNode> optional;
        long start = System.nanoTime();
        log.info("Received request to launch Titus agent to run job: {}", (Object)resolvedJob);
        HashSet<Tag> tags = new HashSet<Tag>();
        tags.add(CLASS_TAG);
        String jobId = resolvedJob.getJobSpecification().getJob().getId();
        String titusJobId = null;
        try {
            TitusBatchJobRequest titusJobRequest = this.createJobRequest(resolvedJob);
            TitusBatchJobResponse titusResponse = (TitusBatchJobResponse)this.restTemplate.postForObject(this.titusAgentLauncherProperties.getEndpoint().toString() + TITUS_API_JOB_PATH, (Object)titusJobRequest, TitusBatchJobResponse.class, new Object[0]);
            if (titusResponse == null) {
                throw new AgentLaunchException("Failed to request creation of Titus job for job " + jobId);
            }
            titusJobId = titusResponse.getId().orElseThrow(() -> new AgentLaunchException("Failed to create titus job for job " + jobId + " - Titus Status Code:" + titusResponse.getStatusCode().orElse(null) + ", Titus response message:" + titusResponse.getMessage().orElse("")));
            log.info("Created Titus job {} to execute Genie job {}", (Object)titusJobId, (Object)jobId);
            MetricsUtils.addSuccessTags(tags);
            optional = Optional.of(JsonNodeFactory.instance.objectNode().put("launcherClass", THIS_CLASS).put("sourceHostname", this.genieHostInfo.getHostname()).put(TITUS_JOB_ID_EXT_FIELD, titusJobId).putPOJO(TITUS_JOB_REQUEST_EXT_FIELD, (Object)titusJobRequest).putPOJO(TITUS_JOB_RESPONSE_EXT_FIELD, (Object)titusResponse));
        }
        catch (Exception e) {
            try {
                log.error("Failed to launch job on Titus", (Throwable)e);
                MetricsUtils.addFailureTagsWithException(tags, e);
                throw new AgentLaunchException("Failed to create titus job for job " + jobId, e);
            }
            catch (Throwable throwable) {
                this.registry.timer("genie.agents.launchers.launch.timer", tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
                this.healthIndicatorCache.put((Object)jobId, (Object)(StringUtils.isBlank(titusJobId) ? "-" : titusJobId));
                throw throwable;
            }
        }
        this.registry.timer("genie.agents.launchers.launch.timer", tags).record(System.nanoTime() - start, TimeUnit.NANOSECONDS);
        this.healthIndicatorCache.put((Object)jobId, (Object)(StringUtils.isBlank((CharSequence)titusJobId) ? "-" : titusJobId));
        return optional;
    }

    public Health health() {
        return Health.up().withDetails((Map)this.healthIndicatorCache.asMap()).build();
    }

    private TitusBatchJobRequest createJobRequest(ResolvedJob resolvedJob) throws AgentLaunchException {
        String jobId = resolvedJob.getJobSpecification().getJob().getId();
        ImmutableMap placeholdersMap = ImmutableMap.of((Object)"<JOB_ID>", (Object)jobId, (Object)"<SERVER_HOST>", (Object)this.titusAgentLauncherProperties.getGenieServerHost(), (Object)"<SERVER_PORT>", (Object)String.valueOf(this.titusAgentLauncherProperties.getGenieServerPort()));
        List<String> entryPoint = REPLACE_PLACEHOLDERS.apply(this.titusAgentLauncherProperties.getEntryPointTemplate(), (Map<String, String>)placeholdersMap);
        List<String> command = REPLACE_PLACEHOLDERS.apply(this.titusAgentLauncherProperties.getCommandTemplate(), (Map<String, String>)placeholdersMap);
        long memory = Math.max(this.getDataSizeProperty("genie.agent.launcher.titus.minimumMemory", this.titusAgentLauncherProperties.getMinimumMemory()).toMegabytes(), (long)resolvedJob.getJobEnvironment().getMemory() + this.getDataSizeProperty("genie.agent.launcher.titus.additionalMemory", this.titusAgentLauncherProperties.getAdditionalMemory()).toMegabytes());
        int cpu = Math.max((Integer)this.environment.getProperty("genie.agent.launcher.titus.minimumCPU", Integer.class, (Object)this.titusAgentLauncherProperties.getMinimumCPU()), resolvedJob.getJobEnvironment().getCpu() + (Integer)this.environment.getProperty("genie.agent.launcher.titus.additionalCPU", Integer.class, (Object)this.titusAgentLauncherProperties.getAdditionalCPU()));
        long diskSize = Math.max(this.getDataSizeProperty("genie.agent.launcher.titus.minimumDiskSize", this.titusAgentLauncherProperties.getMinimumDiskSize()).toMegabytes(), 0L + this.getDataSizeProperty("genie.agent.launcher.titus.additionalDiskSize", this.titusAgentLauncherProperties.getAdditionalDiskSize()).toMegabytes());
        long networkMbps = Math.max(this.getDataSizeProperty("genie.agent.launcher.titus.minimumBandwidth", this.titusAgentLauncherProperties.getMinimumBandwidth()).toMegabytes(), 0L + this.getDataSizeProperty("genie.agent.launcher.titus.additionalBandwidth", this.titusAgentLauncherProperties.getAdditionalBandwidth()).toMegabytes()) * 8L;
        int gpus = Math.max((Integer)this.environment.getProperty("genie.agent.launcher.titus.minimumGPU", Integer.class, (Object)this.titusAgentLauncherProperties.getMinimumGPU()), 0 + (Integer)this.environment.getProperty("genie.agent.launcher.titus.additionalGPU", Integer.class, (Object)this.titusAgentLauncherProperties.getAdditionalGPU()));
        Duration runtimeLimit = this.titusAgentLauncherProperties.getRuntimeLimit();
        Map<String, String> jobAttributes = this.createJobAttributes(jobId, resolvedJob);
        TitusBatchJobRequest request = TitusBatchJobRequest.builder().owner(TitusBatchJobRequest.Owner.builder().teamEmail(this.titusAgentLauncherProperties.getOwnerEmail()).build()).applicationName(this.titusAgentLauncherProperties.getApplicationName()).capacityGroup((String)this.environment.getProperty("genie.agent.launcher.titus.capacityGroup", String.class, (Object)this.titusAgentLauncherProperties.getCapacityGroup())).attributes(jobAttributes).container(TitusBatchJobRequest.Container.builder().resources(TitusBatchJobRequest.Resources.builder().cpu(cpu).gpu(gpus).memoryMB(memory).diskMB(diskSize).networkMbps(networkMbps).build()).securityProfile(TitusBatchJobRequest.SecurityProfile.builder().attributes(this.titusAgentLauncherProperties.getSecurityAttributes()).securityGroups(this.titusAgentLauncherProperties.getSecurityGroups()).iamRole(this.titusAgentLauncherProperties.getIAmRole()).build()).image(TitusBatchJobRequest.Image.builder().name((String)this.environment.getProperty("genie.agent.launcher.titus.imageName", String.class, (Object)this.titusAgentLauncherProperties.getImageName())).tag((String)this.environment.getProperty("genie.agent.launcher.titus.imageTag", String.class, (Object)this.titusAgentLauncherProperties.getImageTag())).build()).entryPoint(entryPoint).command(command).env((Map)this.binder.bind("genie.agent.launcher.titus.additional-environment", Bindable.mapOf(String.class, String.class)).orElse(new HashMap())).attributes((Map)this.binder.bind("genie.agent.launcher.titus.container-attributes", Bindable.mapOf(String.class, String.class)).orElse(new HashMap())).build()).batch(TitusBatchJobRequest.Batch.builder().size(1).retryPolicy(TitusBatchJobRequest.RetryPolicy.builder().immediate(TitusBatchJobRequest.Immediate.builder().retries((Integer)this.environment.getProperty("genie.agent.launcher.titus.retries", Integer.class, (Object)this.titusAgentLauncherProperties.getRetries())).build()).build()).runtimeLimitSec(runtimeLimit.getSeconds()).build()).disruptionBudget(TitusBatchJobRequest.DisruptionBudget.builder().selfManaged(TitusBatchJobRequest.SelfManaged.builder().relocationTimeMs(runtimeLimit.toMillis()).build()).build()).jobGroupInfo(TitusBatchJobRequest.JobGroupInfo.builder().stack(this.titusAgentLauncherProperties.getStack()).detail(this.titusAgentLauncherProperties.getDetail()).sequence(this.titusAgentLauncherProperties.getSequence()).build()).build();
        this.jobRequestAdapter.modifyJobRequest(request, resolvedJob);
        return request;
    }

    private DataSize getDataSizeProperty(String propertyKey, DataSize defaultValue) {
        if (this.hasDataSizeConverters) {
            return (DataSize)this.environment.getProperty(propertyKey, DataSize.class, (Object)defaultValue);
        }
        String propValue = this.environment.getProperty(propertyKey);
        if (propValue != null) {
            try {
                return DataSize.parse((CharSequence)propValue);
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to parse value of {} as DataSize. Falling back to default value {}", new Object[]{propertyKey, defaultValue, e});
            }
        }
        return defaultValue;
    }

    private Map<String, String> createJobAttributes(String jobId, ResolvedJob resolvedJob) {
        HashMap<String, String> jobAttributes = new HashMap<String, String>();
        jobAttributes.put(GENIE_USER_ATTR, resolvedJob.getJobMetadata().getUser());
        jobAttributes.put(GENIE_SOURCE_HOST_ATTR, this.genieHostInfo.getHostname());
        jobAttributes.put(GENIE_ENDPOINT_ATTR, this.titusAgentLauncherProperties.getGenieServerHost());
        jobAttributes.put(GENIE_JOB_ID_ATTR, jobId);
        jobAttributes.putAll((Map)this.binder.bind("genie.agent.launcher.titus.additional-job-attributes", Bindable.mapOf(String.class, String.class)).orElse(new HashMap()));
        return jobAttributes;
    }

    public static interface TitusJobRequestAdapter {
        default public void modifyJobRequest(TitusBatchJobRequest request, ResolvedJob resolvedJob) throws AgentLaunchException {
        }
    }
}

