/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.agent.filter")
@Validated
public class AgentFilterProperties
implements EnvironmentAware {
    static final String PROPERTY_PREFIX = "genie.agent.filter";
    public static final String VERSION_FILTER_ENABLED_PROPERTY = "genie.agent.filter.enabled";
    private static final String MINIMUM_VERSION_PROPERTY = "genie.agent.filter.version.minimum";
    private static final String BLACKLISTED_VERSION_REGEX_PROPERTY = "genie.agent.filter.version.blacklist";
    private static final String WHITELISTED_VERSION_REGEX_PROPERTY = "genie.agent.filter.version.whitelist";
    private AtomicReference<Environment> environment = new AtomicReference();

    public void setEnvironment(Environment environment) {
        this.environment.set(environment);
    }

    @Nullable
    public String getMinimumVersion() {
        return this.getValueOrNull(MINIMUM_VERSION_PROPERTY);
    }

    @Nullable
    public String getBlacklistedVersions() {
        return this.getValueOrNull(BLACKLISTED_VERSION_REGEX_PROPERTY);
    }

    @Nullable
    public String getWhitelistedVersions() {
        return this.getValueOrNull(WHITELISTED_VERSION_REGEX_PROPERTY);
    }

    private String getValueOrNull(String propertyKey) {
        Environment env = this.environment.get();
        if (env != null) {
            return env.getProperty(propertyKey);
        }
        return null;
    }
}

