/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.selectors.impl;

import com.netflix.genie.web.dtos.ResourceSelectionResult;
import com.netflix.genie.web.exceptions.checked.ResourceSelectionException;
import com.netflix.genie.web.selectors.ResourceSelectionContext;
import com.netflix.genie.web.selectors.ResourceSelector;
import java.util.Collection;
import java.util.Iterator;
import java.util.Random;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.NotEmpty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RandomResourceSelector<R, C extends ResourceSelectionContext<R>>
implements ResourceSelector<R, C> {
    private static final Logger log = LoggerFactory.getLogger(RandomResourceSelector.class);
    static final String SELECTION_RATIONALE = "Selected randomly";
    private final Random random = new Random();

    RandomResourceSelector() {
    }

    @Override
    public ResourceSelectionResult<R> select(@Valid C context) throws ResourceSelectionException {
        log.debug("Called to select for job {}", (Object)((ResourceSelectionContext)context).getJobId());
        ResourceSelectionResult.Builder builder = new ResourceSelectionResult.Builder(this.getClass());
        try {
            Object selectedResource = this.randomlySelect(((ResourceSelectionContext)context).getResources());
            return builder.withSelectionRationale(SELECTION_RATIONALE).withSelectedResource(selectedResource).build();
        }
        catch (Exception e) {
            throw new ResourceSelectionException(e);
        }
    }

    @Nullable
    private R randomlySelect(@NotEmpty Collection<R> resources) {
        int index = this.random.nextInt(resources.size());
        Iterator<R> resourceIterator = resources.iterator();
        R selectedResource = null;
        for (int i = 0; resourceIterator.hasNext() && i <= index; ++i) {
            selectedResource = resourceIterator.next();
        }
        return selectedResource;
    }
}

