/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.apis.rpc.servers;

import com.netflix.genie.web.agent.apis.rpc.servers.GRpcServerUtils;
import io.grpc.Server;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRpcServerManager
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(GRpcServerManager.class);
    private final Server server;

    public GRpcServerManager(Server server) throws IllegalStateException {
        this.server = server;
        GRpcServerUtils.startServer(this.server);
    }

    @Override
    public void close() {
        if (!this.server.isShutdown()) {
            this.server.shutdownNow();
        }
        try {
            if (this.server.awaitTermination(30L, TimeUnit.SECONDS)) {
                log.info("Successfully shut down the gRPC server");
            } else {
                log.error("Unable to successfully shutdown the gRPC server in time allotted");
            }
        }
        catch (InterruptedException ie) {
            log.error("Unable to shutdown gRPC server due to being interrupted", (Throwable)ie);
        }
    }

    public int getServerPort() {
        return this.server.getPort();
    }
}

