/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.services.impl;

import com.google.common.collect.Sets;
import com.netflix.genie.common.internal.util.PropertiesMapCache;
import com.netflix.genie.web.agent.services.AgentConfigurationService;
import com.netflix.genie.web.properties.AgentConfigurationProperties;
import com.netflix.genie.web.util.MetricsUtils;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentConfigurationServiceImpl
implements AgentConfigurationService {
    private static final Logger log = LoggerFactory.getLogger(AgentConfigurationServiceImpl.class);
    private static final String RELOAD_PROPERTIES_TIMER = "genie.services.agentConfiguration.reloadProperties.timer";
    private static final String PROPERTIES_COUNT_TAG = "numProperties";
    private final AgentConfigurationProperties agentConfigurationProperties;
    private final MeterRegistry registry;
    private final PropertiesMapCache propertiesMapCache;

    public AgentConfigurationServiceImpl(AgentConfigurationProperties agentConfigurationProperties, PropertiesMapCache propertyMapCache, MeterRegistry registry) {
        this.agentConfigurationProperties = agentConfigurationProperties;
        this.propertiesMapCache = propertyMapCache;
        this.registry = registry;
    }

    @Override
    public Map<String, String> getAgentProperties() {
        HashSet tags = Sets.newHashSet();
        long start = System.nanoTime();
        try {
            Map propertiesMap = this.propertiesMapCache.get();
            tags.add(Tag.of((String)PROPERTIES_COUNT_TAG, (String)String.valueOf(propertiesMap.size())));
            MetricsUtils.addSuccessTags(tags);
            Map map = propertiesMap;
            return map;
        }
        catch (Throwable t) {
            MetricsUtils.addFailureTagsWithException(tags, t);
            throw t;
        }
        finally {
            long end = System.nanoTime();
            this.registry.timer(RELOAD_PROPERTIES_TIMER, (Iterable)tags).record(end - start, TimeUnit.NANOSECONDS);
        }
    }
}

