/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services;

import com.fasterxml.jackson.databind.JsonNode;
import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.UserResourcesSummary;
import com.netflix.genie.common.dto.search.JobSearchResult;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.external.dtos.v4.AgentClientMetadata;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.common.external.dtos.v4.ApplicationRequest;
import com.netflix.genie.common.external.dtos.v4.ApplicationStatus;
import com.netflix.genie.common.external.dtos.v4.ArchiveStatus;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.ClusterRequest;
import com.netflix.genie.common.external.dtos.v4.ClusterStatus;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.CommandRequest;
import com.netflix.genie.common.external.dtos.v4.CommandStatus;
import com.netflix.genie.common.external.dtos.v4.CommonResource;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.JobSpecification;
import com.netflix.genie.common.external.dtos.v4.JobStatus;
import com.netflix.genie.common.internal.dtos.v4.FinishedJob;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieInvalidStatusException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobAlreadyClaimedException;
import com.netflix.genie.web.data.services.impl.jpa.queries.aggregates.JobInfoAggregate;
import com.netflix.genie.web.dtos.JobSubmission;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.exceptions.checked.IdAlreadyExistsException;
import com.netflix.genie.web.exceptions.checked.NotFoundException;
import com.netflix.genie.web.exceptions.checked.PreconditionFailedException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.validation.annotation.Validated;

@Validated
public interface PersistenceService {
    public String saveApplication(@Valid ApplicationRequest var1) throws IdAlreadyExistsException;

    public Application getApplication(@NotBlank String var1) throws NotFoundException;

    public Page<Application> findApplications(@Nullable String var1, @Nullable String var2, @Nullable Set<ApplicationStatus> var3, @Nullable Set<String> var4, @Nullable String var5, Pageable var6);

    public void updateApplication(@NotBlank String var1, @Valid Application var2) throws NotFoundException, PreconditionFailedException;

    public void deleteAllApplications() throws PreconditionFailedException;

    public void deleteApplication(@NotBlank String var1) throws PreconditionFailedException;

    public Set<Command> getCommandsForApplication(@NotBlank String var1, @Nullable Set<CommandStatus> var2) throws NotFoundException;

    public long deleteUnusedApplications(@NotNull Instant var1, @Min(value=1L) @Min(value=1L) int var2);

    public String saveCluster(@Valid ClusterRequest var1) throws IdAlreadyExistsException;

    public Cluster getCluster(@NotBlank String var1) throws NotFoundException;

    public Page<Cluster> findClusters(@Nullable String var1, @Nullable Set<ClusterStatus> var2, @Nullable Set<String> var3, @Nullable Instant var4, @Nullable Instant var5, Pageable var6);

    public void updateCluster(@NotBlank String var1, @Valid Cluster var2) throws NotFoundException, PreconditionFailedException;

    public void deleteAllClusters() throws PreconditionFailedException;

    public void deleteCluster(@NotBlank String var1) throws PreconditionFailedException;

    public long deleteUnusedClusters(Set<ClusterStatus> var1, @NotNull Instant var2, @Min(value=1L) @Min(value=1L) int var3);

    public Set<Cluster> findClustersMatchingCriterion(@Valid Criterion var1, boolean var2);

    public Set<Cluster> findClustersMatchingAnyCriterion(@NotEmpty Set<@Valid Criterion> var1, boolean var2);

    public String saveCommand(@Valid CommandRequest var1) throws IdAlreadyExistsException;

    public Command getCommand(@NotBlank String var1) throws NotFoundException;

    public Page<Command> findCommands(@Nullable String var1, @Nullable String var2, @Nullable Set<CommandStatus> var3, @Nullable Set<String> var4, Pageable var5);

    public void updateCommand(@NotBlank String var1, @Valid Command var2) throws NotFoundException, PreconditionFailedException;

    public void deleteAllCommands() throws PreconditionFailedException;

    public void deleteCommand(@NotBlank String var1) throws NotFoundException;

    public void addApplicationsForCommand(@NotBlank String var1, @NotEmpty List<@NotBlank String> var2) throws NotFoundException, PreconditionFailedException;

    public void setApplicationsForCommand(@NotBlank String var1, @NotNull List<@NotBlank String> var2) throws NotFoundException, PreconditionFailedException;

    public List<Application> getApplicationsForCommand(String var1) throws NotFoundException;

    public void removeApplicationsForCommand(@NotBlank String var1) throws NotFoundException, PreconditionFailedException;

    public void removeApplicationForCommand(@NotBlank String var1, @NotBlank String var2) throws NotFoundException;

    public Set<Cluster> getClustersForCommand(@NotBlank String var1, @Nullable Set<ClusterStatus> var2) throws NotFoundException;

    public List<Criterion> getClusterCriteriaForCommand(String var1) throws NotFoundException;

    public void addClusterCriterionForCommand(String var1, @Valid Criterion var2) throws NotFoundException;

    public void addClusterCriterionForCommand(String var1, @Valid Criterion var2, @Min(value=0L) @Min(value=0L) int var3) throws NotFoundException;

    public void setClusterCriteriaForCommand(String var1, List<@Valid Criterion> var2) throws NotFoundException;

    public void removeClusterCriterionForCommand(String var1, @Min(value=0L) @Min(value=0L) int var2) throws NotFoundException;

    public void removeAllClusterCriteriaForCommand(String var1) throws NotFoundException;

    public Set<Command> findCommandsMatchingCriterion(@Valid Criterion var1, boolean var2);

    public int updateStatusForUnusedCommands(CommandStatus var1, Instant var2, Set<CommandStatus> var3, int var4);

    public long deleteUnusedCommands(Set<CommandStatus> var1, @NotNull Instant var2, @Min(value=1L) @Min(value=1L) int var3);

    @Deprecated
    public JobRequest getV3JobRequest(@NotBlank String var1) throws GenieException;

    public Job getJob(@NotBlank String var1) throws GenieException;

    public JobExecution getJobExecution(@NotBlank String var1) throws GenieException;

    public JobMetadata getJobMetadata(@NotBlank String var1) throws GenieException;

    public Page<JobSearchResult> findJobs(@Nullable String var1, @Nullable String var2, @Nullable String var3, @Nullable Set<com.netflix.genie.common.dto.JobStatus> var4, @Nullable Set<String> var5, @Nullable String var6, @Nullable String var7, @Nullable String var8, @Nullable String var9, @Nullable Instant var10, @Nullable Instant var11, @Nullable Instant var12, @Nullable Instant var13, @Nullable String var14, @Nullable String var15, @NotNull Pageable var16);

    public long deleteJobsCreatedBefore(@NotNull Instant var1, @NotNull Set<JobStatus> var2, @Min(value=1L) @Min(value=1L) int var3);

    @Nonnull
    public String saveJobSubmission(@Valid JobSubmission var1) throws IdAlreadyExistsException;

    public com.netflix.genie.common.external.dtos.v4.JobRequest getJobRequest(@NotBlank String var1) throws NotFoundException;

    public void saveResolvedJob(@NotBlank String var1, @Valid ResolvedJob var2) throws NotFoundException;

    public Optional<JobSpecification> getJobSpecification(@NotBlank String var1) throws NotFoundException;

    public void claimJob(@NotBlank String var1, @Valid AgentClientMetadata var2) throws NotFoundException, GenieJobAlreadyClaimedException, GenieInvalidStatusException;

    public void updateJobStatus(@NotBlank String var1, @NotNull JobStatus var2, @NotNull JobStatus var3, @Nullable String var4) throws NotFoundException, GenieInvalidStatusException;

    public void updateJobArchiveStatus(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String var1, @NotNull(message="Status cannot be null.") @NotNull(message="Status cannot be null.") ArchiveStatus var2) throws NotFoundException;

    public JobStatus getJobStatus(@NotBlank String var1) throws NotFoundException;

    public ArchiveStatus getJobArchiveStatus(@NotBlank String var1) throws NotFoundException;

    public Optional<String> getJobArchiveLocation(@NotBlank String var1) throws NotFoundException;

    public FinishedJob getFinishedJob(@NotBlank String var1) throws NotFoundException, GenieInvalidStatusException;

    public boolean isApiJob(@NotBlank String var1) throws NotFoundException;

    public Cluster getJobCluster(@NotBlank String var1) throws NotFoundException;

    public Command getJobCommand(@NotBlank String var1) throws NotFoundException;

    public List<Application> getJobApplications(@NotBlank String var1) throws NotFoundException;

    public long getActiveJobCountForUser(@NotBlank String var1);

    public Map<String, UserResourcesSummary> getUserResourcesSummaries(Set<JobStatus> var1, boolean var2);

    public long getUsedMemoryOnHost(@NotBlank String var1);

    public Set<String> getActiveJobs();

    public Set<String> getUnclaimedJobs();

    public JobInfoAggregate getHostJobInformation(@NotBlank String var1);

    public Set<String> getJobsWithStatusAndArchiveStatusUpdatedBefore(@NotEmpty Set<JobStatus> var1, @NotEmpty Set<ArchiveStatus> var2, @NotNull Instant var3);

    public void updateRequestedLauncherExt(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String var1, @NotNull(message="Status cannot be null.") @NotNull(message="Status cannot be null.") JsonNode var2) throws NotFoundException;

    public JsonNode getRequestedLauncherExt(@NotBlank String var1) throws NotFoundException;

    public void updateLauncherExt(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String var1, @NotNull(message="Status cannot be null.") @NotNull(message="Status cannot be null.") JsonNode var2) throws NotFoundException;

    public JsonNode getLauncherExt(@NotBlank String var1) throws NotFoundException;

    public <R extends CommonResource> void addConfigsToResource(@NotBlank String var1, Set<@Size(max=1024) String> var2, Class<R> var3) throws NotFoundException;

    public <R extends CommonResource> Set<String> getConfigsForResource(@NotBlank String var1, Class<R> var2) throws NotFoundException;

    public <R extends CommonResource> void updateConfigsForResource(@NotBlank String var1, Set<@Size(max=1024) String> var2, Class<R> var3) throws NotFoundException;

    public <R extends CommonResource> void removeAllConfigsForResource(@NotBlank String var1, Class<R> var2) throws NotFoundException;

    public <R extends CommonResource> void removeConfigForResource(@NotBlank String var1, @NotBlank String var2, Class<R> var3) throws NotFoundException;

    public <R extends CommonResource> void addDependenciesToResource(@NotBlank String var1, Set<@Size(max=1024) String> var2, Class<R> var3) throws NotFoundException;

    public <R extends CommonResource> Set<String> getDependenciesForResource(@NotBlank String var1, Class<R> var2) throws NotFoundException;

    public <R extends CommonResource> void updateDependenciesForResource(@NotBlank String var1, Set<@Size(max=1024) String> var2, Class<R> var3) throws NotFoundException;

    public <R extends CommonResource> void removeAllDependenciesForResource(@NotBlank String var1, Class<R> var2) throws NotFoundException;

    public <R extends CommonResource> void removeDependencyForResource(@NotBlank String var1, @NotBlank String var2, Class<R> var3) throws NotFoundException;

    public <R extends CommonResource> void addTagsToResource(@NotBlank String var1, Set<@Size(max=255) String> var2, Class<R> var3) throws NotFoundException;

    public <R extends CommonResource> Set<String> getTagsForResource(@NotBlank String var1, Class<R> var2) throws NotFoundException;

    public <R extends CommonResource> void updateTagsForResource(@NotBlank String var1, Set<@Size(max=255) String> var2, Class<R> var3) throws NotFoundException;

    public <R extends CommonResource> void removeAllTagsForResource(@NotBlank String var1, Class<R> var2) throws NotFoundException;

    public <R extends CommonResource> void removeTagForResource(@NotBlank String var1, @NotBlank String var2, Class<R> var3) throws NotFoundException;

    public long deleteUnusedTags(@NotNull Instant var1, @Min(value=1L) @Min(value=1L) int var2);

    public long deleteUnusedFiles(@NotNull Instant var1, @Min(value=1L) @Min(value=1L) int var2);
}

