/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa;

import brave.SpanCustomizer;
import brave.Tracer;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.netflix.genie.common.dto.Job;
import com.netflix.genie.common.dto.JobExecution;
import com.netflix.genie.common.dto.JobMetadata;
import com.netflix.genie.common.dto.JobRequest;
import com.netflix.genie.common.dto.JobStatus;
import com.netflix.genie.common.dto.UserResourcesSummary;
import com.netflix.genie.common.dto.search.JobSearchResult;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieNotFoundException;
import com.netflix.genie.common.external.dtos.v4.AgentClientMetadata;
import com.netflix.genie.common.external.dtos.v4.AgentConfigRequest;
import com.netflix.genie.common.external.dtos.v4.Application;
import com.netflix.genie.common.external.dtos.v4.ApplicationMetadata;
import com.netflix.genie.common.external.dtos.v4.ApplicationRequest;
import com.netflix.genie.common.external.dtos.v4.ApplicationStatus;
import com.netflix.genie.common.external.dtos.v4.ArchiveStatus;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.ClusterMetadata;
import com.netflix.genie.common.external.dtos.v4.ClusterRequest;
import com.netflix.genie.common.external.dtos.v4.ClusterStatus;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.common.external.dtos.v4.CommandMetadata;
import com.netflix.genie.common.external.dtos.v4.CommandRequest;
import com.netflix.genie.common.external.dtos.v4.CommandStatus;
import com.netflix.genie.common.external.dtos.v4.CommonMetadata;
import com.netflix.genie.common.external.dtos.v4.CommonResource;
import com.netflix.genie.common.external.dtos.v4.Criterion;
import com.netflix.genie.common.external.dtos.v4.ExecutionEnvironment;
import com.netflix.genie.common.external.dtos.v4.ExecutionResourceCriteria;
import com.netflix.genie.common.external.dtos.v4.JobEnvironment;
import com.netflix.genie.common.external.dtos.v4.JobEnvironmentRequest;
import com.netflix.genie.common.external.dtos.v4.JobRequestMetadata;
import com.netflix.genie.common.external.dtos.v4.JobSpecification;
import com.netflix.genie.common.internal.dtos.v4.FinishedJob;
import com.netflix.genie.common.internal.dtos.v4.converters.DtoConverters;
import com.netflix.genie.common.internal.exceptions.checked.GenieCheckedException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieInvalidStatusException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieJobAlreadyClaimedException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.common.internal.tracing.brave.BraveTagAdapter;
import com.netflix.genie.common.internal.tracing.brave.BraveTracingComponents;
import com.netflix.genie.web.data.services.PersistenceService;
import com.netflix.genie.web.data.services.impl.jpa.converters.EntityV3DtoConverters;
import com.netflix.genie.web.data.services.impl.jpa.converters.EntityV4DtoConverters;
import com.netflix.genie.web.data.services.impl.jpa.entities.ApplicationEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.ApplicationEntity_;
import com.netflix.genie.web.data.services.impl.jpa.entities.BaseEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.ClusterEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.ClusterEntity_;
import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity_;
import com.netflix.genie.web.data.services.impl.jpa.entities.CriterionEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.FileEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.JobEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.JobEntity_;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.UniqueIdEntity;
import com.netflix.genie.web.data.services.impl.jpa.queries.aggregates.JobInfoAggregate;
import com.netflix.genie.web.data.services.impl.jpa.queries.predicates.ApplicationPredicates;
import com.netflix.genie.web.data.services.impl.jpa.queries.predicates.ClusterPredicates;
import com.netflix.genie.web.data.services.impl.jpa.queries.predicates.CommandPredicates;
import com.netflix.genie.web.data.services.impl.jpa.queries.predicates.JobPredicates;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobExecutionProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.JobMetadataProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.FinishedJobProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.JobSpecificationProjection;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaApplicationRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaBaseRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaClusterRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaCommandRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaCriterionRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaFileRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaJobRepository;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaRepositories;
import com.netflix.genie.web.data.services.impl.jpa.repositories.JpaTagRepository;
import com.netflix.genie.web.dtos.JobSubmission;
import com.netflix.genie.web.dtos.ResolvedJob;
import com.netflix.genie.web.exceptions.checked.IdAlreadyExistsException;
import com.netflix.genie.web.exceptions.checked.NotFoundException;
import com.netflix.genie.web.exceptions.checked.PreconditionFailedException;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.net.URI;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.EntityManager;
import javax.persistence.NoResultException;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.validation.ConstraintViolationException;
import javax.validation.Valid;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.DataIntegrityViolationException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.transaction.annotation.Isolation;
import org.springframework.transaction.annotation.Transactional;

@Transactional(rollbackFor={GenieException.class, GenieCheckedException.class, GenieRuntimeException.class, ConstraintViolationException.class})
public class JpaPersistenceServiceImpl
implements PersistenceService {
    private static final Logger log = LoggerFactory.getLogger(JpaPersistenceServiceImpl.class);
    @VisibleForTesting
    static final Set<String> ACTIVE_STATUS_SET = com.netflix.genie.common.external.dtos.v4.JobStatus.getActiveStatuses().stream().map(Enum::name).collect(Collectors.toSet());
    @VisibleForTesting
    static final Set<String> UNCLAIMED_STATUS_SET = com.netflix.genie.common.external.dtos.v4.JobStatus.getStatusesBeforeClaimed().stream().map(Enum::name).collect(Collectors.toSet());
    @VisibleForTesting
    static final Set<String> USING_MEMORY_JOB_SET = Stream.of(com.netflix.genie.common.external.dtos.v4.JobStatus.CLAIMED, com.netflix.genie.common.external.dtos.v4.JobStatus.INIT, com.netflix.genie.common.external.dtos.v4.JobStatus.RUNNING).map(Enum::name).collect(Collectors.toSet());
    private static final String LOAD_GRAPH_HINT = "javax.persistence.loadgraph";
    private static final int MAX_STATUS_MESSAGE_LENGTH = 255;
    private final EntityManager entityManager;
    private final JpaApplicationRepository applicationRepository;
    private final JpaClusterRepository clusterRepository;
    private final JpaCommandRepository commandRepository;
    private final JpaCriterionRepository criterionRepository;
    private final JpaFileRepository fileRepository;
    private final JpaJobRepository jobRepository;
    private final JpaTagRepository tagRepository;
    private final Tracer tracer;
    private final BraveTagAdapter tagAdapter;

    public JpaPersistenceServiceImpl(EntityManager entityManager, JpaRepositories jpaRepositories, BraveTracingComponents tracingComponents) {
        this.entityManager = entityManager;
        this.applicationRepository = jpaRepositories.getApplicationRepository();
        this.clusterRepository = jpaRepositories.getClusterRepository();
        this.commandRepository = jpaRepositories.getCommandRepository();
        this.criterionRepository = jpaRepositories.getCriterionRepository();
        this.fileRepository = jpaRepositories.getFileRepository();
        this.jobRepository = jpaRepositories.getJobRepository();
        this.tagRepository = jpaRepositories.getTagRepository();
        this.tracer = tracingComponents.getTracer();
        this.tagAdapter = tracingComponents.getTagAdapter();
    }

    @Override
    public String saveApplication(@Valid ApplicationRequest applicationRequest) throws IdAlreadyExistsException {
        log.debug("[saveApplication] Called to save {}", (Object)applicationRequest);
        ApplicationEntity entity = new ApplicationEntity();
        this.setUniqueId(entity, applicationRequest.getRequestedId().orElse(null));
        this.updateApplicationEntity(entity, applicationRequest.getResources(), applicationRequest.getMetadata());
        try {
            return ((ApplicationEntity)this.applicationRepository.save(entity)).getUniqueId();
        }
        catch (DataIntegrityViolationException e) {
            throw new IdAlreadyExistsException("An application with id " + entity.getUniqueId() + " already exists", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Application getApplication(@NotBlank String id) throws NotFoundException {
        log.debug("[getApplication] Called for {}", (Object)id);
        return EntityV4DtoConverters.toV4ApplicationDto(this.applicationRepository.getApplicationDto(id).orElseThrow(() -> new NotFoundException("No application with id " + id + " exists")));
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Application> findApplications(@Nullable String name, @Nullable String user, @Nullable Set<ApplicationStatus> statuses, @Nullable Set<String> tags, @Nullable String type, Pageable page) {
        Set<TagEntity> tagEntities;
        log.debug("[findApplications] Called with name = {}, user = {}, statuses = {}, tags = {}, type = {}", new Object[]{name, user, statuses, tags, type});
        Set<String> statusStrings = statuses != null ? statuses.stream().map(Enum::name).collect(Collectors.toSet()) : null;
        Set<TagEntity> set = tagEntities = tags == null ? null : this.tagRepository.findByTagIn(tags);
        if (tagEntities != null && tagEntities.size() != tags.size()) {
            return new PageImpl(new ArrayList(0));
        }
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        Root countQueryRoot = countQuery.from(ApplicationEntity.class);
        countQuery.select((Selection)criteriaBuilder.count((Expression)countQueryRoot));
        countQuery.where((Expression)ApplicationPredicates.find((Root<ApplicationEntity>)countQueryRoot, countQuery, criteriaBuilder, name, user, statusStrings, tagEntities, type));
        List applicationsCount = this.entityManager.createQuery(countQuery).getResultList();
        if (applicationsCount.isEmpty()) {
            return new PageImpl(new ArrayList(0));
        }
        Long totalCount = (Long)applicationsCount.get(0);
        if (totalCount == 0L) {
            return new PageImpl(new ArrayList(0));
        }
        CriteriaQuery idQuery = criteriaBuilder.createQuery(Long.class);
        Root idQueryRoot = idQuery.from(ApplicationEntity.class);
        idQuery.select((Selection)idQueryRoot.get(ApplicationEntity_.id));
        idQuery.where((Expression)ApplicationPredicates.find((Root<ApplicationEntity>)idQueryRoot, idQuery, criteriaBuilder, name, user, statusStrings, tagEntities, type));
        Sort sort = page.getSort();
        ArrayList orders = new ArrayList();
        sort.iterator().forEachRemaining(order -> {
            if (order.isAscending()) {
                orders.add(criteriaBuilder.asc((Expression)idQueryRoot.get(order.getProperty())));
            } else {
                orders.add(criteriaBuilder.desc((Expression)idQueryRoot.get(order.getProperty())));
            }
        });
        idQuery.orderBy(orders);
        List applicationIds = this.entityManager.createQuery(idQuery).setFirstResult(Long.valueOf(page.getOffset()).intValue()).setMaxResults(page.getPageSize()).getResultList();
        CriteriaQuery contentQuery = criteriaBuilder.createQuery(ApplicationEntity.class);
        Root contentQueryRoot = contentQuery.from(ApplicationEntity.class);
        contentQuery.select((Selection)contentQueryRoot);
        contentQuery.where((Expression)contentQueryRoot.get(ApplicationEntity_.id).in((Collection)applicationIds));
        contentQuery.orderBy(orders);
        List applications = this.entityManager.createQuery(contentQuery).setHint(LOAD_GRAPH_HINT, (Object)this.entityManager.getEntityGraph("Application.dto")).getResultStream().map(EntityV4DtoConverters::toV4ApplicationDto).collect(Collectors.toList());
        return new PageImpl(applications, page, totalCount.longValue());
    }

    @Override
    public void updateApplication(@NotBlank String id, @Valid Application updateApp) throws NotFoundException, PreconditionFailedException {
        log.debug("[updateApplication] Called to update application {} with {}", (Object)id, (Object)updateApp);
        if (!updateApp.getId().equals(id)) {
            throw new PreconditionFailedException("Application id " + id + " inconsistent with id passed in.");
        }
        this.updateApplicationEntity(this.applicationRepository.getApplicationDto(id).orElseThrow(() -> new NotFoundException("No application with id " + id + " exists")), updateApp.getResources(), updateApp.getMetadata());
    }

    @Override
    public void deleteAllApplications() throws PreconditionFailedException {
        log.debug("[deleteAllApplications] Called");
        for (ApplicationEntity entity : this.applicationRepository.findAll()) {
            this.deleteApplicationEntity(entity);
        }
    }

    @Override
    public void deleteApplication(@NotBlank String id) throws PreconditionFailedException {
        log.debug("[deleteApplication] Called for {}", (Object)id);
        Optional<ApplicationEntity> entity = this.applicationRepository.getApplicationAndCommands(id);
        if (!entity.isPresent()) {
            return;
        }
        this.deleteApplicationEntity(entity.get());
    }

    @Override
    @Transactional(readOnly=true)
    public Set<Command> getCommandsForApplication(@NotBlank String id, @Nullable Set<CommandStatus> statuses) throws NotFoundException {
        log.debug("[getCommandsForApplication] Called for application {} filtered by statuses {}", (Object)id, statuses);
        return this.applicationRepository.getApplicationAndCommandsDto(id).orElseThrow(() -> new NotFoundException("No application with id " + id + " exists")).getCommands().stream().filter(commandEntity -> statuses == null || statuses.contains(DtoConverters.toV4CommandStatus((String)commandEntity.getStatus()))).map(EntityV4DtoConverters::toV4CommandDto).collect(Collectors.toSet());
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public long deleteUnusedApplications(Instant createdThreshold, int batchSize) {
        log.info("Attempting to delete unused applications created before {}", (Object)createdThreshold);
        return this.applicationRepository.deleteByIdIn(this.applicationRepository.findUnusedApplications(createdThreshold, batchSize));
    }

    @Override
    public String saveCluster(@Valid ClusterRequest clusterRequest) throws IdAlreadyExistsException {
        log.debug("[saveCluster] Called to save {}", (Object)clusterRequest);
        ClusterEntity entity = new ClusterEntity();
        this.setUniqueId(entity, clusterRequest.getRequestedId().orElse(null));
        this.updateClusterEntity(entity, clusterRequest.getResources(), clusterRequest.getMetadata());
        try {
            return ((ClusterEntity)this.clusterRepository.save(entity)).getUniqueId();
        }
        catch (DataIntegrityViolationException e) {
            throw new IdAlreadyExistsException("A cluster with id " + entity.getUniqueId() + " already exists", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Cluster getCluster(@NotBlank String id) throws NotFoundException {
        log.debug("[getCluster] Called for {}", (Object)id);
        return EntityV4DtoConverters.toV4ClusterDto(this.clusterRepository.getClusterDto(id).orElseThrow(() -> new NotFoundException("No cluster with id " + id + " exists")));
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Cluster> findClusters(@Nullable String name, @Nullable Set<ClusterStatus> statuses, @Nullable Set<String> tags, @Nullable Instant minUpdateTime, @Nullable Instant maxUpdateTime, Pageable page) {
        Set<TagEntity> tagEntities;
        log.debug("[findClusters] Called with name = {}, statuses = {}, tags = {}, minUpdateTime = {}, maxUpdateTime = {}", new Object[]{name, statuses, tags, minUpdateTime, maxUpdateTime});
        Set<String> statusStrings = statuses != null ? statuses.stream().map(Enum::name).collect(Collectors.toSet()) : null;
        Set<TagEntity> set = tagEntities = tags == null ? null : this.tagRepository.findByTagIn(tags);
        if (tagEntities != null && tagEntities.size() != tags.size()) {
            return new PageImpl(new ArrayList(0));
        }
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        Root countQueryRoot = countQuery.from(ClusterEntity.class);
        countQuery.select((Selection)criteriaBuilder.count((Expression)countQueryRoot));
        countQuery.where((Expression)ClusterPredicates.find((Root<ClusterEntity>)countQueryRoot, countQuery, criteriaBuilder, name, statusStrings, tagEntities, minUpdateTime, maxUpdateTime));
        List clustersCount = this.entityManager.createQuery(countQuery).getResultList();
        if (clustersCount.isEmpty()) {
            return new PageImpl(new ArrayList(0));
        }
        Long totalCount = (Long)clustersCount.get(0);
        if (totalCount == 0L) {
            return new PageImpl(new ArrayList(0));
        }
        CriteriaQuery idQuery = criteriaBuilder.createQuery(Long.class);
        Root idQueryRoot = idQuery.from(ClusterEntity.class);
        idQuery.select((Selection)idQueryRoot.get(ClusterEntity_.id));
        idQuery.where((Expression)ClusterPredicates.find((Root<ClusterEntity>)idQueryRoot, idQuery, criteriaBuilder, name, statusStrings, tagEntities, minUpdateTime, maxUpdateTime));
        Sort sort = page.getSort();
        ArrayList orders = new ArrayList();
        sort.iterator().forEachRemaining(order -> {
            if (order.isAscending()) {
                orders.add(criteriaBuilder.asc((Expression)idQueryRoot.get(order.getProperty())));
            } else {
                orders.add(criteriaBuilder.desc((Expression)idQueryRoot.get(order.getProperty())));
            }
        });
        idQuery.orderBy(orders);
        List clusterIds = this.entityManager.createQuery(idQuery).setFirstResult(Long.valueOf(page.getOffset()).intValue()).setMaxResults(page.getPageSize()).getResultList();
        CriteriaQuery contentQuery = criteriaBuilder.createQuery(ClusterEntity.class);
        Root contentQueryRoot = contentQuery.from(ClusterEntity.class);
        contentQuery.select((Selection)contentQueryRoot);
        contentQuery.where((Expression)contentQueryRoot.get(ClusterEntity_.id).in((Collection)clusterIds));
        contentQuery.orderBy(orders);
        List clusters = this.entityManager.createQuery(contentQuery).setHint(LOAD_GRAPH_HINT, (Object)this.entityManager.getEntityGraph("Cluster.dto")).getResultStream().map(EntityV4DtoConverters::toV4ClusterDto).collect(Collectors.toList());
        return new PageImpl(clusters, page, totalCount.longValue());
    }

    @Override
    public void updateCluster(@NotBlank String id, @Valid Cluster updateCluster) throws NotFoundException, PreconditionFailedException {
        log.debug("[updateCluster] Called to update cluster {} with {}", (Object)id, (Object)updateCluster);
        if (!updateCluster.getId().equals(id)) {
            throw new PreconditionFailedException("Application id " + id + " inconsistent with id passed in.");
        }
        this.updateClusterEntity(this.clusterRepository.getClusterDto(id).orElseThrow(() -> new NotFoundException("No cluster with id " + id + " exists")), updateCluster.getResources(), updateCluster.getMetadata());
    }

    @Override
    public void deleteAllClusters() throws PreconditionFailedException {
        log.debug("[deleteAllClusters] Called");
        for (ClusterEntity entity : this.clusterRepository.findAll()) {
            this.deleteClusterEntity(entity);
        }
    }

    @Override
    public void deleteCluster(@NotBlank String id) throws PreconditionFailedException {
        log.debug("[deleteCluster] Called for {}", (Object)id);
        Optional entity = this.clusterRepository.findByUniqueId(id);
        if (!entity.isPresent()) {
            return;
        }
        this.deleteClusterEntity((ClusterEntity)entity.get());
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public long deleteUnusedClusters(Set<ClusterStatus> deleteStatuses, Instant clusterCreatedThreshold, int batchSize) {
        log.info("[deleteUnusedClusters] Deleting with statuses {} that were created before {}", deleteStatuses, (Object)clusterCreatedThreshold);
        return this.clusterRepository.deleteByIdIn(this.clusterRepository.findUnusedClusters(deleteStatuses.stream().map(Enum::name).collect(Collectors.toSet()), clusterCreatedThreshold, batchSize));
    }

    @Override
    public Set<Cluster> findClustersMatchingCriterion(@Valid Criterion criterion, boolean addDefaultStatus) {
        Criterion finalCriterion = addDefaultStatus && !criterion.getStatus().isPresent() ? new Criterion(criterion, ClusterStatus.UP.name()) : criterion;
        log.debug("[findClustersMatchingCriterion] Called to find clusters matching {}", (Object)finalCriterion);
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(ClusterEntity.class);
        Root queryRoot = criteriaQuery.from(ClusterEntity.class);
        criteriaQuery.where((Expression)ClusterPredicates.findClustersMatchingCriterion((Root<ClusterEntity>)queryRoot, criteriaQuery, criteriaBuilder, finalCriterion));
        return this.entityManager.createQuery(criteriaQuery).setHint(LOAD_GRAPH_HINT, (Object)this.entityManager.getEntityGraph("Cluster.dto")).getResultStream().map(EntityV4DtoConverters::toV4ClusterDto).collect(Collectors.toSet());
    }

    @Override
    public Set<Cluster> findClustersMatchingAnyCriterion(@NotEmpty Set<@Valid Criterion> criteria, boolean addDefaultStatus) {
        ImmutableSet finalCriteria;
        if (addDefaultStatus) {
            String defaultStatus = ClusterStatus.UP.name();
            ImmutableSet.Builder criteriaBuilder = ImmutableSet.builder();
            for (Criterion criterion : criteria) {
                if (criterion.getStatus().isPresent()) {
                    criteriaBuilder.add((Object)criterion);
                    continue;
                }
                criteriaBuilder.add((Object)new Criterion(criterion, defaultStatus));
            }
            finalCriteria = criteriaBuilder.build();
        } else {
            finalCriteria = criteria;
        }
        log.debug("[findClustersMatchingAnyCriterion] Called to find clusters matching any of {}", finalCriteria);
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(ClusterEntity.class);
        Root queryRoot = criteriaQuery.from(ClusterEntity.class);
        criteriaQuery.where((Expression)ClusterPredicates.findClustersMatchingAnyCriterion((Root<ClusterEntity>)queryRoot, criteriaQuery, criteriaBuilder, (Set<Criterion>)finalCriteria));
        return this.entityManager.createQuery(criteriaQuery).setHint(LOAD_GRAPH_HINT, (Object)this.entityManager.getEntityGraph("Cluster.dto")).getResultStream().map(EntityV4DtoConverters::toV4ClusterDto).collect(Collectors.toSet());
    }

    @Override
    public String saveCommand(@Valid CommandRequest commandRequest) throws IdAlreadyExistsException {
        log.debug("[saveCommand] Called to save {}", (Object)commandRequest);
        CommandEntity entity = new CommandEntity();
        this.setUniqueId(entity, commandRequest.getRequestedId().orElse(null));
        this.updateCommandEntity(entity, commandRequest.getResources(), commandRequest.getMetadata(), commandRequest.getCheckDelay().orElse(10000L), commandRequest.getExecutable(), commandRequest.getMemory().orElse(null), commandRequest.getClusterCriteria());
        try {
            return ((CommandEntity)this.commandRepository.save(entity)).getUniqueId();
        }
        catch (DataIntegrityViolationException e) {
            throw new IdAlreadyExistsException("A command with id " + entity.getUniqueId() + " already exists", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Command getCommand(@NotBlank String id) throws NotFoundException {
        log.debug("[getCommand] Called for {}", (Object)id);
        return EntityV4DtoConverters.toV4CommandDto(this.commandRepository.getCommandDto(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists")));
    }

    @Override
    @Transactional(readOnly=true)
    public Page<Command> findCommands(@Nullable String name, @Nullable String user, @Nullable Set<CommandStatus> statuses, @Nullable Set<String> tags, Pageable page) {
        Set<TagEntity> tagEntities;
        log.debug("[findCommands] Called with name = {}, user = {}, statuses = {}, tags = {}", new Object[]{name, user, statuses, tags});
        Set<String> statusStrings = statuses != null ? statuses.stream().map(Enum::name).collect(Collectors.toSet()) : null;
        Set<TagEntity> set = tagEntities = tags == null ? null : this.tagRepository.findByTagIn(tags);
        if (tagEntities != null && tagEntities.size() != tags.size()) {
            return new PageImpl(new ArrayList(0));
        }
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        Root countQueryRoot = countQuery.from(CommandEntity.class);
        countQuery.select((Selection)criteriaBuilder.count((Expression)countQueryRoot));
        countQuery.where((Expression)CommandPredicates.find((Root<CommandEntity>)countQueryRoot, countQuery, criteriaBuilder, name, user, statusStrings, tagEntities));
        List commandsCount = this.entityManager.createQuery(countQuery).getResultList();
        if (commandsCount.isEmpty()) {
            return new PageImpl(new ArrayList(0));
        }
        Long totalCount = (Long)commandsCount.get(0);
        if (totalCount == 0L) {
            return new PageImpl(new ArrayList(0));
        }
        CriteriaQuery idQuery = criteriaBuilder.createQuery(Long.class);
        Root idQueryRoot = idQuery.from(CommandEntity.class);
        idQuery.select((Selection)idQueryRoot.get(CommandEntity_.id));
        idQuery.where((Expression)CommandPredicates.find((Root<CommandEntity>)idQueryRoot, idQuery, criteriaBuilder, name, user, statusStrings, tagEntities));
        Sort sort = page.getSort();
        ArrayList orders = new ArrayList();
        sort.iterator().forEachRemaining(order -> {
            if (order.isAscending()) {
                orders.add(criteriaBuilder.asc((Expression)idQueryRoot.get(order.getProperty())));
            } else {
                orders.add(criteriaBuilder.desc((Expression)idQueryRoot.get(order.getProperty())));
            }
        });
        idQuery.orderBy(orders);
        List commandIds = this.entityManager.createQuery(idQuery).setFirstResult(Long.valueOf(page.getOffset()).intValue()).setMaxResults(page.getPageSize()).getResultList();
        CriteriaQuery contentQuery = criteriaBuilder.createQuery(CommandEntity.class);
        Root contentQueryRoot = contentQuery.from(CommandEntity.class);
        contentQuery.select((Selection)contentQueryRoot);
        contentQuery.where((Expression)contentQueryRoot.get(CommandEntity_.id).in((Collection)commandIds));
        contentQuery.orderBy(orders);
        List commands = this.entityManager.createQuery(contentQuery).setHint(LOAD_GRAPH_HINT, (Object)this.entityManager.getEntityGraph("Command.DTO")).getResultStream().map(EntityV4DtoConverters::toV4CommandDto).collect(Collectors.toList());
        return new PageImpl(commands, page, totalCount.longValue());
    }

    @Override
    public void updateCommand(@NotBlank String id, @Valid Command updateCommand) throws NotFoundException, PreconditionFailedException {
        log.debug("[updateCommand] Called to update command {} with {}", (Object)id, (Object)updateCommand);
        if (!updateCommand.getId().equals(id)) {
            throw new PreconditionFailedException("Command id " + id + " inconsistent with id passed in.");
        }
        this.updateCommandEntity(this.commandRepository.getCommandDto(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists")), updateCommand.getResources(), updateCommand.getMetadata(), updateCommand.getCheckDelay(), updateCommand.getExecutable(), updateCommand.getMemory().orElse(null), updateCommand.getClusterCriteria());
    }

    @Override
    public void deleteAllCommands() throws PreconditionFailedException {
        log.debug("[deleteAllCommands] Called");
        this.commandRepository.findAll().forEach(this::deleteCommandEntity);
    }

    @Override
    public void deleteCommand(@NotBlank String id) throws NotFoundException {
        log.debug("[deleteCommand] Called to delete command with id {}", (Object)id);
        this.deleteCommandEntity(this.commandRepository.getCommandAndApplications(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists")));
    }

    @Override
    public void addApplicationsForCommand(@NotBlank String id, @NotEmpty List<@NotBlank String> applicationIds) throws NotFoundException, PreconditionFailedException {
        log.debug("[addApplicationsForCommand] Called to add {} to {}", applicationIds, (Object)id);
        CommandEntity commandEntity = this.commandRepository.getCommandAndApplications(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists"));
        for (String applicationId : applicationIds) {
            commandEntity.addApplication(this.applicationRepository.getApplicationAndCommands(applicationId).orElseThrow(() -> new NotFoundException("No application with id " + applicationId + " exists")));
        }
    }

    @Override
    public void setApplicationsForCommand(@NotBlank String id, @NotNull List<@NotBlank String> applicationIds) throws NotFoundException, PreconditionFailedException {
        log.debug("[setApplicationsForCommand] Called to set {} for {}", applicationIds, (Object)id);
        if (Sets.newHashSet(applicationIds).size() != applicationIds.size()) {
            throw new PreconditionFailedException("Duplicate application id in " + applicationIds);
        }
        CommandEntity commandEntity = this.commandRepository.getCommandAndApplications(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists"));
        ArrayList applicationEntities = Lists.newArrayList();
        for (String applicationId : applicationIds) {
            applicationEntities.add(this.applicationRepository.getApplicationAndCommands(applicationId).orElseThrow(() -> new NotFoundException("No application with id " + applicationId + " exists")));
        }
        commandEntity.setApplications(applicationEntities);
    }

    @Override
    @Transactional(readOnly=true)
    public List<Application> getApplicationsForCommand(String id) throws NotFoundException {
        log.debug("[getApplicationsForCommand] Called for {}", (Object)id);
        return this.commandRepository.getCommandAndApplicationsDto(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists")).getApplications().stream().map(EntityV4DtoConverters::toV4ApplicationDto).collect(Collectors.toList());
    }

    @Override
    public void removeApplicationsForCommand(@NotBlank String id) throws NotFoundException, PreconditionFailedException {
        log.debug("[removeApplicationsForCommand] Called to for {}", (Object)id);
        this.commandRepository.getCommandAndApplications(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists")).setApplications(null);
    }

    @Override
    public void removeApplicationForCommand(@NotBlank String id, @NotBlank String appId) throws NotFoundException {
        log.debug("[removeApplicationForCommand] Called to for {} from {}", (Object)appId, (Object)id);
        this.commandRepository.getCommandAndApplications(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists")).removeApplication(this.applicationRepository.getApplicationAndCommands(appId).orElseThrow(() -> new NotFoundException("No application with id " + appId + " exists")));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<Cluster> getClustersForCommand(@NotBlank String id, @Nullable Set<ClusterStatus> statuses) throws NotFoundException {
        log.debug("[getClustersForCommand] Called for {} with statuses {}", (Object)id, statuses);
        List<Criterion> clusterCriteria = this.getClusterCriteriaForCommand(id);
        return this.findClustersMatchingAnyCriterion(Sets.newHashSet(clusterCriteria), false).stream().filter(cluster -> statuses == null || statuses.contains(cluster.getMetadata().getStatus())).collect(Collectors.toSet());
    }

    @Override
    @Transactional(readOnly=true)
    public List<Criterion> getClusterCriteriaForCommand(String id) throws NotFoundException {
        log.debug("[getClusterCriteriaForCommand] Called to get cluster criteria for command {}", (Object)id);
        return this.commandRepository.getCommandAndClusterCriteria(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists")).getClusterCriteria().stream().map(EntityV4DtoConverters::toCriterionDto).collect(Collectors.toList());
    }

    @Override
    public void addClusterCriterionForCommand(String id, @Valid Criterion criterion) throws NotFoundException {
        log.debug("[addClusterCriterionForCommand] Called to add cluster criteria {} for command {}", (Object)criterion, (Object)id);
        this.commandRepository.getCommandAndClusterCriteria(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists")).addClusterCriterion(this.toCriterionEntity(criterion));
    }

    @Override
    public void addClusterCriterionForCommand(String id, @Valid Criterion criterion, @Min(value=0L) @Min(value=0L) int priority) throws NotFoundException {
        log.debug("[addClusterCriterionForCommand] Called to add cluster criteria {} for command {} at priority {}", new Object[]{criterion, id, priority});
        this.commandRepository.getCommandAndClusterCriteria(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists")).addClusterCriterion(this.toCriterionEntity(criterion), priority);
    }

    @Override
    public void setClusterCriteriaForCommand(String id, List<@Valid Criterion> clusterCriteria) throws NotFoundException {
        log.debug("[setClusterCriteriaForCommand] Called to set cluster criteria {} for command {}", clusterCriteria, (Object)id);
        CommandEntity commandEntity = this.commandRepository.getCommandAndClusterCriteria(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists"));
        this.updateClusterCriteria(commandEntity, clusterCriteria);
    }

    @Override
    public void removeClusterCriterionForCommand(String id, @Min(value=0L) @Min(value=0L) int priority) throws NotFoundException {
        log.debug("[removeClusterCriterionForCommand] Called to remove cluster criterion with priority {} from command {}", (Object)priority, (Object)id);
        CommandEntity commandEntity = this.commandRepository.getCommandAndClusterCriteria(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists"));
        if (priority >= commandEntity.getClusterCriteria().size()) {
            throw new NotFoundException("No criterion with priority " + priority + " exists for command " + id + ". Unable to remove.");
        }
        try {
            CriterionEntity criterionEntity = commandEntity.removeClusterCriterion(priority);
            log.debug("Successfully removed cluster criterion {} from command {}", (Object)criterionEntity, (Object)id);
            this.criterionRepository.delete(criterionEntity);
        }
        catch (IllegalArgumentException e) {
            log.error("Failed to remove cluster criterion with priority {} from command {}", new Object[]{priority, id, e});
        }
    }

    @Override
    public void removeAllClusterCriteriaForCommand(String id) throws NotFoundException {
        log.debug("[removeAllClusterCriteriaForCommand] Called to remove all cluster criteria from command {}", (Object)id);
        this.deleteAllClusterCriteria(this.commandRepository.getCommandAndClusterCriteria(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists")));
    }

    @Override
    @Transactional(readOnly=true)
    public Set<Command> findCommandsMatchingCriterion(@Valid Criterion criterion, boolean addDefaultStatus) {
        Criterion finalCriterion = addDefaultStatus && !criterion.getStatus().isPresent() ? new Criterion(criterion, CommandStatus.ACTIVE.name()) : criterion;
        log.debug("[findCommandsMatchingCriterion] Called to find commands matching {}", (Object)finalCriterion);
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(CommandEntity.class);
        Root queryRoot = criteriaQuery.from(CommandEntity.class);
        criteriaQuery.where((Expression)CommandPredicates.findCommandsMatchingCriterion((Root<CommandEntity>)queryRoot, criteriaQuery, criteriaBuilder, finalCriterion));
        return this.entityManager.createQuery(criteriaQuery).setHint(LOAD_GRAPH_HINT, (Object)this.entityManager.getEntityGraph("Command.DTO")).getResultStream().map(EntityV4DtoConverters::toV4CommandDto).collect(Collectors.toSet());
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public int updateStatusForUnusedCommands(CommandStatus desiredStatus, Instant commandCreatedThreshold, Set<CommandStatus> currentStatuses, int batchSize) {
        log.info("Attempting to update at most {} commands with statuses {} which were created before {} and haven't been used in jobs to new status {}", new Object[]{batchSize, currentStatuses, commandCreatedThreshold, desiredStatus});
        int updateCount = this.commandRepository.setStatusWhereIdIn(desiredStatus.name(), this.commandRepository.findUnusedCommandsByStatusesCreatedBefore(currentStatuses.stream().map(Enum::name).collect(Collectors.toSet()), commandCreatedThreshold, batchSize));
        log.info("Updated {} commands with statuses {} which were created before {} and haven't been used in any jobs to new status {}", new Object[]{updateCount, currentStatuses, commandCreatedThreshold, desiredStatus});
        return updateCount;
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public long deleteUnusedCommands(Set<CommandStatus> deleteStatuses, Instant commandCreatedThreshold, int batchSize) {
        log.info("Deleting commands with statuses {} that were created before {}", deleteStatuses, (Object)commandCreatedThreshold);
        return this.commandRepository.deleteByIdIn(this.commandRepository.findUnusedCommandsByStatusesCreatedBefore(deleteStatuses.stream().map(Enum::name).collect(Collectors.toSet()), commandCreatedThreshold, batchSize));
    }

    @Override
    @Transactional(readOnly=true)
    @Deprecated
    public JobRequest getV3JobRequest(@NotBlank String id) throws GenieException {
        log.debug("[getV3JobRequest] Called with id {}", (Object)id);
        return EntityV3DtoConverters.toJobRequestDto(this.jobRepository.getV3JobRequest(id).orElseThrow(() -> new GenieNotFoundException("No job request with id " + id)));
    }

    @Override
    @Transactional(readOnly=true)
    public Job getJob(@NotBlank String id) throws GenieException {
        log.debug("[getJob] Called with id {}", (Object)id);
        return EntityV3DtoConverters.toJobDto(this.jobRepository.getV3Job(id).orElseThrow(() -> new GenieNotFoundException("No job with id " + id)));
    }

    @Override
    @Transactional(readOnly=true)
    public JobExecution getJobExecution(@NotBlank String id) throws GenieException {
        log.debug("[getJobExecution] Called with id {}", (Object)id);
        return EntityV3DtoConverters.toJobExecutionDto(this.jobRepository.findByUniqueId(id, JobExecutionProjection.class).orElseThrow(() -> new GenieNotFoundException("No job with id " + id)));
    }

    @Override
    @Transactional(readOnly=true)
    public JobMetadata getJobMetadata(@NotBlank String id) throws GenieException {
        log.debug("[getJobMetadata] Called with id {}", (Object)id);
        return EntityV3DtoConverters.toJobMetadataDto(this.jobRepository.findByUniqueId(id, JobMetadataProjection.class).orElseThrow(() -> new GenieNotFoundException("No job found for id " + id)));
    }

    @Override
    @Transactional(readOnly=true)
    public Page<JobSearchResult> findJobs(@Nullable String id, @Nullable String name, @Nullable String user, @Nullable Set<JobStatus> statuses, @Nullable Set<String> tags, @Nullable String clusterName, @Nullable String clusterId, @Nullable String commandName, @Nullable String commandId, @Nullable Instant minStarted, @Nullable Instant maxStarted, @Nullable Instant minFinished, @Nullable Instant maxFinished, @Nullable String grouping, @Nullable String groupingInstance, @NotNull Pageable page) {
        log.debug("[findJobs] Called");
        ClusterEntity clusterEntity = null;
        if (clusterId != null) {
            Optional<ClusterEntity> optionalClusterEntity = this.getEntityOrNullForFindJobs(this.clusterRepository, clusterId, clusterName);
            if (optionalClusterEntity.isPresent()) {
                clusterEntity = optionalClusterEntity.get();
            } else {
                return new PageImpl((List)Lists.newArrayList(), page, 0L);
            }
        }
        CommandEntity commandEntity = null;
        if (commandId != null) {
            Optional<CommandEntity> optionalCommandEntity = this.getEntityOrNullForFindJobs(this.commandRepository, commandId, commandName);
            if (optionalCommandEntity.isPresent()) {
                commandEntity = optionalCommandEntity.get();
            } else {
                return new PageImpl((List)Lists.newArrayList(), page, 0L);
            }
        }
        Set<String> statusStrings = statuses != null ? statuses.stream().map(Enum::name).collect(Collectors.toSet()) : null;
        CriteriaBuilder cb = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = cb.createQuery(Long.class);
        Root root = countQuery.from(JobEntity.class);
        countQuery.select((Selection)cb.count((Expression)root)).where((Expression)JobPredicates.getFindPredicate((Root<JobEntity>)root, cb, id, name, user, statusStrings, tags, clusterName, clusterEntity, commandName, commandEntity, minStarted, maxStarted, minFinished, maxFinished, grouping, groupingInstance));
        long totalCount = (Long)this.entityManager.createQuery(countQuery).getSingleResult();
        if (totalCount == 0L) {
            return new PageImpl(new ArrayList(0));
        }
        CriteriaQuery contentQuery = cb.createQuery(JobSearchResult.class);
        Root contentQueryRoot = contentQuery.from(JobEntity.class);
        contentQuery.multiselect(new Selection[]{contentQueryRoot.get(JobEntity_.uniqueId), contentQueryRoot.get(JobEntity_.name), contentQueryRoot.get(JobEntity_.user), contentQueryRoot.get(JobEntity_.status), contentQueryRoot.get(JobEntity_.started), contentQueryRoot.get(JobEntity_.finished), contentQueryRoot.get(JobEntity_.clusterName), contentQueryRoot.get(JobEntity_.commandName)});
        contentQuery.where((Expression)JobPredicates.getFindPredicate((Root<JobEntity>)contentQueryRoot, cb, id, name, user, statusStrings, tags, clusterName, clusterEntity, commandName, commandEntity, minStarted, maxStarted, minFinished, maxFinished, grouping, groupingInstance));
        Sort sort = page.getSort();
        ArrayList orders = new ArrayList();
        sort.iterator().forEachRemaining(order -> {
            if (order.isAscending()) {
                orders.add(cb.asc((Expression)root.get(order.getProperty())));
            } else {
                orders.add(cb.desc((Expression)root.get(order.getProperty())));
            }
        });
        contentQuery.orderBy(orders);
        List results = this.entityManager.createQuery(contentQuery).setFirstResult(Long.valueOf(page.getOffset()).intValue()).setMaxResults(page.getPageSize()).getResultList();
        return new PageImpl(results, page, totalCount);
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public long deleteJobsCreatedBefore(@NotNull Instant creationThreshold, @NotNull Set<com.netflix.genie.common.external.dtos.v4.JobStatus> excludeStatuses, @Min(value=1L) @Min(value=1L) int batchSize) {
        String excludeStatusesString = excludeStatuses.toString();
        String creationThresholdString = creationThreshold.toString();
        log.info("[deleteJobsCreatedBefore] Attempting to delete at most {} jobs created before {} that do not have any of these statuses {}", new Object[]{batchSize, creationThresholdString, excludeStatusesString});
        Set<String> ignoredStatusStrings = excludeStatuses.stream().map(Enum::name).collect(Collectors.toSet());
        long numJobsDeleted = this.jobRepository.deleteByIdIn(this.jobRepository.findJobsCreatedBefore(creationThreshold, ignoredStatusStrings, batchSize));
        log.info("[deleteJobsCreatedBefore] Deleted {} jobs created before {} that did not have any of these statuses {}", new Object[]{numJobsDeleted, creationThresholdString, excludeStatusesString});
        return numJobsDeleted;
    }

    @Override
    @Nonnull
    public String saveJobSubmission(@Valid JobSubmission jobSubmission) throws IdAlreadyExistsException {
        log.debug("[saveJobSubmission] Attempting to save job submission {}", (Object)jobSubmission);
        JobEntity jobEntity = new JobEntity();
        jobEntity.setStatus(com.netflix.genie.common.external.dtos.v4.JobStatus.RESERVED.name());
        com.netflix.genie.common.external.dtos.v4.JobRequest jobRequest = jobSubmission.getJobRequest();
        JobRequestMetadata jobRequestMetadata = jobSubmission.getJobRequestMetadata();
        this.setUniqueId(jobEntity, jobRequest.getRequestedId().orElse(null));
        jobEntity.setCommandArgs(jobRequest.getCommandArgs());
        this.setJobMetadataFields(jobEntity, jobRequest.getMetadata(), jobRequest.getResources().getSetupFile().orElse(null));
        this.setJobExecutionEnvironmentFields(jobEntity, jobRequest.getResources(), jobSubmission.getAttachments());
        this.setExecutionResourceCriteriaFields(jobEntity, jobRequest.getCriteria());
        this.setRequestedJobEnvironmentFields(jobEntity, jobRequest.getRequestedJobEnvironment());
        this.setRequestedAgentConfigFields(jobEntity, jobRequest.getRequestedAgentConfig());
        this.setRequestMetadataFields(jobEntity, jobRequestMetadata);
        jobEntity.setV4(true);
        jobEntity.setArchiveStatus(jobRequest.getRequestedAgentConfig().isArchivingDisabled() ? ArchiveStatus.DISABLED.name() : ArchiveStatus.PENDING.name());
        try {
            String id = ((JobEntity)this.jobRepository.save(jobEntity)).getUniqueId();
            log.debug("[saveJobSubmission] Saved job submission {} under job id {}", (Object)jobSubmission, (Object)id);
            SpanCustomizer spanCustomizer = this.addJobIdTag(id);
            this.tagAdapter.tag((Object)spanCustomizer, (Object)"genie.job.new", (Object)"true");
            return id;
        }
        catch (DataIntegrityViolationException e) {
            throw new IdAlreadyExistsException("A job with id " + jobEntity.getUniqueId() + " already exists. Unable to reserve id.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public com.netflix.genie.common.external.dtos.v4.JobRequest getJobRequest(@NotBlank String id) throws NotFoundException {
        log.debug("[getJobRequest] Requested for id {}", (Object)id);
        return this.jobRepository.getV4JobRequest(id).map(EntityV4DtoConverters::toV4JobRequestDto).orElseThrow(() -> new NotFoundException("No job ith id " + id + " exists"));
    }

    @Override
    public void saveResolvedJob(@NotBlank String id, @Valid ResolvedJob resolvedJob) throws NotFoundException {
        log.debug("[saveResolvedJob] Requested to save resolved information {} for job with id {}", (Object)resolvedJob, (Object)id);
        JobEntity entity = this.getJobEntity(id);
        try {
            if (entity.isResolved()) {
                log.error("[saveResolvedJob] Job {} was already resolved", (Object)id);
                return;
            }
            if (!DtoConverters.toV4JobStatus((String)entity.getStatus()).isResolvable()) {
                log.error("[saveResolvedJob] Job {} is already in a non-resolvable state {}. Needs to be one of {}. Won't save resolved info", new Object[]{id, entity.getStatus(), com.netflix.genie.common.external.dtos.v4.JobStatus.getResolvableStatuses()});
                return;
            }
            JobSpecification jobSpecification = resolvedJob.getJobSpecification();
            this.setExecutionResources(entity, jobSpecification.getCluster().getId(), jobSpecification.getCommand().getId(), jobSpecification.getApplications().stream().map(JobSpecification.ExecutionResource::getId).collect(Collectors.toList()));
            entity.setEnvironmentVariables(jobSpecification.getEnvironmentVariables());
            entity.setJobDirectoryLocation(jobSpecification.getJobDirectoryLocation().getAbsolutePath());
            jobSpecification.getArchiveLocation().ifPresent(entity::setArchiveLocation);
            jobSpecification.getTimeout().ifPresent(entity::setTimeoutUsed);
            JobEnvironment jobEnvironment = resolvedJob.getJobEnvironment();
            entity.setMemoryUsed(jobEnvironment.getMemory());
            entity.setResolved(true);
            entity.setStatus(com.netflix.genie.common.external.dtos.v4.JobStatus.RESOLVED.name());
            log.debug("[saveResolvedJob] Saved resolved information {} for job with id {}", (Object)resolvedJob, (Object)id);
        }
        catch (NotFoundException e) {
            log.error("[saveResolvedJob] Unable to save resolved job information {} for job {} due to {}", new Object[]{resolvedJob, id, e.getMessage(), e});
            throw e;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<JobSpecification> getJobSpecification(@NotBlank String id) throws NotFoundException {
        log.debug("[getJobSpecification] Requested to get job specification for job {}", (Object)id);
        JobSpecificationProjection projection = this.jobRepository.getJobSpecification(id).orElseThrow(() -> new NotFoundException("No job ith id " + id + " exists. Unable to get job specification."));
        return projection.isResolved() ? Optional.of(EntityV4DtoConverters.toJobSpecificationDto(projection)) : Optional.empty();
    }

    @Override
    public void claimJob(@NotBlank String id, @Valid AgentClientMetadata agentClientMetadata) throws NotFoundException, GenieJobAlreadyClaimedException, GenieInvalidStatusException {
        log.debug("[claimJob] Agent with metadata {} requesting to claim job with id {}", (Object)agentClientMetadata, (Object)id);
        JobEntity jobEntity = this.getJobEntity(id);
        if (jobEntity.isClaimed()) {
            throw new GenieJobAlreadyClaimedException("Job with id " + id + " is already claimed. Unable to claim.");
        }
        com.netflix.genie.common.external.dtos.v4.JobStatus currentStatus = DtoConverters.toV4JobStatus((String)jobEntity.getStatus());
        if (!currentStatus.isClaimable()) {
            throw new GenieInvalidStatusException("Job " + id + " is in status " + currentStatus + " and can't be claimed. Needs to be one of " + com.netflix.genie.common.external.dtos.v4.JobStatus.getClaimableStatuses());
        }
        jobEntity.setClaimed(true);
        jobEntity.setStatus(com.netflix.genie.common.external.dtos.v4.JobStatus.CLAIMED.name());
        agentClientMetadata.getHostname().ifPresent(jobEntity::setAgentHostname);
        agentClientMetadata.getVersion().ifPresent(jobEntity::setAgentVersion);
        agentClientMetadata.getPid().ifPresent(jobEntity::setAgentPid);
        log.debug("[claimJob] Claimed job {} for agent with metadata {}", (Object)id, (Object)agentClientMetadata);
    }

    @Override
    public void updateJobStatus(@NotBlank String id, @NotNull com.netflix.genie.common.external.dtos.v4.JobStatus currentStatus, @NotNull com.netflix.genie.common.external.dtos.v4.JobStatus newStatus, @Nullable String newStatusMessage) throws NotFoundException, GenieInvalidStatusException {
        log.debug("[updateJobStatus] Requested to change the status of job {} from {} to {} with message {}", new Object[]{id, currentStatus, newStatus, newStatusMessage});
        if (currentStatus == newStatus) {
            throw new GenieInvalidStatusException("Can't update the status of job " + id + " because both current and new status are " + currentStatus);
        }
        JobEntity jobEntity = this.getJobEntity(id);
        com.netflix.genie.common.external.dtos.v4.JobStatus actualCurrentStatus = DtoConverters.toV4JobStatus((String)jobEntity.getStatus());
        if (actualCurrentStatus != currentStatus) {
            throw new GenieInvalidStatusException("Job " + id + " current status is " + actualCurrentStatus + " but API caller expected it to be " + currentStatus + ". Unable to update status due to inconsistent state.");
        }
        this.updateJobStatus(jobEntity, newStatus, newStatusMessage);
        log.debug("[updateJobStatus] Changed the status of job {} from {} to {} with message {}", new Object[]{id, currentStatus, newStatus, newStatusMessage});
    }

    @Override
    public void updateJobArchiveStatus(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String id, @NotNull(message="Status cannot be null.") @NotNull(message="Status cannot be null.") ArchiveStatus archiveStatus) throws NotFoundException {
        log.debug("[updateJobArchiveStatus] Requested to change the archive status of job {} to {}", (Object)id, (Object)archiveStatus);
        ((JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new NotFoundException("No job exists for the id specified"))).setArchiveStatus(archiveStatus.name());
        log.debug("[updateJobArchiveStatus] Changed the archive status of job {} to {}", (Object)id, (Object)archiveStatus);
    }

    @Override
    @Transactional(readOnly=true)
    public com.netflix.genie.common.external.dtos.v4.JobStatus getJobStatus(@NotBlank String id) throws NotFoundException {
        return DtoConverters.toV4JobStatus((String)this.jobRepository.getJobStatus(id).orElseThrow(() -> new NotFoundException("No job with id " + id + " exists. Unable to get status.")));
    }

    @Override
    @Transactional(readOnly=true)
    public ArchiveStatus getJobArchiveStatus(@NotBlank String id) throws NotFoundException {
        try {
            return ArchiveStatus.valueOf((String)this.jobRepository.getArchiveStatus(id).orElseThrow(() -> new NotFoundException("No job with id " + id + " exists")));
        }
        catch (IllegalArgumentException e) {
            return ArchiveStatus.UNKNOWN;
        }
    }

    @Override
    @Transactional(readOnly=true)
    public Optional<String> getJobArchiveLocation(@NotBlank String id) throws NotFoundException {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery query = criteriaBuilder.createQuery(String.class);
        Root root = query.from(JobEntity.class);
        query.select((Selection)root.get(JobEntity_.archiveLocation));
        query.where((Expression)criteriaBuilder.equal((Expression)root.get(JobEntity_.uniqueId), (Object)id));
        try {
            return Optional.ofNullable(this.entityManager.createQuery(query).getSingleResult());
        }
        catch (NoResultException e) {
            throw new NotFoundException("No job with id " + id + " exits.", e);
        }
    }

    @Override
    @Transactional(readOnly=true)
    public FinishedJob getFinishedJob(@NotBlank String id) throws NotFoundException, GenieInvalidStatusException {
        return this.jobRepository.findByUniqueId(id, FinishedJobProjection.class).map(EntityV4DtoConverters::toFinishedJobDto).orElseThrow(() -> new NotFoundException("No job with id " + id + " exists."));
    }

    @Override
    @Transactional(readOnly=true)
    public boolean isApiJob(@NotBlank String id) throws NotFoundException {
        return this.jobRepository.isAPI(id).orElseThrow(() -> new NotFoundException("No job with id " + id + " exists"));
    }

    @Override
    @Transactional(readOnly=true)
    public Cluster getJobCluster(@NotBlank String id) throws NotFoundException {
        log.debug("[getJobCluster] Called for job {}", (Object)id);
        return EntityV4DtoConverters.toV4ClusterDto(this.jobRepository.getJobCluster(id).orElseThrow(() -> new NotFoundException("No job with id " + id + " exists")).getCluster().orElseThrow(() -> new NotFoundException("Job " + id + " has no associated cluster")));
    }

    @Override
    @Transactional(readOnly=true)
    public Command getJobCommand(@NotBlank String id) throws NotFoundException {
        log.debug("[getJobCommand] Called for job {}", (Object)id);
        return EntityV4DtoConverters.toV4CommandDto(this.jobRepository.getJobCommand(id).orElseThrow(() -> new NotFoundException("No job with id " + id + " exists")).getCommand().orElseThrow(() -> new NotFoundException("Job " + id + " has no associated command")));
    }

    @Override
    @Transactional(readOnly=true)
    public List<Application> getJobApplications(@NotBlank String id) throws NotFoundException {
        log.debug("[getJobApplications] Called for job {}", (Object)id);
        return this.jobRepository.getJobApplications(id).orElseThrow(() -> new NotFoundException("No job with id " + id + " exists")).getApplications().stream().map(EntityV4DtoConverters::toV4ApplicationDto).collect(Collectors.toList());
    }

    @Override
    @Transactional(readOnly=true)
    public long getActiveJobCountForUser(@NotBlank String user) {
        log.debug("[getActiveJobCountForUser] Called for jobs with user {}", (Object)user);
        Long count = this.jobRepository.countJobsByUserAndStatusIn(user, ACTIVE_STATUS_SET);
        if (count == null || count < 0L) {
            throw new GenieRuntimeException("Count query for user " + user + "produced an unexpected result: " + count);
        }
        return count;
    }

    @Override
    @Transactional(readOnly=true)
    public Map<String, UserResourcesSummary> getUserResourcesSummaries(Set<com.netflix.genie.common.external.dtos.v4.JobStatus> statuses, boolean api) {
        log.debug("[getUserResourcesSummaries] Called for statuses {} and api {}", statuses, (Object)api);
        return this.jobRepository.getUserJobResourcesAggregates(statuses.stream().map(Enum::name).collect(Collectors.toSet()), api).stream().map(EntityV3DtoConverters::toUserResourceSummaryDto).collect(Collectors.toMap(UserResourcesSummary::getUser, userResourcesSummary -> userResourcesSummary));
    }

    @Override
    @Transactional(readOnly=true)
    public long getUsedMemoryOnHost(@NotBlank String hostname) {
        log.debug("[getUsedMemoryOnHost] Called for hostname {}", (Object)hostname);
        return this.jobRepository.getTotalMemoryUsedOnHost(hostname, USING_MEMORY_JOB_SET);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getActiveJobs() {
        log.debug("[getActiveJobs] Called");
        return this.jobRepository.getJobIdsWithStatusIn(ACTIVE_STATUS_SET);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getUnclaimedJobs() {
        log.debug("[getUnclaimedJobs] Called");
        return this.jobRepository.getJobIdsWithStatusIn(UNCLAIMED_STATUS_SET);
    }

    @Override
    @Transactional(readOnly=true)
    public JobInfoAggregate getHostJobInformation(@NotBlank String hostname) {
        log.debug("[getHostJobInformation] Called for hostname {}", (Object)hostname);
        return this.jobRepository.getHostJobInfo(hostname, ACTIVE_STATUS_SET, USING_MEMORY_JOB_SET);
    }

    @Override
    @Transactional(readOnly=true)
    public Set<String> getJobsWithStatusAndArchiveStatusUpdatedBefore(@NotEmpty Set<com.netflix.genie.common.external.dtos.v4.JobStatus> statuses, @NotEmpty Set<ArchiveStatus> archiveStatuses, @NotNull Instant updated) {
        log.debug("[getJobsWithStatusAndArchiveStatusUpdatedBefore] Called with statuses {}, archiveStatuses {}, updated {}", new Object[]{statuses, archiveStatuses, updated});
        return this.jobRepository.getJobsWithStatusAndArchiveStatusUpdatedBefore(statuses.stream().map(Enum::name).collect(Collectors.toSet()), archiveStatuses.stream().map(Enum::name).collect(Collectors.toSet()), updated);
    }

    @Override
    public void updateRequestedLauncherExt(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String id, @NotNull(message="Status cannot be null.") @NotNull(message="Status cannot be null.") JsonNode launcherExtension) throws NotFoundException {
        log.debug("[updateRequestedLauncherExt] Requested to update launcher requested ext of job {}", (Object)id);
        ((JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new NotFoundException("No job exists for the id specified"))).setRequestedLauncherExt(launcherExtension);
        log.debug("[updateRequestedLauncherExt] Updated launcher requested ext of job {}", (Object)id);
    }

    @Override
    @Transactional(readOnly=true)
    public JsonNode getRequestedLauncherExt(@NotBlank String id) throws NotFoundException {
        log.debug("[getRequestedLauncherExt] Requested for job {}", (Object)id);
        return this.jobRepository.getRequestedLauncherExt(id).orElse((JsonNode)NullNode.getInstance());
    }

    @Override
    public void updateLauncherExt(@NotBlank(message="No job id entered. Unable to update.") @NotBlank(message="No job id entered. Unable to update.") String id, @NotNull(message="Status cannot be null.") @NotNull(message="Status cannot be null.") JsonNode launcherExtension) throws NotFoundException {
        log.debug("[updateLauncherExt] Requested to update launcher ext of job {}", (Object)id);
        ((JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new NotFoundException("No job exists for the id specified"))).setLauncherExt(launcherExtension);
        log.debug("[updateLauncherExt] Updated launcher ext of job {}", (Object)id);
    }

    @Override
    @Transactional(readOnly=true)
    public JsonNode getLauncherExt(@NotBlank String id) throws NotFoundException {
        log.debug("[getLauncherExt] Requested for job {}", (Object)id);
        return this.jobRepository.getLauncherExt(id).orElse((JsonNode)NullNode.getInstance());
    }

    @Override
    public <R extends CommonResource> void addConfigsToResource(@NotBlank String id, Set<@Size(max=1024) String> configs, Class<R> resourceClass) throws NotFoundException {
        this.getResourceConfigEntities(id, resourceClass).addAll(this.createOrGetFileEntities(configs));
    }

    @Override
    @Transactional(readOnly=true)
    public <R extends CommonResource> Set<String> getConfigsForResource(@NotBlank String id, Class<R> resourceClass) throws NotFoundException {
        return this.getResourceConfigEntities(id, resourceClass).stream().map(FileEntity::getFile).collect(Collectors.toSet());
    }

    @Override
    public <R extends CommonResource> void updateConfigsForResource(@NotBlank String id, Set<@Size(max=1024) String> configs, Class<R> resourceClass) throws NotFoundException {
        Set<FileEntity> configEntities = this.getResourceConfigEntities(id, resourceClass);
        configEntities.clear();
        configEntities.addAll(this.createOrGetFileEntities(configs));
    }

    @Override
    public <R extends CommonResource> void removeAllConfigsForResource(@NotBlank String id, Class<R> resourceClass) throws NotFoundException {
        Set<FileEntity> configEntities = this.getResourceConfigEntities(id, resourceClass);
        configEntities.clear();
    }

    @Override
    public <R extends CommonResource> void removeConfigForResource(@NotBlank String id, @NotBlank String config, Class<R> resourceClass) throws NotFoundException {
        this.getResourceConfigEntities(id, resourceClass).removeIf(entity -> config.equals(entity.getFile()));
    }

    @Override
    public <R extends CommonResource> void addDependenciesToResource(@NotBlank String id, Set<@Size(max=1024) String> dependencies, Class<R> resourceClass) throws NotFoundException {
        this.getResourceDependenciesEntities(id, resourceClass).addAll(this.createOrGetFileEntities(dependencies));
    }

    @Override
    @Transactional(readOnly=true)
    public <R extends CommonResource> Set<String> getDependenciesForResource(@NotBlank String id, Class<R> resourceClass) throws NotFoundException {
        return this.getResourceDependenciesEntities(id, resourceClass).stream().map(FileEntity::getFile).collect(Collectors.toSet());
    }

    @Override
    public <R extends CommonResource> void updateDependenciesForResource(@NotBlank String id, Set<@Size(max=1024) String> dependencies, Class<R> resourceClass) throws NotFoundException {
        Set<FileEntity> dependencyEntities = this.getResourceDependenciesEntities(id, resourceClass);
        dependencyEntities.clear();
        dependencyEntities.addAll(this.createOrGetFileEntities(dependencies));
    }

    @Override
    public <R extends CommonResource> void removeAllDependenciesForResource(@NotBlank String id, Class<R> resourceClass) throws NotFoundException {
        Set<FileEntity> dependencyEntities = this.getResourceDependenciesEntities(id, resourceClass);
        dependencyEntities.clear();
    }

    @Override
    public <R extends CommonResource> void removeDependencyForResource(@NotBlank String id, @NotBlank String dependency, Class<R> resourceClass) throws NotFoundException {
        this.getResourceDependenciesEntities(id, resourceClass).removeIf(entity -> dependency.equals(entity.getFile()));
    }

    @Override
    public <R extends CommonResource> void addTagsToResource(@NotBlank String id, Set<@Size(max=255) String> tags, Class<R> resourceClass) throws NotFoundException {
        this.getResourceTagEntities(id, resourceClass).addAll(this.createOrGetTagEntities(tags));
    }

    @Override
    @Transactional(readOnly=true)
    public <R extends CommonResource> Set<String> getTagsForResource(@NotBlank String id, Class<R> resourceClass) throws NotFoundException {
        return this.getResourceTagEntities(id, resourceClass).stream().map(TagEntity::getTag).collect(Collectors.toSet());
    }

    @Override
    public <R extends CommonResource> void updateTagsForResource(@NotBlank String id, Set<@Size(max=255) String> tags, Class<R> resourceClass) throws NotFoundException {
        Set<TagEntity> tagEntities = this.getResourceTagEntities(id, resourceClass);
        tagEntities.clear();
        tagEntities.addAll(this.createOrGetTagEntities(tags));
    }

    @Override
    public <R extends CommonResource> void removeAllTagsForResource(@NotBlank String id, Class<R> resourceClass) throws NotFoundException {
        Set<TagEntity> tagEntities = this.getResourceTagEntities(id, resourceClass);
        tagEntities.clear();
    }

    @Override
    public <R extends CommonResource> void removeTagForResource(@NotBlank String id, @NotBlank String tag, Class<R> resourceClass) throws NotFoundException {
        this.getResourceTagEntities(id, resourceClass).removeIf(entity -> tag.equals(entity.getTag()));
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public long deleteUnusedTags(@NotNull Instant createdThreshold, @Min(value=1L) @Min(value=1L) int batchSize) {
        log.info("[deleteUnusedTags] Called to delete unused tags created before {}", (Object)createdThreshold);
        return this.tagRepository.deleteByIdIn(this.tagRepository.findUnusedTags(createdThreshold, batchSize).stream().map(Number::longValue).collect(Collectors.toSet()));
    }

    @Override
    @Transactional(isolation=Isolation.READ_COMMITTED)
    public long deleteUnusedFiles(@NotNull Instant createdThreshold, @Min(value=1L) @Min(value=1L) int batchSize) {
        log.debug("[deleteUnusedFiles] Called to delete unused files created before {}", (Object)createdThreshold);
        return this.fileRepository.deleteByIdIn(this.fileRepository.findUnusedFiles(createdThreshold, batchSize).stream().map(Number::longValue).collect(Collectors.toSet()));
    }

    private ApplicationEntity getApplicationEntity(String id) throws NotFoundException {
        return (ApplicationEntity)this.applicationRepository.findByUniqueId(id).orElseThrow(() -> new NotFoundException("No application with id " + id + " exists"));
    }

    private ClusterEntity getClusterEntity(String id) throws NotFoundException {
        return (ClusterEntity)this.clusterRepository.findByUniqueId(id).orElseThrow(() -> new NotFoundException("No cluster with id " + id + " exists"));
    }

    private CommandEntity getCommandEntity(String id) throws NotFoundException {
        return (CommandEntity)this.commandRepository.findByUniqueId(id).orElseThrow(() -> new NotFoundException("No command with id " + id + " exists"));
    }

    private JobEntity getJobEntity(String id) throws NotFoundException {
        return (JobEntity)this.jobRepository.findByUniqueId(id).orElseThrow(() -> new NotFoundException("No job with id " + id + " exists"));
    }

    private FileEntity createOrGetFileEntity(String file) {
        return this.createOrGetSharedEntity(file, this.fileRepository::findByFile, FileEntity::new, arg_0 -> ((JpaFileRepository)this.fileRepository).saveAndFlush(arg_0));
    }

    private Set<FileEntity> createOrGetFileEntities(Set<String> files) {
        return files.stream().map(this::createOrGetFileEntity).collect(Collectors.toSet());
    }

    private TagEntity createOrGetTagEntity(String tag) {
        return this.createOrGetSharedEntity(tag, this.tagRepository::findByTag, TagEntity::new, arg_0 -> ((JpaTagRepository)this.tagRepository).saveAndFlush(arg_0));
    }

    private Set<TagEntity> createOrGetTagEntities(Set<String> tags) {
        return tags.stream().map(this::createOrGetTagEntity).collect(Collectors.toSet());
    }

    private <E> E createOrGetSharedEntity(String value, Function<String, Optional<E>> find, Function<String, E> entityCreation, Function<E, E> saveAndFlush) {
        Optional<E> existingEntity = find.apply(value);
        if (existingEntity.isPresent()) {
            return existingEntity.get();
        }
        try {
            return saveAndFlush.apply(entityCreation.apply(value));
        }
        catch (DataIntegrityViolationException e) {
            return find.apply(value).orElseThrow(() -> new GenieRuntimeException(value + " entity creation failed but still can't find record", (Throwable)e));
        }
    }

    private <R extends CommonResource> Set<FileEntity> getResourceConfigEntities(String id, Class<R> resourceClass) throws NotFoundException {
        if (resourceClass.equals(Application.class)) {
            return this.getApplicationEntity(id).getConfigs();
        }
        if (resourceClass.equals(Cluster.class)) {
            return this.getClusterEntity(id).getConfigs();
        }
        if (resourceClass.equals(Command.class)) {
            return this.getCommandEntity(id).getConfigs();
        }
        throw new IllegalArgumentException("Unsupported type: " + resourceClass);
    }

    private <R extends CommonResource> Set<FileEntity> getResourceDependenciesEntities(String id, Class<R> resourceClass) throws NotFoundException {
        if (resourceClass.equals(Application.class)) {
            return this.getApplicationEntity(id).getDependencies();
        }
        if (resourceClass.equals(Cluster.class)) {
            return this.getClusterEntity(id).getDependencies();
        }
        if (resourceClass.equals(Command.class)) {
            return this.getCommandEntity(id).getDependencies();
        }
        throw new IllegalArgumentException("Unsupported type: " + resourceClass);
    }

    private <R extends CommonResource> Set<TagEntity> getResourceTagEntities(String id, Class<R> resourceClass) throws NotFoundException {
        if (resourceClass.equals(Application.class)) {
            return this.getApplicationEntity(id).getTags();
        }
        if (resourceClass.equals(Cluster.class)) {
            return this.getClusterEntity(id).getTags();
        }
        if (resourceClass.equals(Command.class)) {
            return this.getCommandEntity(id).getTags();
        }
        throw new IllegalArgumentException("Unsupported type: " + resourceClass);
    }

    private <E extends UniqueIdEntity> void setUniqueId(E entity, @Nullable String requestedId) {
        if (requestedId != null) {
            entity.setUniqueId(requestedId);
            entity.setRequestedId(true);
        } else {
            entity.setUniqueId(UUID.randomUUID().toString());
            entity.setRequestedId(false);
        }
    }

    private void setEntityResources(ExecutionEnvironment resources, Consumer<Set<FileEntity>> configsConsumer, Consumer<Set<FileEntity>> dependenciesConsumer) {
        configsConsumer.accept(this.createOrGetFileEntities(resources.getConfigs()));
        dependenciesConsumer.accept(this.createOrGetFileEntities(resources.getDependencies()));
    }

    private void setEntityTags(Set<String> tags, Consumer<Set<TagEntity>> tagsConsumer) {
        tagsConsumer.accept(this.createOrGetTagEntities(tags));
    }

    private void updateApplicationEntity(ApplicationEntity entity, ExecutionEnvironment resources, ApplicationMetadata metadata) {
        entity.setStatus(metadata.getStatus().name());
        entity.setType(metadata.getType().orElse(null));
        this.setEntityResources(resources, entity::setConfigs, entity::setDependencies);
        this.setEntityTags(metadata.getTags(), entity::setTags);
        this.setBaseEntityMetadata(entity, (CommonMetadata)metadata, resources.getSetupFile().orElse(null));
    }

    private void updateClusterEntity(ClusterEntity entity, ExecutionEnvironment resources, ClusterMetadata metadata) {
        entity.setStatus(metadata.getStatus().name());
        this.setEntityResources(resources, entity::setConfigs, entity::setDependencies);
        this.setEntityTags(metadata.getTags(), entity::setTags);
        this.setBaseEntityMetadata(entity, (CommonMetadata)metadata, resources.getSetupFile().orElse(null));
    }

    @SuppressFBWarnings(value={"NP_PARAMETER_MUST_BE_NONNULL_BUT_MARKED_AS_NULLABLE"})
    private void updateCommandEntity(CommandEntity entity, ExecutionEnvironment resources, CommandMetadata metadata, long checkDelay, List<String> executable, @Nullable Integer memory, List<Criterion> clusterCriteria) {
        this.setEntityResources(resources, entity::setConfigs, entity::setDependencies);
        this.setEntityTags(metadata.getTags(), entity::setTags);
        this.setBaseEntityMetadata(entity, (CommonMetadata)metadata, resources.getSetupFile().orElse(null));
        entity.setStatus(metadata.getStatus().name());
        entity.setCheckDelay(checkDelay);
        entity.setExecutable(executable);
        entity.setMemory(memory);
        this.updateClusterCriteria(entity, clusterCriteria);
    }

    private void setBaseEntityMetadata(BaseEntity entity, CommonMetadata metadata, @Nullable String setupFile) {
        entity.setName(metadata.getName());
        entity.setUser(metadata.getUser());
        entity.setVersion(metadata.getVersion());
        entity.setDescription(metadata.getDescription().orElse(null));
        entity.setMetadata(metadata.getMetadata().orElse(null));
        entity.setSetupFile(setupFile == null ? null : this.createOrGetFileEntity(setupFile));
    }

    private void deleteApplicationEntity(ApplicationEntity entity) throws PreconditionFailedException {
        Set<CommandEntity> commandEntities = entity.getCommands();
        if (!commandEntities.isEmpty()) {
            throw new PreconditionFailedException("Unable to delete application with id " + entity.getUniqueId() + " as it is still used by the following commands: " + commandEntities.stream().map(UniqueIdEntity::getUniqueId).collect(Collectors.joining()));
        }
        this.applicationRepository.delete(entity);
    }

    private void deleteClusterEntity(ClusterEntity entity) {
        this.clusterRepository.delete(entity);
    }

    private void deleteCommandEntity(CommandEntity entity) {
        List<ApplicationEntity> originalApps = entity.getApplications();
        if (originalApps != null) {
            ArrayList applicationEntities = Lists.newArrayList(originalApps);
            applicationEntities.forEach(entity::removeApplication);
        }
        this.commandRepository.delete(entity);
    }

    private void deleteAllClusterCriteria(CommandEntity commandEntity) {
        List<CriterionEntity> persistedEntities = commandEntity.getClusterCriteria();
        ArrayList entitiesToDelete = Lists.newArrayList(persistedEntities);
        persistedEntities.clear();
        entitiesToDelete.forEach(arg_0 -> ((JpaCriterionRepository)this.criterionRepository).delete(arg_0));
    }

    private CriterionEntity toCriterionEntity(Criterion criterion) {
        CriterionEntity criterionEntity = new CriterionEntity();
        criterion.getId().ifPresent(criterionEntity::setUniqueId);
        criterion.getName().ifPresent(criterionEntity::setName);
        criterion.getVersion().ifPresent(criterionEntity::setVersion);
        criterion.getStatus().ifPresent(criterionEntity::setStatus);
        criterionEntity.setTags(this.createOrGetTagEntities(criterion.getTags()));
        return criterionEntity;
    }

    private void updateClusterCriteria(CommandEntity commandEntity, List<Criterion> clusterCriteria) {
        this.deleteAllClusterCriteria(commandEntity);
        commandEntity.setClusterCriteria(clusterCriteria.stream().map(this::toCriterionEntity).collect(Collectors.toList()));
    }

    private void updateJobStatus(JobEntity jobEntity, com.netflix.genie.common.external.dtos.v4.JobStatus newStatus, @Nullable String statusMsg) {
        com.netflix.genie.common.external.dtos.v4.JobStatus currentStatus = DtoConverters.toV4JobStatus((String)jobEntity.getStatus());
        if (currentStatus.isActive()) {
            jobEntity.setStatus(newStatus.name());
            jobEntity.setStatusMsg(StringUtils.truncate((String)statusMsg, (int)255));
            if (newStatus.equals((Object)com.netflix.genie.common.external.dtos.v4.JobStatus.RUNNING)) {
                jobEntity.setStarted(Instant.now());
            } else if (jobEntity.getStarted().isPresent() && newStatus.isFinished()) {
                jobEntity.setFinished(Instant.now());
            }
        }
    }

    private void setJobMetadataFields(JobEntity jobEntity, com.netflix.genie.common.external.dtos.v4.JobMetadata jobMetadata, @Nullable String setupFile) {
        this.setBaseEntityMetadata(jobEntity, (CommonMetadata)jobMetadata, setupFile);
        this.setEntityTags(jobMetadata.getTags(), jobEntity::setTags);
        jobMetadata.getEmail().ifPresent(jobEntity::setEmail);
        jobMetadata.getGroup().ifPresent(jobEntity::setGenieUserGroup);
        jobMetadata.getGrouping().ifPresent(jobEntity::setGrouping);
        jobMetadata.getGroupingInstance().ifPresent(jobEntity::setGroupingInstance);
    }

    private void setJobExecutionEnvironmentFields(JobEntity jobEntity, ExecutionEnvironment executionEnvironment, @Nullable Set<URI> savedAttachments) {
        jobEntity.setConfigs(this.createOrGetFileEntities(executionEnvironment.getConfigs()));
        Set<FileEntity> dependencies = this.createOrGetFileEntities(executionEnvironment.getDependencies());
        if (savedAttachments != null) {
            dependencies.addAll(this.createOrGetFileEntities(savedAttachments.stream().map(URI::toString).collect(Collectors.toSet())));
        }
        jobEntity.setDependencies(dependencies);
    }

    private void setExecutionResourceCriteriaFields(JobEntity jobEntity, ExecutionResourceCriteria criteria) {
        List clusterCriteria = criteria.getClusterCriteria();
        ArrayList clusterCriteriaEntities = Lists.newArrayListWithExpectedSize((int)clusterCriteria.size());
        for (Criterion clusterCriterion : clusterCriteria) {
            clusterCriteriaEntities.add(this.toCriterionEntity(clusterCriterion));
        }
        jobEntity.setClusterCriteria(clusterCriteriaEntities);
        jobEntity.setCommandCriterion(this.toCriterionEntity(criteria.getCommandCriterion()));
        jobEntity.setRequestedApplications(criteria.getApplicationIds());
    }

    private void setRequestedJobEnvironmentFields(JobEntity jobEntity, JobEnvironmentRequest requestedJobEnvironment) {
        jobEntity.setRequestedEnvironmentVariables(requestedJobEnvironment.getRequestedEnvironmentVariables());
        requestedJobEnvironment.getRequestedJobMemory().ifPresent(jobEntity::setRequestedMemory);
        requestedJobEnvironment.getRequestedJobCpu().ifPresent(jobEntity::setRequestedCpu);
        requestedJobEnvironment.getExt().ifPresent(jobEntity::setRequestedAgentEnvironmentExt);
    }

    private void setRequestedAgentConfigFields(JobEntity jobEntity, AgentConfigRequest requestedAgentConfig) {
        jobEntity.setInteractive(requestedAgentConfig.isInteractive());
        jobEntity.setArchivingDisabled(requestedAgentConfig.isArchivingDisabled());
        requestedAgentConfig.getRequestedJobDirectoryLocation().ifPresent(location -> jobEntity.setRequestedJobDirectoryLocation(location.getAbsolutePath()));
        requestedAgentConfig.getTimeoutRequested().ifPresent(jobEntity::setRequestedTimeout);
        requestedAgentConfig.getExt().ifPresent(jobEntity::setRequestedAgentConfigExt);
    }

    private void setRequestMetadataFields(JobEntity jobEntity, JobRequestMetadata jobRequestMetadata) {
        jobEntity.setApi(jobRequestMetadata.isApi());
        jobEntity.setNumAttachments(jobRequestMetadata.getNumAttachments());
        jobEntity.setTotalSizeOfAttachments(jobRequestMetadata.getTotalSizeOfAttachments());
        jobRequestMetadata.getApiClientMetadata().ifPresent(apiClientMetadata -> {
            apiClientMetadata.getHostname().ifPresent(jobEntity::setRequestApiClientHostname);
            apiClientMetadata.getUserAgent().ifPresent(jobEntity::setRequestApiClientUserAgent);
        });
        jobRequestMetadata.getAgentClientMetadata().ifPresent(agentClientMetadata -> {
            agentClientMetadata.getHostname().ifPresent(jobEntity::setRequestAgentClientHostname);
            agentClientMetadata.getVersion().ifPresent(jobEntity::setRequestAgentClientVersion);
            agentClientMetadata.getPid().ifPresent(jobEntity::setRequestAgentClientPid);
        });
    }

    private void setExecutionResources(JobEntity job, String clusterId, String commandId, List<String> applicationIds) throws NotFoundException {
        ClusterEntity cluster = this.getClusterEntity(clusterId);
        CommandEntity command = this.getCommandEntity(commandId);
        ArrayList applications = Lists.newArrayList();
        for (String applicationId : applicationIds) {
            applications.add(this.getApplicationEntity(applicationId));
        }
        job.setCluster(cluster);
        job.setCommand(command);
        job.setApplications(applications);
    }

    private <E extends BaseEntity> Optional<E> getEntityOrNullForFindJobs(JpaBaseRepository<E> repository, String id, @Nullable String name) {
        Optional<E> optionalEntity = repository.findByUniqueId(id);
        if (optionalEntity.isPresent()) {
            BaseEntity entity = (BaseEntity)optionalEntity.get();
            if (name != null && !entity.getName().equals(name)) {
                return Optional.empty();
            }
        }
        return optionalEntity;
    }

    private SpanCustomizer addJobIdTag(String jobId) {
        SpanCustomizer spanCustomizer = this.tracer.currentSpanCustomizer();
        this.tagAdapter.tag((Object)spanCustomizer, (Object)"genie.job.id", (Object)jobId);
        return spanCustomizer;
    }
}

