/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.processors;

import com.netflix.genie.common.internal.util.PropertySourceUtils;
import java.util.Arrays;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;

public class GenieDefaultPropertiesPostProcessor
implements EnvironmentPostProcessor {
    static final String DEFAULT_PROPERTY_SOURCE_NAME = "genie-web-defaults";
    static final String DEFAULT_PROD_PROPERTY_SOURCE_NAME = "genie-web-prod-defaults";
    private static final String DEFAULT_PROPERTIES_FILE = "genie-web-defaults.yml";
    private static final String PROD_PROFILE = "prod";
    private static final String DEFAULT_PROD_PROPERTIES_FILE = "genie-web-prod-defaults.yml";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        ClassPathResource defaultProperties = new ClassPathResource(DEFAULT_PROPERTIES_FILE);
        PropertySource defaultSource = PropertySourceUtils.loadYamlPropertySource((String)DEFAULT_PROPERTY_SOURCE_NAME, (Resource)defaultProperties);
        environment.getPropertySources().addLast(defaultSource);
        if (Arrays.asList(environment.getActiveProfiles()).contains(PROD_PROFILE)) {
            ClassPathResource defaultProdProperties = new ClassPathResource(DEFAULT_PROD_PROPERTIES_FILE);
            PropertySource defaultProdSource = PropertySourceUtils.loadYamlPropertySource((String)DEFAULT_PROD_PROPERTY_SOURCE_NAME, (Resource)defaultProdProperties);
            environment.getPropertySources().addBefore(DEFAULT_PROPERTY_SOURCE_NAME, defaultProdSource);
        }
    }
}

