/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.apis.rpc.v4.endpoints;

import com.google.protobuf.Timestamp;
import com.google.protobuf.util.Timestamps;
import com.netflix.genie.common.internal.util.GenieHostInfo;
import com.netflix.genie.proto.PingRequest;
import com.netflix.genie.proto.PingServiceGrpc;
import com.netflix.genie.proto.PongResponse;
import io.grpc.stub.StreamObserver;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GRpcPingServiceImpl
extends PingServiceGrpc.PingServiceImplBase {
    private static final Logger log = LoggerFactory.getLogger(GRpcPingServiceImpl.class);
    private final String hostName;

    public GRpcPingServiceImpl(GenieHostInfo genieHostInfo) {
        this.hostName = genieHostInfo.getHostname();
    }

    public void ping(PingRequest request, StreamObserver<PongResponse> responseObserver) {
        PongResponse response = PongResponse.newBuilder().setRequestId(request.getRequestId()).setTimestamp(Timestamps.fromMillis((long)System.currentTimeMillis())).putServerMetadata("hostName", this.hostName).build();
        responseObserver.onNext((Object)response);
        responseObserver.onCompleted();
        StringBuilder sb = new StringBuilder();
        sb.append(String.format("Received ping with id: '%s' from client: '%s' and timestamp: '%s'. ", request.getRequestId(), request.getSourceName(), Timestamps.toString((Timestamp)request.getTimestamp())));
        sb.append("Client metadata: [ ");
        for (Map.Entry clientMetadataEntry : request.getClientMetadataMap().entrySet()) {
            sb.append("{").append((String)clientMetadataEntry.getKey()).append(" : ").append((String)clientMetadataEntry.getValue()).append("}, ");
        }
        sb.append("]");
        log.info(sb.toString());
    }

    static final class ServerMetadataKeys {
        static final String SERVER_NAME = "hostName";

        ServerMetadataKeys() {
        }
    }
}

