/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.entities;

import com.fasterxml.jackson.databind.JsonNode;
import com.netflix.genie.web.data.services.impl.jpa.converters.JsonAttributeConverter;
import com.netflix.genie.web.data.services.impl.jpa.entities.ApplicationEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.BaseEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CriterionEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.FileEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.UniqueIdEntity;
import com.netflix.genie.web.exceptions.checked.PreconditionFailedException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.NamedAttributeNode;
import javax.persistence.NamedEntityGraph;
import javax.persistence.NamedEntityGraphs;
import javax.persistence.NamedSubgraph;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

@Entity
@Table(name="commands")
@NamedEntityGraphs(value={@NamedEntityGraph(name="Command.applications", attributeNodes={@NamedAttributeNode(value="applications", subgraph="application-sub-graph")}, subgraphs={@NamedSubgraph(name="application-sub-graph", attributeNodes={@NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="tags")})}), @NamedEntityGraph(name="Command.applications.dto", attributeNodes={@NamedAttributeNode(value="applications", subgraph="application-sub-graph")}, subgraphs={@NamedSubgraph(name="application-sub-graph", attributeNodes={@NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="tags")})}), @NamedEntityGraph(name="Command.clusterCriteria", attributeNodes={@NamedAttributeNode(value="clusterCriteria", subgraph="criteria-sub-graph")}, subgraphs={@NamedSubgraph(name="criteria-sub-graph", attributeNodes={@NamedAttributeNode(value="tags")})}), @NamedEntityGraph(name="Command.DTO", attributeNodes={@NamedAttributeNode(value="executable"), @NamedAttributeNode(value="launcherExt"), @NamedAttributeNode(value="setupFile"), @NamedAttributeNode(value="configs"), @NamedAttributeNode(value="dependencies"), @NamedAttributeNode(value="tags"), @NamedAttributeNode(value="clusterCriteria", subgraph="criteria-sub-graph")}, subgraphs={@NamedSubgraph(name="criteria-sub-graph", attributeNodes={@NamedAttributeNode(value="tags")})})})
public class CommandEntity
extends BaseEntity {
    public static final String APPLICATIONS_ENTITY_GRAPH = "Command.applications";
    public static final String APPLICATIONS_DTO_ENTITY_GRAPH = "Command.applications.dto";
    public static final String CLUSTER_CRITERIA_ENTITY_GRAPH = "Command.clusterCriteria";
    public static final String DTO_ENTITY_GRAPH = "Command.DTO";
    private static final long serialVersionUID = -8058995173025433517L;
    private static final int HIGHEST_CRITERION_PRIORITY = 0;
    @ElementCollection
    @CollectionTable(name="command_executable_arguments", joinColumns={@JoinColumn(name="command_id", nullable=false)})
    @Column(name="argument", length=1024, nullable=false)
    @OrderColumn(name="argument_order", nullable=false)
    @NotEmpty(message="No executable arguments entered. At least one is required.")
    private @NotEmpty(message="No executable arguments entered. At least one is required.") List<@NotBlank @Size(max=1024) String> executable = new ArrayList<String>();
    @Basic(optional=false)
    @Column(name="check_delay", nullable=false)
    @Min(value=1L)
    private @Min(value=1L) long checkDelay = 10000L;
    @Basic
    @Column(name="memory")
    @Min(value=1L)
    private @Min(value=1L) Integer memory;
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Column(name="launcher_ext", columnDefinition="TEXT DEFAULT NULL")
    @Convert(converter=JsonAttributeConverter.class)
    private JsonNode launcherExt;
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="commands_configs", joinColumns={@JoinColumn(name="command_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> configs = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="commands_dependencies", joinColumns={@JoinColumn(name="command_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="file_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<FileEntity> dependencies = new HashSet<FileEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="commands_tags", joinColumns={@JoinColumn(name="command_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="tag_id", referencedColumnName="id", nullable=false, updatable=false)})
    private Set<TagEntity> tags = new HashSet<TagEntity>();
    @ManyToMany(fetch=FetchType.LAZY)
    @JoinTable(name="commands_applications", joinColumns={@JoinColumn(name="command_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="application_id", referencedColumnName="id", nullable=false, updatable=false)})
    @OrderColumn(name="application_order", nullable=false)
    private List<ApplicationEntity> applications = new ArrayList<ApplicationEntity>();
    @ManyToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL})
    @JoinTable(name="commands_cluster_criteria", joinColumns={@JoinColumn(name="command_id", referencedColumnName="id", nullable=false, updatable=false)}, inverseJoinColumns={@JoinColumn(name="criterion_id", referencedColumnName="id", nullable=false, updatable=false)})
    @OrderColumn(name="priority_order", nullable=false)
    private List<CriterionEntity> clusterCriteria = new ArrayList<CriterionEntity>();

    public void setExecutable(@NotEmpty List<@NotBlank @Size(max=1024) String> executable) {
        this.executable.clear();
        this.executable.addAll(executable);
    }

    public void setConfigs(@Nullable Set<FileEntity> configs) {
        this.configs.clear();
        if (configs != null) {
            this.configs.addAll(configs);
        }
    }

    public void setDependencies(@Nullable Set<FileEntity> dependencies) {
        this.dependencies.clear();
        if (dependencies != null) {
            this.dependencies.addAll(dependencies);
        }
    }

    public void setTags(@Nullable Set<TagEntity> tags) {
        this.tags.clear();
        if (tags != null) {
            this.tags.addAll(tags);
        }
    }

    public Optional<Integer> getMemory() {
        return Optional.ofNullable(this.memory);
    }

    public Optional<JsonNode> getLauncherExt() {
        return Optional.ofNullable(this.launcherExt);
    }

    public void setLauncherExt(@Nullable JsonNode launcherExt) {
        this.launcherExt = launcherExt;
    }

    public void setApplications(@Nullable List<ApplicationEntity> applications) throws PreconditionFailedException {
        if (applications != null && applications.stream().map(UniqueIdEntity::getUniqueId).distinct().count() != (long)applications.size()) {
            throw new PreconditionFailedException("List of applications to set cannot contain duplicates");
        }
        for (ApplicationEntity application : this.applications) {
            application.getCommands().remove(this);
        }
        this.applications.clear();
        if (applications != null) {
            this.applications.addAll(applications);
            for (ApplicationEntity application : this.applications) {
                application.getCommands().add(this);
            }
        }
    }

    public void addApplication(@NotNull ApplicationEntity application) throws PreconditionFailedException {
        if (this.applications.contains(application)) {
            throw new PreconditionFailedException("An application with id " + application.getUniqueId() + " is already added");
        }
        this.applications.add(application);
        application.getCommands().add(this);
    }

    public void removeApplication(@NotNull ApplicationEntity application) {
        this.applications.remove(application);
        application.getCommands().remove(this);
    }

    public void setClusterCriteria(@Nullable List<CriterionEntity> clusterCriteria) {
        this.clusterCriteria.clear();
        if (clusterCriteria != null) {
            this.clusterCriteria.addAll(clusterCriteria);
        }
    }

    public void addClusterCriterion(CriterionEntity criterion) {
        this.clusterCriteria.add(criterion);
    }

    public void addClusterCriterion(CriterionEntity criterion, int priority) {
        if (priority <= 0) {
            this.clusterCriteria.add(0, criterion);
        } else if (priority >= this.clusterCriteria.size()) {
            this.clusterCriteria.add(criterion);
        } else {
            this.clusterCriteria.add(priority, criterion);
        }
    }

    public CriterionEntity removeClusterCriterion(int priority) throws IllegalArgumentException {
        if (priority < 0 || priority >= this.clusterCriteria.size()) {
            throw new IllegalArgumentException("The priority of the cluster criterion to remove must be 0<= priority < " + this.clusterCriteria.size() + " for this command currently.");
        }
        return this.clusterCriteria.remove(priority);
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public List<@NotBlank @Size(max=1024) String> getExecutable() {
        return this.executable;
    }

    public long getCheckDelay() {
        return this.checkDelay;
    }

    public Set<FileEntity> getConfigs() {
        return this.configs;
    }

    public Set<FileEntity> getDependencies() {
        return this.dependencies;
    }

    public Set<TagEntity> getTags() {
        return this.tags;
    }

    public List<ApplicationEntity> getApplications() {
        return this.applications;
    }

    public List<CriterionEntity> getClusterCriteria() {
        return this.clusterCriteria;
    }

    public void setCheckDelay(long checkDelay) {
        this.checkDelay = checkDelay;
    }

    public void setMemory(Integer memory) {
        this.memory = memory;
    }

    @Override
    public String toString() {
        return "CommandEntity(super=" + super.toString() + ", executable=" + this.executable + ", checkDelay=" + this.checkDelay + ", memory=" + this.memory + ")";
    }
}

