/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.scripts;

import com.google.common.collect.ImmutableMap;
import com.netflix.genie.common.external.dtos.v4.Cluster;
import com.netflix.genie.common.external.dtos.v4.Command;
import com.netflix.genie.web.selectors.AgentLauncherSelectionContext;
import com.netflix.genie.web.selectors.ClusterSelectionContext;
import com.netflix.genie.web.selectors.CommandSelectionContext;
import groovy.lang.Binding;
import java.util.Map;
import java.util.Set;

public final class GroovyScriptUtils {
    private static final Map<String, String> EMPTY_PROPERTIES_MAP = ImmutableMap.of();

    private GroovyScriptUtils() {
    }

    public static CommandSelectionContext getCommandSelectionContext(Binding binding) throws IllegalArgumentException {
        return GroovyScriptUtils.getObjectVariable(binding, "contextParameter", CommandSelectionContext.class);
    }

    public static ClusterSelectionContext getClusterSelectionContext(Binding binding) throws IllegalArgumentException {
        return GroovyScriptUtils.getObjectVariable(binding, "contextParameter", ClusterSelectionContext.class);
    }

    public static AgentLauncherSelectionContext getAgentLauncherSelectionContext(Binding binding) throws IllegalArgumentException {
        return GroovyScriptUtils.getObjectVariable(binding, "contextParameter", AgentLauncherSelectionContext.class);
    }

    public static Map<String, String> getProperties(Binding binding) {
        try {
            if (binding.hasVariable("propertiesMap")) {
                return (Map)binding.getVariable("propertiesMap");
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        return EMPTY_PROPERTIES_MAP;
    }

    @Deprecated
    public static Set<Cluster> getClusters(Binding binding) throws IllegalArgumentException {
        return GroovyScriptUtils.getSetVariable(binding, "clustersParameter", Cluster.class);
    }

    @Deprecated
    public static Set<Command> getCommands(Binding binding) throws IllegalArgumentException {
        return GroovyScriptUtils.getSetVariable(binding, "commandsParameter", Command.class);
    }

    private static <R> R getObjectVariable(Binding binding, String variableName, Class<R> expectedType) {
        if (!binding.hasVariable(variableName) || !binding.getVariable(variableName).getClass().isAssignableFrom(expectedType)) {
            throw new IllegalArgumentException(variableName + " argument not instance of " + expectedType.getName());
        }
        return (R)binding.getVariable(variableName);
    }

    private static <R> Set<R> getSetVariable(Binding binding, String bindingName, Class<R> expectedType) {
        Set set;
        block5: {
            block4: {
                if (!binding.hasVariable(bindingName) || !(binding.getVariable(bindingName) instanceof Set)) {
                    throw new IllegalArgumentException("Expected " + bindingName + " to be instance of Set<" + expectedType.getName() + ">");
                }
                set = (Set)binding.getVariable(bindingName);
                if (set.isEmpty()) break block4;
                if (set.stream().allMatch(expectedType::isInstance)) break block5;
            }
            throw new IllegalArgumentException("Expected " + bindingName + " to be non-empty set of " + expectedType.getName());
        }
        return set;
    }
}

