/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.spring.autoconfigure.selectors;

import com.netflix.genie.web.agent.launchers.AgentLauncher;
import com.netflix.genie.web.scripts.AgentLauncherSelectorManagedScript;
import com.netflix.genie.web.scripts.ClusterSelectorManagedScript;
import com.netflix.genie.web.scripts.CommandSelectorManagedScript;
import com.netflix.genie.web.selectors.AgentLauncherSelector;
import com.netflix.genie.web.selectors.CommandSelector;
import com.netflix.genie.web.selectors.impl.RandomAgentLauncherSelectorImpl;
import com.netflix.genie.web.selectors.impl.RandomClusterSelectorImpl;
import com.netflix.genie.web.selectors.impl.RandomCommandSelectorImpl;
import com.netflix.genie.web.selectors.impl.ScriptAgentLauncherSelectorImpl;
import com.netflix.genie.web.selectors.impl.ScriptClusterSelectorImpl;
import com.netflix.genie.web.selectors.impl.ScriptCommandSelectorImpl;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.Collection;
import java.util.Optional;
import javax.validation.constraints.NotEmpty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
public class SelectorsAutoConfiguration {
    public static final int SCRIPT_CLUSTER_SELECTOR_PRECEDENCE = 2147483597;

    @Bean
    @Order(value=2147483597)
    @ConditionalOnBean(value={ClusterSelectorManagedScript.class})
    public ScriptClusterSelectorImpl scriptClusterSelector(ClusterSelectorManagedScript clusterSelectorManagedScript, MeterRegistry registry) {
        return new ScriptClusterSelectorImpl(clusterSelectorManagedScript, registry);
    }

    @Bean
    @Order
    public RandomClusterSelectorImpl randomizedClusterSelector() {
        return new RandomClusterSelectorImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={CommandSelector.class})
    public CommandSelector commandSelector(Optional<CommandSelectorManagedScript> commandSelectorManagedScriptOptional, MeterRegistry registry) {
        if (commandSelectorManagedScriptOptional.isPresent()) {
            return new ScriptCommandSelectorImpl(commandSelectorManagedScriptOptional.get(), registry);
        }
        return new RandomCommandSelectorImpl();
    }

    @Bean
    @ConditionalOnMissingBean(value={AgentLauncherSelector.class})
    public AgentLauncherSelector agentLauncherSelector(Optional<AgentLauncherSelectorManagedScript> agentLauncherSelectorManagedScript, @NotEmpty Collection<AgentLauncher> agentLaunchers, MeterRegistry registry) {
        if (agentLauncherSelectorManagedScript.isPresent()) {
            return new ScriptAgentLauncherSelectorImpl(agentLauncherSelectorManagedScript.get(), agentLaunchers, registry);
        }
        return new RandomAgentLauncherSelectorImpl(agentLaunchers);
    }
}

