/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.inspectors.impl;

import com.netflix.genie.common.internal.dtos.AgentClientMetadata;
import com.netflix.genie.web.agent.inspectors.AgentMetadataInspector;
import com.netflix.genie.web.agent.inspectors.InspectionReport;
import javax.validation.Valid;
import org.springframework.core.env.Environment;

public class RejectAllJobsAgentMetadataInspector
implements AgentMetadataInspector {
    private static final String JOB_SUBMISSION_IS_ENABLED_MESSAGE = "Job submission is enabled";
    private Environment environment;

    public RejectAllJobsAgentMetadataInspector(Environment environment) {
        this.environment = environment;
    }

    @Override
    public InspectionReport inspect(@Valid AgentClientMetadata agentClientMetadata) {
        boolean jobSubmissionEnabled = (Boolean)this.environment.getProperty("genie.jobs.submission.enabled", Boolean.class, (Object)true);
        if (jobSubmissionEnabled) {
            return new InspectionReport(InspectionReport.Decision.ACCEPT, JOB_SUBMISSION_IS_ENABLED_MESSAGE);
        }
        String message = (String)this.environment.getProperty("genie.jobs.submission.disabledMessage", String.class, (Object)"Job submission is currently disabled. Please try again later.");
        return new InspectionReport(InspectionReport.Decision.REJECT, message);
    }
}

