/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.agent.services.impl;

import com.netflix.genie.common.internal.dtos.AgentClientMetadata;
import com.netflix.genie.web.agent.inspectors.AgentMetadataInspector;
import com.netflix.genie.web.agent.inspectors.InspectionReport;
import com.netflix.genie.web.agent.services.AgentFilterService;
import java.util.List;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentFilterServiceImpl
implements AgentFilterService {
    private static final Logger log = LoggerFactory.getLogger(AgentFilterServiceImpl.class);
    private final List<AgentMetadataInspector> agentMetadataInspectorList;

    public AgentFilterServiceImpl(List<AgentMetadataInspector> agentMetadataInspectorList) {
        this.agentMetadataInspectorList = agentMetadataInspectorList;
    }

    @Override
    public InspectionReport inspectAgentMetadata(@Valid AgentClientMetadata agentClientMetadata) {
        for (AgentMetadataInspector agentMetadataInspector : this.agentMetadataInspectorList) {
            InspectionReport inspectionReport = agentMetadataInspector.inspect(agentClientMetadata);
            InspectionReport.Decision decision = inspectionReport.getDecision();
            String message = inspectionReport.getMessage();
            log.debug("Inspector: {} inspected: {}, decision: {} ({})", new Object[]{agentMetadataInspector.getClass().getSimpleName(), agentClientMetadata, decision.name(), message});
            if (decision != InspectionReport.Decision.REJECT) continue;
            return InspectionReport.newRejection("Rejected by: " + agentMetadataInspector.getClass().getSimpleName() + ": " + message);
        }
        return InspectionReport.newAcceptance("All inspections passed");
    }
}

