/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.apis.rest.v3.controllers;

import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.JsonPatchException;
import com.google.common.collect.Lists;
import com.netflix.genie.common.dto.ClusterStatus;
import com.netflix.genie.common.dto.Command;
import com.netflix.genie.common.exceptions.GenieException;
import com.netflix.genie.common.exceptions.GenieServerException;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.dtos.Cluster;
import com.netflix.genie.common.internal.dtos.converters.DtoConverters;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.ClusterModelAssembler;
import com.netflix.genie.web.apis.rest.v3.hateoas.assemblers.EntityModelAssemblers;
import com.netflix.genie.web.data.services.DataServices;
import com.netflix.genie.web.data.services.PersistenceService;
import com.netflix.genie.web.exceptions.checked.IdAlreadyExistsException;
import com.netflix.genie.web.exceptions.checked.NotFoundException;
import com.netflix.genie.web.exceptions.checked.PreconditionFailedException;
import java.io.IOException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.web.PageableDefault;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.EntityModel;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.PagedModel;
import org.springframework.hateoas.server.RepresentationModelAssembler;
import org.springframework.hateoas.server.mvc.WebMvcLinkBuilder;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.support.ServletUriComponentsBuilder;

@RestController
@RequestMapping(value={"/api/v3/clusters"})
public class ClusterRestController {
    private static final Logger log = LoggerFactory.getLogger(ClusterRestController.class);
    private static final List<EntityModel<Command>> EMPTY_COMMAND_LIST = new ArrayList<EntityModel<Command>>(0);
    private final PersistenceService persistenceService;
    private final ClusterModelAssembler clusterModelAssembler;

    @Autowired
    public ClusterRestController(DataServices dataServices, EntityModelAssemblers entityModelAssemblers) {
        this.persistenceService = dataServices.getPersistenceService();
        this.clusterModelAssembler = entityModelAssemblers.getClusterModelAssembler();
    }

    @PostMapping(consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.CREATED)
    public ResponseEntity<Void> createCluster(@RequestBody @Valid com.netflix.genie.common.dto.Cluster cluster) throws IdAlreadyExistsException {
        log.info("[createCluster] Called to create new cluster {}", (Object)cluster);
        String id = this.persistenceService.saveCluster(DtoConverters.toV4ClusterRequest((com.netflix.genie.common.dto.Cluster)cluster));
        HttpHeaders httpHeaders = new HttpHeaders();
        httpHeaders.setLocation(ServletUriComponentsBuilder.fromCurrentRequest().path("/{id}").buildAndExpand(new Object[]{id}).toUri());
        return new ResponseEntity((MultiValueMap)httpHeaders, HttpStatus.CREATED);
    }

    @GetMapping(value={"/{id}"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public EntityModel<com.netflix.genie.common.dto.Cluster> getCluster(@PathVariable(value="id") String id) throws NotFoundException {
        log.info("[getCluster] Called with id: {}", (Object)id);
        return this.clusterModelAssembler.toModel(DtoConverters.toV3Cluster((Cluster)this.persistenceService.getCluster(id)));
    }

    @GetMapping(produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public PagedModel<EntityModel<com.netflix.genie.common.dto.Cluster>> getClusters(@RequestParam(value="name", required=false) @Nullable String name, @RequestParam(value="status", required=false) @Nullable Set<String> statuses, @RequestParam(value="tag", required=false) @Nullable Set<String> tags, @RequestParam(value="minUpdateTime", required=false) @Nullable Long minUpdateTime, @RequestParam(value="maxUpdateTime", required=false) @Nullable Long maxUpdateTime, @PageableDefault(size=64, sort={"updated"}, direction=Sort.Direction.DESC) Pageable page, PagedResourcesAssembler<com.netflix.genie.common.dto.Cluster> assembler) throws GenieException {
        Page clusters;
        log.info("[getClusters] Called to find clusters [name | statuses | tags | minUpdateTime | maxUpdateTime | page]\n{} | {} | {} | {} | {} | {}", new Object[]{name, statuses, tags, minUpdateTime, maxUpdateTime, page});
        EnumSet<com.netflix.genie.common.internal.dtos.ClusterStatus> enumStatuses = null;
        if (statuses != null) {
            enumStatuses = EnumSet.noneOf(com.netflix.genie.common.internal.dtos.ClusterStatus.class);
            for (String status : statuses) {
                enumStatuses.add(DtoConverters.toV4ClusterStatus((ClusterStatus)ClusterStatus.parse((String)status)));
            }
        }
        if (tags != null && tags.stream().filter(tag -> tag.startsWith("genie.id:")).count() >= 1L) {
            ArrayList clusterList = Lists.newArrayList();
            int prefixLength = "genie.id:".length();
            tags.stream().filter(tag -> tag.startsWith("genie.id:")).forEach(tag -> {
                String id = tag.substring(prefixLength);
                try {
                    clusterList.add(DtoConverters.toV3Cluster((Cluster)this.persistenceService.getCluster(id)));
                }
                catch (NotFoundException ge) {
                    log.debug("No cluster with id {} found", (Object)id, (Object)ge);
                }
            });
            clusters = new PageImpl((List)clusterList);
        } else if (tags != null && tags.stream().anyMatch(tag -> tag.startsWith("genie.name:"))) {
            Set<String> finalTags = tags.stream().filter(tag -> !tag.startsWith("genie.name:")).collect(Collectors.toSet());
            if (name == null) {
                Optional<String> finalName = tags.stream().filter(tag -> tag.startsWith("genie.name:")).map(tag -> tag.substring("genie.name:".length())).findFirst();
                clusters = this.persistenceService.findClusters(finalName.orElse(null), enumStatuses, finalTags, minUpdateTime == null ? null : Instant.ofEpochMilli(minUpdateTime), maxUpdateTime == null ? null : Instant.ofEpochMilli(maxUpdateTime), page).map(DtoConverters::toV3Cluster);
            } else {
                clusters = this.persistenceService.findClusters(name, enumStatuses, finalTags, minUpdateTime == null ? null : Instant.ofEpochMilli(minUpdateTime), maxUpdateTime == null ? null : Instant.ofEpochMilli(maxUpdateTime), page).map(DtoConverters::toV3Cluster);
            }
        } else {
            clusters = this.persistenceService.findClusters(name, enumStatuses, tags, minUpdateTime == null ? null : Instant.ofEpochMilli(minUpdateTime), maxUpdateTime == null ? null : Instant.ofEpochMilli(maxUpdateTime), page).map(DtoConverters::toV3Cluster);
        }
        Link self = WebMvcLinkBuilder.linkTo(((ClusterRestController)WebMvcLinkBuilder.methodOn(ClusterRestController.class, (Object[])new Object[0])).getClusters(name, statuses, tags, minUpdateTime, maxUpdateTime, page, assembler)).withSelfRel();
        return assembler.toModel(clusters, (RepresentationModelAssembler)this.clusterModelAssembler, self);
    }

    @PutMapping(value={"/{id}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateCluster(@PathVariable(value="id") String id, @RequestBody com.netflix.genie.common.dto.Cluster updateCluster) throws NotFoundException, PreconditionFailedException {
        log.info("[updateCluster] Called with id {} update fields {}", (Object)id, (Object)updateCluster);
        this.persistenceService.updateCluster(id, DtoConverters.toV4Cluster((com.netflix.genie.common.dto.Cluster)updateCluster));
    }

    @PatchMapping(value={"/{id}"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void patchCluster(@PathVariable(value="id") String id, @RequestBody JsonPatch patch) throws NotFoundException, PreconditionFailedException, GenieServerException {
        log.info("[patchCluster] Called with id {} with patch {}", (Object)id, (Object)patch);
        com.netflix.genie.common.dto.Cluster currentCluster = DtoConverters.toV3Cluster((Cluster)this.persistenceService.getCluster(id));
        try {
            log.debug("Will patch cluster {}. Original state: {}", (Object)id, (Object)currentCluster);
            JsonNode clusterNode = GenieObjectMapper.getMapper().valueToTree((Object)currentCluster);
            JsonNode postPatchNode = patch.apply(clusterNode);
            com.netflix.genie.common.dto.Cluster patchedCluster = (com.netflix.genie.common.dto.Cluster)GenieObjectMapper.getMapper().treeToValue((TreeNode)postPatchNode, com.netflix.genie.common.dto.Cluster.class);
            log.debug("Finished patching cluster {}. New state: {}", (Object)id, (Object)patchedCluster);
            this.persistenceService.updateCluster(id, DtoConverters.toV4Cluster((com.netflix.genie.common.dto.Cluster)patchedCluster));
        }
        catch (JsonPatchException | IOException e) {
            log.error("Unable to patch cluster {} with patch {} due to exception.", new Object[]{id, patch, e});
            throw new GenieServerException(e.getLocalizedMessage(), e);
        }
    }

    @DeleteMapping(value={"/{id}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteCluster(@PathVariable(value="id") String id) throws PreconditionFailedException {
        log.info("[deleteCluster] Called for id: {}", (Object)id);
        this.persistenceService.deleteCluster(id);
    }

    @DeleteMapping
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void deleteAllClusters() throws PreconditionFailedException {
        log.warn("[deleteAllClusters] Called");
        this.persistenceService.deleteAllClusters();
    }

    @PostMapping(value={"/{id}/configs"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addConfigsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws NotFoundException {
        log.info("[addConfigsForCluster] Called with id {} and config {}", (Object)id, configs);
        this.persistenceService.addConfigsToResource(id, configs, Cluster.class);
    }

    @GetMapping(value={"/{id}/configs"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getConfigsForCluster(@PathVariable(value="id") String id) throws NotFoundException {
        log.info("[getConfigsForCluster] Called with id {}", (Object)id);
        return this.persistenceService.getConfigsForResource(id, Cluster.class);
    }

    @PutMapping(value={"/{id}/configs"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateConfigsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> configs) throws NotFoundException {
        log.info("[updateConfigsForCluster] Called with id {} and configs {}", (Object)id, configs);
        this.persistenceService.updateConfigsForResource(id, configs, Cluster.class);
    }

    @DeleteMapping(value={"/{id}/configs"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllConfigsForCluster(@PathVariable(value="id") String id) throws NotFoundException {
        log.info("[removeAllConfigsForCluster] Called with id {}", (Object)id);
        this.persistenceService.removeAllConfigsForResource(id, Cluster.class);
    }

    @PostMapping(value={"/{id}/dependencies"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addDependenciesForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> dependencies) throws NotFoundException {
        log.info("[addDependenciesForCluster] Called with id {} and dependencies {}", (Object)id, dependencies);
        this.persistenceService.addDependenciesToResource(id, dependencies, Cluster.class);
    }

    @GetMapping(value={"/{id}/dependencies"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getDependenciesForCluster(@PathVariable(value="id") String id) throws NotFoundException {
        log.info("[getDependenciesForCluster] Called with id {}", (Object)id);
        return this.persistenceService.getDependenciesForResource(id, Cluster.class);
    }

    @PutMapping(value={"/{id}/dependencies"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateDependenciesForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> dependencies) throws NotFoundException {
        log.info("[updateDependenciesForCluster] Called with id {} and dependencies {}", (Object)id, dependencies);
        this.persistenceService.updateDependenciesForResource(id, dependencies, Cluster.class);
    }

    @DeleteMapping(value={"/{id}/dependencies"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllDependenciesForCluster(@PathVariable(value="id") String id) throws NotFoundException {
        log.info("[removeAllDependenciesForCluster] Called with id {}", (Object)id);
        this.persistenceService.removeAllDependenciesForResource(id, Cluster.class);
    }

    @PostMapping(value={"/{id}/tags"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addTagsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws NotFoundException {
        log.info("[addTagsForCluster] Called with id {} and tags {}", (Object)id, tags);
        this.persistenceService.addTagsToResource(id, tags, Cluster.class);
    }

    @GetMapping(value={"/{id}/tags"}, produces={"application/json"})
    @ResponseStatus(value=HttpStatus.OK)
    public Set<String> getTagsForCluster(@PathVariable(value="id") String id) throws NotFoundException {
        log.info("[getTagsForCluster] Called with id {}", (Object)id);
        return DtoConverters.toV3Cluster((Cluster)this.persistenceService.getCluster(id)).getTags();
    }

    @PutMapping(value={"/{id}/tags"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void updateTagsForCluster(@PathVariable(value="id") String id, @RequestBody Set<String> tags) throws NotFoundException {
        log.info("[updateTagsForCluster] Called with id {} and tags {}", (Object)id, tags);
        this.persistenceService.updateTagsForResource(id, tags, Cluster.class);
    }

    @DeleteMapping(value={"/{id}/tags"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllTagsForCluster(@PathVariable(value="id") String id) throws NotFoundException {
        log.info("[removeAllTagsForCluster] Called with id {}", (Object)id);
        this.persistenceService.removeAllTagsForResource(id, Cluster.class);
    }

    @DeleteMapping(value={"/{id}/tags/{tag}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeTagForCluster(@PathVariable(value="id") String id, @PathVariable(value="tag") String tag) throws NotFoundException {
        log.info("[removeTagForCluster] Called with id {} and tag {}", (Object)id, (Object)tag);
        this.persistenceService.removeTagForResource(id, tag, Cluster.class);
    }

    @PostMapping(value={"/{id}/commands"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void addCommandsForCluster(@PathVariable(value="id") String id, @RequestBody List<String> commandIds) {
        log.info("[addCommandsForCluster] Called with id {} and commandIds {}. No-op.", (Object)id, commandIds);
    }

    @GetMapping(value={"/{id}/commands"}, produces={"application/hal+json"})
    @ResponseStatus(value=HttpStatus.OK)
    public List<EntityModel<Command>> getCommandsForCluster(@PathVariable(value="id") String id, @RequestParam(value="status", required=false) @Nullable Set<String> statuses) throws NotFoundException {
        log.info("[getCommandsForCluster] Called with id {} status {}. No-op.", (Object)id, statuses);
        this.persistenceService.getCluster(id);
        return EMPTY_COMMAND_LIST;
    }

    @PutMapping(value={"/{id}/commands"}, consumes={"application/json"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void setCommandsForCluster(@PathVariable(value="id") String id, @RequestBody List<String> commandIds) {
        log.info("[setCommandsForCluster] Called with id {} and commandIds {}. No-op.", (Object)id, commandIds);
    }

    @DeleteMapping(value={"/{id}/commands"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeAllCommandsForCluster(@PathVariable(value="id") String id) {
        log.info("[removeAllCommandsForCluster] Called with id {}. No-op.", (Object)id);
    }

    @DeleteMapping(value={"/{id}/commands/{commandId}"})
    @ResponseStatus(value=HttpStatus.NO_CONTENT)
    public void removeCommandForCluster(@PathVariable(value="id") String id, @PathVariable(value="commandId") String commandId) {
        log.info("[removeCommandForCluster] Called with id {} and command id {}. No-op.", (Object)id, (Object)commandId);
    }
}

