/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.aspects;

import com.google.common.collect.ImmutableSet;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.health.Health;
import org.springframework.boot.actuate.health.Status;

@Aspect
public class HealthCheckMetricsAspect {
    private static final Logger log = LoggerFactory.getLogger(HealthCheckMetricsAspect.class);
    static final String HEALTH_INDICATOR_TIMER_METRIC_NAME = "genie.health.indicator.timer";
    private static final String HEALTH_INDICATOR_CLASS_TAG_NAME = "healthIndicatorClass";
    private static final String HEALTH_INDICATOR_STATUS_TAG_NAME = "healthIndicatorStatus";
    private final MeterRegistry registry;

    public HealthCheckMetricsAspect(MeterRegistry registry) {
        this.registry = registry;
    }

    @Pointcut(value="target(org.springframework.boot.actuate.health.HealthIndicator+) && execution(org.springframework.boot.actuate.health.Health getHealth(..))")
    public void healthIndicatorGetHealth() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Around(value="healthIndicatorGetHealth()")
    public Health aroundHealthIndicatorGetHealth(ProceedingJoinPoint joinPoint) throws Throwable {
        String healthIndicatorClass = joinPoint.getTarget().getClass().getSimpleName();
        log.debug("Intercepted: {}::{}({})", new Object[]{healthIndicatorClass, joinPoint.getSignature().getName(), Arrays.toString(joinPoint.getArgs())});
        long start = System.nanoTime();
        Health h = null;
        try {
            h = (Health)joinPoint.proceed(joinPoint.getArgs());
        }
        catch (Throwable throwable) {
            long turnaround = System.nanoTime() - start;
            String healthStatus = h != null ? h.getStatus().getCode() : Status.UNKNOWN.getCode();
            log.debug("Indicator {} status: {} (took {}ns)", new Object[]{healthIndicatorClass, healthStatus, turnaround});
            ImmutableSet tags = ImmutableSet.of((Object)Tag.of((String)HEALTH_INDICATOR_CLASS_TAG_NAME, (String)healthIndicatorClass), (Object)Tag.of((String)HEALTH_INDICATOR_STATUS_TAG_NAME, (String)healthStatus));
            this.registry.timer(HEALTH_INDICATOR_TIMER_METRIC_NAME, (Iterable)tags).record(turnaround, TimeUnit.NANOSECONDS);
            throw throwable;
        }
        long turnaround = System.nanoTime() - start;
        String healthStatus = h != null ? h.getStatus().getCode() : Status.UNKNOWN.getCode();
        log.debug("Indicator {} status: {} (took {}ns)", new Object[]{healthIndicatorClass, healthStatus, turnaround});
        ImmutableSet tags = ImmutableSet.of((Object)Tag.of((String)HEALTH_INDICATOR_CLASS_TAG_NAME, (String)healthIndicatorClass), (Object)Tag.of((String)HEALTH_INDICATOR_STATUS_TAG_NAME, (String)healthStatus));
        this.registry.timer(HEALTH_INDICATOR_TIMER_METRIC_NAME, (Iterable)tags).record(turnaround, TimeUnit.NANOSECONDS);
        return h;
    }
}

