/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.converters;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.collect.ImmutableList;
import com.netflix.genie.common.external.util.GenieObjectMapper;
import com.netflix.genie.common.internal.dtos.AgentConfigRequest;
import com.netflix.genie.common.internal.dtos.Application;
import com.netflix.genie.common.internal.dtos.ApplicationMetadata;
import com.netflix.genie.common.internal.dtos.Cluster;
import com.netflix.genie.common.internal.dtos.ClusterMetadata;
import com.netflix.genie.common.internal.dtos.Command;
import com.netflix.genie.common.internal.dtos.CommandMetadata;
import com.netflix.genie.common.internal.dtos.ComputeResources;
import com.netflix.genie.common.internal.dtos.Criterion;
import com.netflix.genie.common.internal.dtos.ExecutionEnvironment;
import com.netflix.genie.common.internal.dtos.ExecutionResourceCriteria;
import com.netflix.genie.common.internal.dtos.FinishedJob;
import com.netflix.genie.common.internal.dtos.Image;
import com.netflix.genie.common.internal.dtos.JobEnvironmentRequest;
import com.netflix.genie.common.internal.dtos.JobMetadata;
import com.netflix.genie.common.internal.dtos.JobRequest;
import com.netflix.genie.common.internal.dtos.JobSpecification;
import com.netflix.genie.common.internal.dtos.converters.DtoConverters;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieClusterNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieCommandNotFoundException;
import com.netflix.genie.common.internal.exceptions.unchecked.GenieRuntimeException;
import com.netflix.genie.web.data.services.impl.jpa.entities.ApplicationEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.ClusterEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CommandEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.CriterionEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.FileEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.FinishedJobProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.JobRequestProjection;
import com.netflix.genie.web.data.services.impl.jpa.queries.projections.v4.JobSpecificationProjection;
import java.io.File;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EntityV4DtoConverters {
    private static final Logger LOG = LoggerFactory.getLogger(EntityV4DtoConverters.class);
    private static final TypeReference<Map<String, Image>> IMAGES_TYPE_REFERENCE = new TypeReference<Map<String, Image>>(){};
    private static final ObjectNode EMPTY_JSON = GenieObjectMapper.getMapper().createObjectNode();

    private EntityV4DtoConverters() {
    }

    public static Application toV4ApplicationDto(ApplicationEntity applicationEntity) throws IllegalArgumentException {
        ApplicationMetadata.Builder metadataBuilder = (ApplicationMetadata.Builder)new ApplicationMetadata.Builder(applicationEntity.getName(), applicationEntity.getUser(), applicationEntity.getVersion(), DtoConverters.toV4ApplicationStatus((String)applicationEntity.getStatus())).withTags(applicationEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        applicationEntity.getType().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withType(arg_0));
        applicationEntity.getDescription().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withDescription(arg_0));
        applicationEntity.getMetadata().ifPresent(arg_0 -> ((ApplicationMetadata.Builder)metadataBuilder).withMetadata(arg_0));
        return new Application(applicationEntity.getUniqueId(), applicationEntity.getCreated(), applicationEntity.getUpdated(), EntityV4DtoConverters.toExecutionEnvironment(applicationEntity.getConfigs(), applicationEntity.getDependencies(), applicationEntity.getSetupFile().orElse(null)), metadataBuilder.build());
    }

    public static Cluster toV4ClusterDto(ClusterEntity clusterEntity) throws IllegalArgumentException {
        ClusterMetadata.Builder metadataBuilder = (ClusterMetadata.Builder)new ClusterMetadata.Builder(clusterEntity.getName(), clusterEntity.getUser(), clusterEntity.getVersion(), DtoConverters.toV4ClusterStatus((String)clusterEntity.getStatus())).withTags(clusterEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        clusterEntity.getDescription().ifPresent(arg_0 -> ((ClusterMetadata.Builder)metadataBuilder).withDescription(arg_0));
        clusterEntity.getMetadata().ifPresent(arg_0 -> ((ClusterMetadata.Builder)metadataBuilder).withMetadata(arg_0));
        return new Cluster(clusterEntity.getUniqueId(), clusterEntity.getCreated(), clusterEntity.getUpdated(), EntityV4DtoConverters.toExecutionEnvironment(clusterEntity.getConfigs(), clusterEntity.getDependencies(), clusterEntity.getSetupFile().orElse(null)), metadataBuilder.build());
    }

    public static Command toV4CommandDto(CommandEntity commandEntity) throws IllegalArgumentException {
        CommandMetadata.Builder metadataBuilder = (CommandMetadata.Builder)new CommandMetadata.Builder(commandEntity.getName(), commandEntity.getUser(), commandEntity.getVersion(), DtoConverters.toV4CommandStatus((String)commandEntity.getStatus())).withTags(commandEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        commandEntity.getDescription().ifPresent(arg_0 -> ((CommandMetadata.Builder)metadataBuilder).withDescription(arg_0));
        commandEntity.getMetadata().ifPresent(arg_0 -> ((CommandMetadata.Builder)metadataBuilder).withMetadata(arg_0));
        return new Command(commandEntity.getUniqueId(), commandEntity.getCreated(), commandEntity.getUpdated(), EntityV4DtoConverters.toExecutionEnvironment(commandEntity.getConfigs(), commandEntity.getDependencies(), commandEntity.getSetupFile().orElse(null)), metadataBuilder.build(), commandEntity.getExecutable(), commandEntity.getClusterCriteria().stream().map(EntityV4DtoConverters::toCriterionDto).collect(Collectors.toList()), EntityV4DtoConverters.toComputeResources(commandEntity::getCpu, commandEntity::getGpu, commandEntity::getMemory, commandEntity::getDiskMb, commandEntity::getNetworkMbps), EntityV4DtoConverters.toImages(commandEntity::getImages));
    }

    public static JobRequest toV4JobRequestDto(JobRequestProjection jobRequestProjection) {
        String requestedId = jobRequestProjection.isRequestedId() ? jobRequestProjection.getUniqueId() : null;
        JobMetadata.Builder jobMetadataBuilder = new JobMetadata.Builder(jobRequestProjection.getName(), jobRequestProjection.getUser(), jobRequestProjection.getVersion());
        jobRequestProjection.getGenieUserGroup().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withGroup(arg_0));
        jobRequestProjection.getEmail().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withEmail(arg_0));
        jobRequestProjection.getGrouping().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withGrouping(arg_0));
        jobRequestProjection.getGroupingInstance().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withGroupingInstance(arg_0));
        jobRequestProjection.getDescription().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withDescription(arg_0));
        jobMetadataBuilder.withTags(jobRequestProjection.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        jobRequestProjection.getMetadata().ifPresent(arg_0 -> ((JobMetadata.Builder)jobMetadataBuilder).withMetadata(arg_0));
        ImmutableList.Builder clusterCriteria = ImmutableList.builder();
        for (CriterionEntity criterionEntity : jobRequestProjection.getClusterCriteria()) {
            clusterCriteria.add((Object)EntityV4DtoConverters.toCriterionDto(criterionEntity));
        }
        Criterion commandCriterion = EntityV4DtoConverters.toCriterionDto(jobRequestProjection.getCommandCriterion());
        ExecutionResourceCriteria executionResourceCriteria = new ExecutionResourceCriteria((List)clusterCriteria.build(), commandCriterion, jobRequestProjection.getRequestedApplications());
        ExecutionEnvironment jobResources = EntityV4DtoConverters.toExecutionEnvironment(jobRequestProjection.getConfigs(), jobRequestProjection.getDependencies(), jobRequestProjection.getSetupFile().orElse(null));
        AgentConfigRequest.Builder agentConfigRequestBuilder = new AgentConfigRequest.Builder();
        jobRequestProjection.getRequestedAgentConfigExt().ifPresent(arg_0 -> ((AgentConfigRequest.Builder)agentConfigRequestBuilder).withExt(arg_0));
        jobRequestProjection.getRequestedJobDirectoryLocation().ifPresent(arg_0 -> ((AgentConfigRequest.Builder)agentConfigRequestBuilder).withRequestedJobDirectoryLocation(arg_0));
        agentConfigRequestBuilder.withInteractive(jobRequestProjection.isInteractive());
        agentConfigRequestBuilder.withArchivingDisabled(jobRequestProjection.isArchivingDisabled());
        jobRequestProjection.getRequestedTimeout().ifPresent(arg_0 -> ((AgentConfigRequest.Builder)agentConfigRequestBuilder).withTimeoutRequested(arg_0));
        JobEnvironmentRequest.Builder jobEnvironmentRequestBuilder = new JobEnvironmentRequest.Builder();
        jobRequestProjection.getRequestedAgentEnvironmentExt().ifPresent(arg_0 -> ((JobEnvironmentRequest.Builder)jobEnvironmentRequestBuilder).withExt(arg_0));
        jobEnvironmentRequestBuilder.withRequestedEnvironmentVariables(jobRequestProjection.getRequestedEnvironmentVariables());
        jobEnvironmentRequestBuilder.withRequestedComputeResources(EntityV4DtoConverters.toComputeResources(jobRequestProjection::getRequestedCpu, jobRequestProjection::getRequestedGpu, jobRequestProjection::getRequestedMemory, jobRequestProjection::getRequestedDiskMb, jobRequestProjection::getRequestedNetworkMbps));
        jobEnvironmentRequestBuilder.withRequestedImages(EntityV4DtoConverters.toImages(jobRequestProjection::getRequestedImages));
        return new JobRequest(requestedId, jobResources, jobRequestProjection.getCommandArgs(), jobMetadataBuilder.build(), executionResourceCriteria, jobEnvironmentRequestBuilder.build(), agentConfigRequestBuilder.build());
    }

    public static Criterion toCriterionDto(CriterionEntity criterionEntity) {
        Criterion.Builder builder = new Criterion.Builder();
        criterionEntity.getUniqueId().ifPresent(arg_0 -> ((Criterion.Builder)builder).withId(arg_0));
        criterionEntity.getName().ifPresent(arg_0 -> ((Criterion.Builder)builder).withName(arg_0));
        criterionEntity.getVersion().ifPresent(arg_0 -> ((Criterion.Builder)builder).withVersion(arg_0));
        criterionEntity.getStatus().ifPresent(arg_0 -> ((Criterion.Builder)builder).withStatus(arg_0));
        builder.withTags(criterionEntity.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        try {
            return builder.build();
        }
        catch (IllegalArgumentException iae) {
            LOG.error("Creating a Criterion DTO from a Criterion entity threw exception", (Throwable)iae);
            throw new GenieRuntimeException((Throwable)iae);
        }
    }

    public static FinishedJob toFinishedJobDto(FinishedJobProjection finishedJobProjection) throws IllegalArgumentException {
        FinishedJob.Builder builder = new FinishedJob.Builder(finishedJobProjection.getUniqueId(), finishedJobProjection.getName(), finishedJobProjection.getUser(), finishedJobProjection.getVersion(), finishedJobProjection.getCreated(), DtoConverters.toV4JobStatus((String)finishedJobProjection.getStatus()), finishedJobProjection.getCommandArgs(), EntityV4DtoConverters.toCriterionDto(finishedJobProjection.getCommandCriterion()), finishedJobProjection.getClusterCriteria().stream().map(EntityV4DtoConverters::toCriterionDto).collect(Collectors.toList()));
        finishedJobProjection.getStarted().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withStarted(arg_0));
        finishedJobProjection.getFinished().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withFinished(arg_0));
        finishedJobProjection.getDescription().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withDescription(arg_0));
        finishedJobProjection.getGrouping().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withGrouping(arg_0));
        finishedJobProjection.getGroupingInstance().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withGroupingInstance(arg_0));
        finishedJobProjection.getStatusMsg().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withStatusMessage(arg_0));
        finishedJobProjection.getRequestedMemory().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withRequestedMemory(arg_0));
        finishedJobProjection.getRequestApiClientHostname().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withRequestApiClientHostname(arg_0));
        finishedJobProjection.getRequestApiClientUserAgent().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withRequestApiClientUserAgent(arg_0));
        finishedJobProjection.getRequestAgentClientHostname().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withRequestAgentClientHostname(arg_0));
        finishedJobProjection.getRequestAgentClientVersion().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withRequestAgentClientVersion(arg_0));
        finishedJobProjection.getNumAttachments().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withNumAttachments(arg_0));
        finishedJobProjection.getExitCode().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withExitCode(arg_0));
        finishedJobProjection.getArchiveLocation().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withArchiveLocation(arg_0));
        finishedJobProjection.getMemoryUsed().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withMemoryUsed(arg_0));
        builder.withTags(finishedJobProjection.getTags().stream().map(TagEntity::getTag).collect(Collectors.toSet()));
        finishedJobProjection.getMetadata().ifPresent(arg_0 -> ((FinishedJob.Builder)builder).withMetadata(arg_0));
        finishedJobProjection.getCommand().ifPresent(commandEntity -> builder.withCommand(EntityV4DtoConverters.toV4CommandDto(commandEntity)));
        finishedJobProjection.getCluster().ifPresent(clusterEntity -> builder.withCluster(EntityV4DtoConverters.toV4ClusterDto(clusterEntity)));
        builder.withApplications(finishedJobProjection.getApplications().stream().map(EntityV4DtoConverters::toV4ApplicationDto).collect(Collectors.toList()));
        return builder.build();
    }

    public static JobSpecification toJobSpecificationDto(JobSpecificationProjection jobSpecificationProjection) {
        String id = jobSpecificationProjection.getUniqueId();
        ClusterEntity clusterEntity = jobSpecificationProjection.getCluster().orElseThrow(() -> new GenieClusterNotFoundException("No cluster found for job " + id + ". Was expected to exist."));
        CommandEntity commandEntity = jobSpecificationProjection.getCommand().orElseThrow(() -> new GenieCommandNotFoundException("No command found for job " + id + ". Was expected to exist."));
        File jobDirectoryLocation = jobSpecificationProjection.getJobDirectoryLocation().map(File::new).orElseThrow(() -> new GenieRuntimeException("No job directory location available for job " + id + ". Was expected to exist"));
        String archiveLocation = jobSpecificationProjection.getArchiveLocation().orElse(null);
        JobSpecification.ExecutionResource job = EntityV4DtoConverters.toExecutionResource(id, jobSpecificationProjection.getConfigs(), jobSpecificationProjection.getDependencies(), jobSpecificationProjection.getSetupFile().orElse(null));
        JobSpecification.ExecutionResource cluster = EntityV4DtoConverters.toExecutionResource(clusterEntity.getUniqueId(), clusterEntity.getConfigs(), clusterEntity.getDependencies(), clusterEntity.getSetupFile().orElse(null));
        JobSpecification.ExecutionResource command = EntityV4DtoConverters.toExecutionResource(commandEntity.getUniqueId(), commandEntity.getConfigs(), commandEntity.getDependencies(), commandEntity.getSetupFile().orElse(null));
        List applications = jobSpecificationProjection.getApplications().stream().map(applicationEntity -> EntityV4DtoConverters.toExecutionResource(applicationEntity.getUniqueId(), applicationEntity.getConfigs(), applicationEntity.getDependencies(), applicationEntity.getSetupFile().orElse(null))).collect(Collectors.toList());
        return new JobSpecification(commandEntity.getExecutable(), jobSpecificationProjection.getCommandArgs(), job, cluster, command, applications, jobSpecificationProjection.getEnvironmentVariables(), jobSpecificationProjection.isInteractive(), jobDirectoryLocation, archiveLocation, (Integer)jobSpecificationProjection.getTimeoutUsed().orElse(null));
    }

    private static JobSpecification.ExecutionResource toExecutionResource(String id, Set<FileEntity> configs, Set<FileEntity> dependencies, @Nullable FileEntity setupFile) {
        return new JobSpecification.ExecutionResource(id, EntityV4DtoConverters.toExecutionEnvironment(configs, dependencies, setupFile));
    }

    private static ExecutionEnvironment toExecutionEnvironment(Set<FileEntity> configs, Set<FileEntity> dependencies, @Nullable FileEntity setupFile) {
        return new ExecutionEnvironment(configs.stream().map(FileEntity::getFile).collect(Collectors.toSet()), dependencies.stream().map(FileEntity::getFile).collect(Collectors.toSet()), setupFile != null ? setupFile.getFile() : null);
    }

    private static ComputeResources toComputeResources(Supplier<Optional<Integer>> cpuGetter, Supplier<Optional<Integer>> gpuGetter, Supplier<Optional<Long>> memoryGetter, Supplier<Optional<Long>> diskMbGetter, Supplier<Optional<Long>> networkMbpsGetter) {
        return new ComputeResources.Builder().withCpu((Integer)cpuGetter.get().orElse(null)).withGpu((Integer)gpuGetter.get().orElse(null)).withMemoryMb((Long)memoryGetter.get().orElse(null)).withDiskMb((Long)diskMbGetter.get().orElse(null)).withNetworkMbps((Long)networkMbpsGetter.get().orElse(null)).build();
    }

    private static Map<String, Image> toImages(Supplier<Optional<JsonNode>> imagesGetter) {
        return (Map)GenieObjectMapper.getMapper().convertValue((Object)imagesGetter.get().orElse((JsonNode)EMPTY_JSON), IMAGES_TYPE_REFERENCE);
    }
}

