/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.listeners;

import com.netflix.genie.common.internal.dtos.JobStatus;
import com.netflix.genie.common.internal.dtos.converters.DtoConverters;
import com.netflix.genie.web.data.observers.PersistedJobStatusObserver;
import com.netflix.genie.web.data.services.impl.jpa.entities.JobEntity;
import java.util.Optional;
import javax.persistence.PostLoad;
import javax.persistence.PostUpdate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JobEntityListener {
    private static final Logger log = LoggerFactory.getLogger(JobEntityListener.class);
    private final PersistedJobStatusObserver persistedJobStatusObserver;

    public JobEntityListener(PersistedJobStatusObserver persistedJobStatusObserver) {
        this.persistedJobStatusObserver = persistedJobStatusObserver;
    }

    @PostUpdate
    public void jobUpdate(JobEntity jobEntity) {
        JobStatus previouslyNotifiedState;
        JobStatus currentState;
        try {
            currentState = DtoConverters.toV4JobStatus((String)jobEntity.getStatus());
        }
        catch (IllegalArgumentException e) {
            log.error("Unable to convert current status {} to a valid JobStatus", (Object)jobEntity.getStatus(), (Object)e);
            return;
        }
        Optional<String> pnsOptional = jobEntity.getNotifiedJobStatus();
        if (pnsOptional.isPresent()) {
            try {
                previouslyNotifiedState = DtoConverters.toV4JobStatus((String)pnsOptional.get());
            }
            catch (IllegalArgumentException e) {
                log.error("Unable to convert previously notified status {} to a valid JobStatus", (Object)jobEntity.getStatus(), (Object)e);
                return;
            }
        } else {
            previouslyNotifiedState = null;
        }
        String jobId = jobEntity.getUniqueId();
        if (currentState != previouslyNotifiedState) {
            log.debug("Detected state change for job: {} from: {} to: {}", new Object[]{jobId, previouslyNotifiedState, currentState});
            this.persistedJobStatusObserver.notify(jobId, previouslyNotifiedState, currentState);
            jobEntity.setNotifiedJobStatus(currentState.name());
        }
    }

    @PostLoad
    public void jobLoad(JobEntity jobEntity) {
        jobEntity.setNotifiedJobStatus(jobEntity.getStatus());
    }
}

