/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.data.services.impl.jpa.queries.predicates;

import com.google.common.collect.Lists;
import com.netflix.genie.common.internal.dtos.Criterion;
import com.netflix.genie.web.data.services.impl.jpa.entities.BaseEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.ClusterEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.ClusterEntity_;
import com.netflix.genie.web.data.services.impl.jpa.entities.IdEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.TagEntity;
import com.netflix.genie.web.data.services.impl.jpa.entities.UniqueIdEntity;
import com.netflix.genie.web.data.services.impl.jpa.queries.predicates.PredicateUtils;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nullable;
import javax.persistence.criteria.AbstractQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.SetJoin;
import javax.persistence.criteria.Subquery;
import javax.persistence.metamodel.SingularAttribute;
import org.apache.commons.lang3.StringUtils;

public final class ClusterPredicates {
    private ClusterPredicates() {
    }

    public static Predicate find(Root<ClusterEntity> root, AbstractQuery<?> cq, CriteriaBuilder cb, @Nullable String name, @Nullable Set<String> statuses, @Nullable Set<TagEntity> tags, @Nullable Instant minUpdateTime, @Nullable Instant maxUpdateTime) {
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (StringUtils.isNotBlank((CharSequence)name)) {
            predicates.add(PredicateUtils.getStringLikeOrEqualPredicate(cb, (Expression<String>)root.get(ClusterEntity_.name), name));
        }
        if (minUpdateTime != null) {
            predicates.add(cb.greaterThanOrEqualTo((Expression)root.get(ClusterEntity_.updated), (Comparable)minUpdateTime));
        }
        if (maxUpdateTime != null) {
            predicates.add(cb.lessThan((Expression)root.get(ClusterEntity_.updated), (Comparable)maxUpdateTime));
        }
        if (tags != null && !tags.isEmpty()) {
            SetJoin tagEntityJoin = root.join(ClusterEntity_.tags);
            predicates.add(tagEntityJoin.in(tags));
            cq.groupBy(new Expression[]{root.get(ClusterEntity_.id)});
            cq.having((Expression)cb.equal(cb.count((Expression)root.get(ClusterEntity_.id)), (Object)tags.size()));
        }
        if (statuses != null && !statuses.isEmpty()) {
            predicates.add(cb.or((Predicate[])statuses.stream().map(status -> cb.equal((Expression)root.get(ClusterEntity_.status), status)).toArray(Predicate[]::new)));
        }
        return cb.and(predicates.toArray(new Predicate[0]));
    }

    public static Predicate findClustersMatchingCriterion(Root<ClusterEntity> root, CriteriaQuery<?> cq, CriteriaBuilder cb, Criterion criterion) {
        Subquery criterionSubquery = cq.subquery(Long.class);
        Root criterionSubqueryRoot = criterionSubquery.from(ClusterEntity.class);
        criterionSubquery.select((Expression)criterionSubqueryRoot.get(ClusterEntity_.id));
        criterionSubquery.where((Expression)PredicateUtils.createCriterionPredicate(criterionSubqueryRoot, criterionSubquery, cb, (SingularAttribute<UniqueIdEntity, String>)ClusterEntity_.uniqueId, (SingularAttribute<BaseEntity, String>)ClusterEntity_.name, (SingularAttribute<BaseEntity, String>)ClusterEntity_.version, (SingularAttribute<BaseEntity, String>)ClusterEntity_.status, () -> criterionSubqueryRoot.join(ClusterEntity_.tags, JoinType.INNER), (SingularAttribute<IdEntity, Long>)ClusterEntity_.id, criterion));
        return root.get(ClusterEntity_.id).in(new Expression[]{criterionSubquery});
    }

    public static Predicate findClustersMatchingAnyCriterion(Root<ClusterEntity> root, CriteriaQuery<?> cq, CriteriaBuilder cb, Set<Criterion> criteria) {
        ArrayList predicates = Lists.newArrayList();
        for (Criterion criterion : criteria) {
            predicates.add(ClusterPredicates.findClustersMatchingCriterion(root, cq, cb, criterion));
        }
        return cb.or(predicates.toArray(new Predicate[0]));
    }
}

