/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.jobs.attachments")
@Validated
public class AttachmentServiceProperties {
    public static final String PROPERTY_PREFIX = "genie.jobs.attachments";
    private static final Path SYSTEM_TMP_DIR = Paths.get(System.getProperty("java.io.tmpdir", "/tmp/"), new String[0]);
    @NotNull(message="Attachment location prefix is required")
    private @NotNull(message="Attachment location prefix is required") URI locationPrefix = URI.create("file://" + SYSTEM_TMP_DIR.resolve("genie/attachments"));
    @NotNull(message="Maximum attachment size is required")
    private @NotNull(message="Maximum attachment size is required") DataSize maxSize = DataSize.ofMegabytes((long)100L);
    @NotNull(message="Maximum attachments total size is required")
    private @NotNull(message="Maximum attachments total size is required") DataSize maxTotalSize = DataSize.ofMegabytes((long)150L);

    @NotNull(message="Attachment location prefix is required")
    public @NotNull(message="Attachment location prefix is required") URI getLocationPrefix() {
        return this.locationPrefix;
    }

    @NotNull(message="Maximum attachment size is required")
    public @NotNull(message="Maximum attachment size is required") DataSize getMaxSize() {
        return this.maxSize;
    }

    @NotNull(message="Maximum attachments total size is required")
    public @NotNull(message="Maximum attachments total size is required") DataSize getMaxTotalSize() {
        return this.maxTotalSize;
    }

    public void setLocationPrefix(@NotNull(message="Attachment location prefix is required") @NotNull(message="Attachment location prefix is required") URI locationPrefix) {
        this.locationPrefix = locationPrefix;
    }

    public void setMaxSize(@NotNull(message="Maximum attachment size is required") @NotNull(message="Maximum attachment size is required") DataSize maxSize) {
        this.maxSize = maxSize;
    }

    public void setMaxTotalSize(@NotNull(message="Maximum attachments total size is required") @NotNull(message="Maximum attachments total size is required") DataSize maxTotalSize) {
        this.maxTotalSize = maxTotalSize;
    }
}

