/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import com.netflix.genie.common.internal.dtos.ComputeResources;
import com.netflix.genie.common.internal.dtos.Image;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.core.env.Environment;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.util.unit.DataSize;
import org.springframework.validation.annotation.Validated;

@Validated
public class JobResolutionProperties {
    private static final Logger LOG = LoggerFactory.getLogger(JobResolutionProperties.class);
    private static final String PROPERTY_PREFIX = "genie.services.resolution";
    private static final int MB_TO_MBIT = 8;
    private static final String DEFAULTS_PROPERTY_PREFIX = "genie.services.resolution.defaults";
    private static final String RUNTIME_DEFAULTS_PROPERTY_PREFIX = "genie.services.resolution.defaults.runtime";
    private static final Bindable<Runtime> RUNTIME_BINDABLE = Bindable.of(Runtime.class);
    private final Binder binder;
    private ComputeResources defaultComputeResources;
    private Map<String, Image> defaultImages;

    public JobResolutionProperties(Environment environment) {
        this.binder = Binder.get((Environment)environment);
        this.defaultComputeResources = new ComputeResources.Builder().build();
        this.defaultImages = new HashMap<String, Image>();
        this.refresh();
    }

    public ComputeResources getDefaultComputeResources() {
        return this.defaultComputeResources;
    }

    public Map<String, Image> getDefaultImages() {
        return this.defaultImages;
    }

    @Scheduled(fixedRate=30L, timeUnit=TimeUnit.SECONDS)
    public void refresh() {
        LOG.debug("Refreshing job resolution properties");
        Runtime defaultRuntime = (Runtime)this.binder.bindOrCreate(RUNTIME_DEFAULTS_PROPERTY_PREFIX, RUNTIME_BINDABLE);
        Resources resources = defaultRuntime.getResources();
        this.defaultComputeResources = new ComputeResources.Builder().withCpu(Integer.valueOf(resources.getCpu())).withGpu(Integer.valueOf(resources.getGpu())).withMemoryMb(Long.valueOf(resources.getMemory().toMegabytes())).withDiskMb(Long.valueOf(resources.getDisk().toMegabytes())).withNetworkMbps(Long.valueOf(resources.getNetwork().toMegabytes() * 8L)).build();
        this.defaultImages = defaultRuntime.getImages().entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> {
            DefaultImage defaultImage = (DefaultImage)entry.getValue();
            Image.Builder builder = new Image.Builder();
            defaultImage.getName().ifPresent(arg_0 -> ((Image.Builder)builder).withName(arg_0));
            defaultImage.getTag().ifPresent(arg_0 -> ((Image.Builder)builder).withTag(arg_0));
            builder.withArguments(defaultImage.getArguments());
            return builder.build();
        }));
        LOG.debug("Completed refresh of job resolution properties. New resource values = {}, new image values = {}", (Object)this.defaultComputeResources, this.defaultImages);
    }

    public static class Runtime {
        private Resources resources = new Resources();
        private final Map<String, DefaultImage> images = new HashMap<String, DefaultImage>();

        public Resources getResources() {
            return this.resources;
        }

        public void setResources(@Nullable Resources resources) {
            this.resources = resources == null ? new Resources() : resources;
        }

        public Map<String, DefaultImage> getImages() {
            return this.images;
        }

        public void setImages(@Nullable Map<String, DefaultImage> images) {
            this.images.clear();
            if (images != null) {
                this.images.putAll(images);
            }
        }
    }

    public static class Resources {
        private static final int DEFAULT_CPU = 1;
        private static final int DEFAULT_GPU = 0;
        private static final DataSize DEFAULT_MEMORY = DataSize.ofMegabytes((long)1500L);
        private static final DataSize DEFAULT_DISK = DataSize.ofGigabytes((long)10L);
        private static final DataSize DEFAULT_NETWORK = DataSize.ofMegabytes((long)1250L);
        @Min(value=1L)
        private @Min(value=1L) int cpu = 1;
        @Min(value=0L)
        private @Min(value=0L) int gpu = 0;
        @NotNull
        private DataSize memory = DEFAULT_MEMORY;
        @NotNull
        private DataSize disk = DEFAULT_DISK;
        @NotNull
        private DataSize network = DEFAULT_NETWORK;

        public int getCpu() {
            return this.cpu;
        }

        public void setCpu(@Min(value=1L) @Nullable @Min(value=1L) Integer cpu) {
            this.cpu = cpu == null ? 1 : cpu;
        }

        public int getGpu() {
            return this.gpu;
        }

        public void setGpu(@Min(value=0L) @Nullable @Min(value=0L) Integer gpu) {
            this.gpu = gpu == null ? 0 : gpu;
        }

        public DataSize getMemory() {
            return this.memory;
        }

        public void setMemory(@Nullable DataSize memory) {
            this.memory = memory == null ? DEFAULT_MEMORY : memory;
        }

        public DataSize getDisk() {
            return this.disk;
        }

        public void setDisk(@Nullable DataSize disk) {
            this.disk = disk == null ? DEFAULT_DISK : disk;
        }

        public DataSize getNetwork() {
            return this.network;
        }

        public void setNetwork(@Nullable DataSize network) {
            this.network = network == null ? DEFAULT_NETWORK : network;
        }
    }

    public static class DefaultImage {
        private String name;
        private String tag;
        private final List<String> arguments = new ArrayList<String>();

        public Optional<String> getName() {
            return Optional.ofNullable(this.name);
        }

        public void setName(@Nullable String name) {
            this.name = name;
        }

        public Optional<String> getTag() {
            return Optional.ofNullable(this.tag);
        }

        public void setTag(@Nullable String tag) {
            this.tag = tag;
        }

        public List<String> getArguments() {
            return Collections.unmodifiableList(this.arguments);
        }

        public void setArguments(@Nullable List<String> arguments) {
            this.arguments.clear();
            if (arguments != null) {
                this.arguments.addAll(arguments);
            }
        }
    }
}

