/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.genie.web.properties;

import java.net.URI;
import javax.validation.constraints.NotNull;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.validation.annotation.Validated;

@ConfigurationProperties(prefix="genie.jobs.locations")
@Validated
public class JobsLocationsProperties {
    public static final String PROPERTY_PREFIX = "genie.jobs.locations";
    private static final String SYSTEM_TMP_DIR = System.getProperty("java.io.tmpdir", "/tmp/");
    @NotNull(message="Archives storage location is required")
    private @NotNull(message="Archives storage location is required") URI archives = URI.create("file://" + (String)(SYSTEM_TMP_DIR.endsWith("/") ? SYSTEM_TMP_DIR : SYSTEM_TMP_DIR + "/") + "genie/archives/");
    @NotNull(message="Default job working directory is required")
    private @NotNull(message="Default job working directory is required") URI jobs = URI.create("file://" + (String)(SYSTEM_TMP_DIR.endsWith("/") ? SYSTEM_TMP_DIR : SYSTEM_TMP_DIR + "/") + "genie/jobs/");

    @NotNull(message="Archives storage location is required")
    public @NotNull(message="Archives storage location is required") URI getArchives() {
        return this.archives;
    }

    @NotNull(message="Default job working directory is required")
    public @NotNull(message="Default job working directory is required") URI getJobs() {
        return this.jobs;
    }

    public void setArchives(@NotNull(message="Archives storage location is required") @NotNull(message="Archives storage location is required") URI archives) {
        this.archives = archives;
    }

    public void setJobs(@NotNull(message="Default job working directory is required") @NotNull(message="Default job working directory is required") URI jobs) {
        this.jobs = jobs;
    }
}

